/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.util;

import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.model.HoloVersion;
import com.alibaba.hologres.client.model.Partition;
import com.alibaba.hologres.client.model.TableName;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.client.utils.IdentifierUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(ConnectionUtil.class);
    static Pattern holoVersionPattern = Pattern.compile("release-([^ )]*)");
    static Pattern hgVersionPattern = Pattern.compile("Hologres ([^ -]*)");
    private static final HoloVersion CHECK_TABLE_META_SUPPORTED_MIN_VERSION = new HoloVersion(1, 1, 50);

    public static void refreshMeta(Connection conn, int timeout) throws SQLException {
        try (Statement stat = conn.createStatement();){
            stat.execute("select hologres.hg_internal_refresh_meta(" + timeout + ")");
        }
    }

    /*
     * Exception decompiling
     */
    public static CheckMetaResult checkMeta(Connection conn, HoloVersion version, String fullName, int timeout) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static HoloVersion getHoloVersion(Connection conn) throws SQLException {
        Throwable throwable = null;
        try (Statement stmt = conn.createStatement();){
            String hgverStr = ConnectionUtil.parseSingleCell(stmt.executeQuery("select hg_version()"));
            HoloVersion holoVersion = ConnectionUtil.parseHgVersion(hgverStr);
            return holoVersion;
        }
        catch (Exception hgverStr) {
        }
        catch (Throwable hgverStr) {
            throwable = hgverStr;
            throw hgverStr;
        }
        stmt = conn.createStatement();
        throwable = null;
        try {
            String verStr = ConnectionUtil.parseSingleCell(stmt.executeQuery("select version()"));
            HoloVersion holoVersion = ConnectionUtil.parseHoloVersion(verStr);
            return holoVersion;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (stmt != null) {
                if (throwable != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    public static HoloVersion parseHgVersion(String verStr) throws Exception {
        String v;
        HoloVersion hv;
        Matcher matcher = hgVersionPattern.matcher(verStr);
        if (matcher.find() && !(hv = new HoloVersion(v = matcher.group(1))).isUndefined()) {
            return hv;
        }
        throw new Exception("Failed to parse hg_version() result");
    }

    public static HoloVersion parseHoloVersion(String verStr) {
        Matcher matcher = holoVersionPattern.matcher(verStr);
        if (matcher.find()) {
            String v = matcher.group(1);
            return new HoloVersion(v);
        }
        return null;
    }

    public static String getDatabase(Connection conn) throws SQLException {
        try (Statement stat = conn.createStatement();){
            String string = ConnectionUtil.parseSingleCell(stat.executeQuery("select current_database()"));
            return string;
        }
    }

    public static int getPartitionColumnIndex(Connection conn, String schemaName, String tableName) throws SQLException {
        StringBuilder sb = new StringBuilder(512);
        sb.append("SELECT n.nspname as Schema, c.relname as Name,\n");
        sb.append("    part.partstrat,\n");
        sb.append("    part.partnatts,\n");
        sb.append("    part.partattrs\n");
        sb.append("FROM pg_catalog.pg_class c\n");
        sb.append("JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace\n");
        sb.append("JOIN pg_catalog.pg_partitioned_table part ON c.oid = part.partrelid\n");
        sb.append("where n.nspname=? and c.relname=? \n");
        sb.append("limit 1;\n");
        String sql = sb.toString();
        ResultSet rs = null;
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, schemaName);
            stmt.setString(2, tableName);
            rs = stmt.executeQuery();
            if (rs.next()) {
                String strategyStr = rs.getString("partstrat");
                if (!"l".equals(strategyStr)) {
                    throw new SQLException("Only LIST partition is supported in holo.");
                }
                String partColumnStr = rs.getString("partattrs");
                int partColumnPos = Integer.parseInt(partColumnStr);
                int n = partColumnPos - 1;
                return n;
            }
        }
        return -1;
    }

    public static Partition getPartition(Connection conn, String schemaName, String tableName, String partValue, boolean isStr) throws SQLException {
        StringBuilder sb = new StringBuilder(512);
        sb.append("with inh as ( \n");
        sb.append("    SELECT i.inhrelid, i.inhparent \n");
        sb.append("    FROM pg_catalog.pg_class c \n");
        sb.append("    LEFT JOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace \n");
        sb.append("    LEFT JOIN pg_catalog.pg_inherits i on c.oid=i.inhparent \n");
        sb.append("    where n.nspname=? and c.relname=? \n");
        sb.append(") \n");
        sb.append("select \n");
        sb.append("    n.nspname as schema_name, \n");
        sb.append("    c.relname as table_name, \n");
        sb.append("    inh.inhrelid, inh.inhparent, p.partstrat, \n");
        sb.append("    pg_get_expr(c.relpartbound, c.oid, true) as part_expr, \n");
        sb.append("    p.partdefid, \n");
        sb.append("    p.partnatts, \n");
        sb.append("    p.partattrs \n");
        sb.append("from inh \n");
        sb.append("join pg_catalog.pg_class c on inh.inhrelid = c.oid \n");
        sb.append("join pg_catalog.pg_namespace n on c.relnamespace = n.oid \n");
        sb.append("join pg_partitioned_table p on p.partrelid = inh.inhparent where pg_get_expr(c.relpartbound, c.oid, true)=? limit 1 \n");
        String sql = sb.toString();
        ResultSet rs = null;
        Partition partition = null;
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, schemaName);
            stmt.setString(2, tableName);
            stmt.setString(3, "FOR VALUES IN (" + (isStr ? "'" : "") + partValue + (isStr ? "'" : "") + ")");
            rs = stmt.executeQuery();
            if (rs.next()) {
                String strategyStr = rs.getString("partstrat");
                if (!"l".equals(strategyStr)) {
                    throw new SQLException("Only LIST partition is supported in holo.");
                }
                partition = new Partition();
                partition.setParentSchemaName(schemaName);
                partition.setParentTableName(tableName);
                String schema = rs.getString("schema_name");
                String table = rs.getString("table_name");
                partition.setSchemaName(schema);
                partition.setTableName(table);
                partition.setPartitionValue(partValue);
            }
            Partition partition2 = partition;
            return partition2;
        }
    }

    public static Partition retryCreatePartitionChildTable(Connection conn, String schemaName, String tableName, String partValue, boolean isStr) throws SQLException {
        int retry = 0;
        while (true) {
            Statement stmt = null;
            String childSchemaName = schemaName;
            String childTableName = retry == 0 ? String.format("%s_%s", tableName, partValue) : String.format("%s_%s_%d", tableName, partValue, System.currentTimeMillis());
            try {
                String valueStr = null;
                valueStr = isStr ? String.format("'%s'", partValue) : partValue;
                String sql = String.format("create table %s.%s partition of %s.%s for values in (%s);", IdentifierUtil.quoteIdentifier(childSchemaName, true), IdentifierUtil.quoteIdentifier(childTableName, true), IdentifierUtil.quoteIdentifier(schemaName, true), IdentifierUtil.quoteIdentifier(tableName, true), valueStr);
                stmt = conn.createStatement();
                stmt.execute(sql);
                Partition partition = new Partition();
                partition.setTableName(childTableName);
                partition.setSchemaName(childSchemaName);
                partition.setParentTableName(tableName);
                partition.setParentSchemaName(schemaName);
                partition.setPartitionValue(valueStr);
                Partition partition2 = partition;
                return partition2;
            }
            catch (SQLException e) {
                String alreadyExistMsg = String.format("relation \"%s\" already exists", childTableName);
                if (e.getMessage().indexOf(alreadyExistMsg) != -1 && retry < 20) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++retry;
                    continue;
                }
                throw e;
            }
            finally {
                if (stmt == null) continue;
                stmt.close();
                continue;
            }
            break;
        }
    }

    public static TableSchema getTableSchema(Connection conn, TableName tableName) throws SQLException {
        Object columns = null;
        Object types = null;
        Object typeNames = null;
        ArrayList<String> primaryKeyList = new ArrayList<String>();
        try (ResultSet rs = conn.getMetaData().getPrimaryKeys(null, tableName.getSchemaName(), tableName.getTableName());){
            while (rs.next()) {
                primaryKeyList.add(rs.getString(4));
            }
        }
        ArrayList<Column> columnList = new ArrayList<Column>();
        try (ResultSet rs = conn.getMetaData().getColumns(null, tableName.getSchemaName(), tableName.getTableName(), "%");){
            while (rs.next()) {
                Column column = new Column();
                column.setName(rs.getString(4));
                column.setType(rs.getInt(5));
                column.setTypeName(rs.getString(6));
                column.setPrecision(rs.getInt(7));
                column.setScale(rs.getInt(9));
                column.setAllowNull(rs.getInt(11) == 1);
                column.setComment(rs.getString(12));
                column.setDefaultValue(rs.getObject(13));
                column.setArrayType(column.getTypeName().startsWith("_"));
                column.setPrimaryKey(primaryKeyList.contains(column.getName()));
                columnList.add(column);
            }
        }
        int partitionColumnIndex = ConnectionUtil.getPartitionColumnIndex(conn, tableName.getSchemaName(), tableName.getTableName());
        String sql = "select property_key,property_value from hologres.hg_table_properties where table_namespace=? and table_name=? and property_key in ('distribution_key','table_id','schema_version','orientation','clustering_key','segment_key','bitmap_columns','dictionary_encoding_columns','time_to_live_in_seconds')";
        Object distributionKeys = null;
        String tableId = null;
        String schemaVersion = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        PreparedStatement stat = conn.prepareStatement(sql);
        Object object = null;
        try {
            stat.setString(1, tableName.getSchemaName());
            stat.setString(2, tableName.getTableName());
            try (ResultSet resultSet = stat.executeQuery();){
                while (resultSet.next()) {
                    String propertyName = resultSet.getString(1);
                    String propertyValue = resultSet.getString(2);
                    properties.put(propertyName, propertyValue);
                }
            }
            tableId = (String)properties.get("table_id");
            schemaVersion = (String)properties.get("schema_version");
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (stat != null) {
                if (object != null) {
                    try {
                        stat.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    stat.close();
                }
            }
        }
        if (properties.size() == 0) {
            throw new SQLException("can not found table " + tableName.getFullName());
        }
        if (tableId == null) {
            throw new SQLException("table " + tableName.getFullName() + " has no table_id");
        }
        if (schemaVersion == null) {
            throw new SQLException("table " + tableName.getFullName() + " has no schemaVersion");
        }
        TableSchema.Builder builder = new TableSchema.Builder(tableId, schemaVersion);
        builder.setPartitionColumnIndex(partitionColumnIndex);
        builder.setColumns(columnList);
        builder.setTableName(tableName);
        builder.setNotExist(false);
        builder.setSensitive(true);
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            switch (key) {
                case "distribution_key": {
                    builder.setDistributionKeys(value.split(","));
                    break;
                }
                case "orientation": {
                    builder.setOrientation(value);
                    break;
                }
                case "clustering_key": {
                    builder.setClusteringKey(value.split(","));
                    break;
                }
                case "segment_key": {
                    builder.setSegmentKey(value.split(","));
                    break;
                }
                case "bitmap_columns": {
                    builder.setBitmapIndexKey(value.split(","));
                    break;
                }
                case "dictionary_encoding_columns": {
                    builder.setDictionaryEncoding(value.split(","));
                    break;
                }
                case "time_to_live_in_seconds": {
                    builder.setLifecycle(Long.parseLong(value));
                    break;
                }
            }
        }
        TableSchema tableSchema = builder.build();
        tableSchema.calculateProperties();
        return tableSchema;
    }

    private static String parseSingleCell(ResultSet rs) throws SQLException {
        String ret = null;
        if (rs.next()) {
            ret = rs.getString(1);
        }
        return ret;
    }

    public static class CheckMetaResult {
        boolean updated;
        String msg;

        public CheckMetaResult(boolean updated, String msg) {
            this.updated = updated;
            this.msg = msg;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

