/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler.jdbc;

import com.alibaba.hologres.client.impl.handler.jdbc.JdbcColumnValues;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Date;

public class JdbcLongColumnValues
extends JdbcColumnValues {
    Long[] array;

    public JdbcLongColumnValues(TimestampUtils timestampUtils, int rowCount) {
        super(timestampUtils, rowCount);
        this.array = new Long[rowCount];
    }

    @Override
    public void doSet(int row, Object obj) throws SQLException {
        this.array[row] = JdbcLongColumnValues.castToLong(obj);
    }

    private static long castToLong(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Long.parseLong((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).longValue();
            }
            if (in instanceof Date) {
                return ((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1L : 0L;
            }
            if (in instanceof Clob) {
                return Long.parseLong(JdbcLongColumnValues.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Long.parseLong(in.toString());
            }
        }
        catch (Exception e) {
            throw JdbcLongColumnValues.cannotCastException(in.getClass().getName(), "long", e);
        }
        throw JdbcLongColumnValues.cannotCastException(in.getClass().getName(), "long");
    }

    @Override
    public Object[] getArray() {
        return this.array;
    }
}

