/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler.jdbc;

import com.alibaba.hologres.client.impl.handler.jdbc.JdbcColumnValues;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Date;

public class JdbcIntegerColumnValues
extends JdbcColumnValues {
    Integer[] array;

    public JdbcIntegerColumnValues(TimestampUtils timestampUtils, int rowCount) {
        super(timestampUtils, rowCount);
        this.array = new Integer[rowCount];
    }

    @Override
    public void doSet(int row, Object obj) throws SQLException {
        this.array[row] = JdbcIntegerColumnValues.castToInt(obj);
    }

    private static int castToInt(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Integer.parseInt((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).intValue();
            }
            if (in instanceof Date) {
                return (int)((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1 : 0;
            }
            if (in instanceof Clob) {
                return Integer.parseInt(JdbcIntegerColumnValues.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Integer.parseInt(in.toString());
            }
        }
        catch (Exception e) {
            throw JdbcIntegerColumnValues.cannotCastException(in.getClass().getName(), "int", e);
        }
        throw JdbcIntegerColumnValues.cannotCastException(in.getClass().getName(), "int");
    }

    @Override
    public Object[] getArray() {
        return this.array;
    }
}

