/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler.jdbc;

import com.alibaba.hologres.client.impl.handler.jdbc.JdbcColumnValues;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Date;

public class JdbcFloatColumnValues
extends JdbcColumnValues {
    Float[] array;

    public JdbcFloatColumnValues(TimestampUtils timestampUtils, int rowCount) {
        super(timestampUtils, rowCount);
        this.array = new Float[rowCount];
    }

    @Override
    public void doSet(int row, Object obj) throws SQLException {
        this.array[row] = Float.valueOf(JdbcFloatColumnValues.castToFloat(obj));
    }

    private static float castToFloat(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                return Float.parseFloat((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).floatValue();
            }
            if (in instanceof Date) {
                return ((Date)in).getTime();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0f : 0.0f;
            }
            if (in instanceof Clob) {
                return Float.parseFloat(JdbcFloatColumnValues.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Float.parseFloat(in.toString());
            }
        }
        catch (Exception e) {
            throw JdbcFloatColumnValues.cannotCastException(in.getClass().getName(), "float", e);
        }
        throw JdbcFloatColumnValues.cannotCastException(in.getClass().getName(), "float");
    }

    @Override
    public Object[] getArray() {
        return this.array;
    }
}

