/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler.jdbc;

import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import com.alibaba.hologres.org.postgresql.util.GT;
import com.alibaba.hologres.org.postgresql.util.PSQLException;
import com.alibaba.hologres.org.postgresql.util.PSQLState;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.TimeZone;

public abstract class JdbcColumnValues {
    protected int rowCount;
    protected TimestampUtils timestampUtils;
    protected TimeZone defaultTimeZone;

    public JdbcColumnValues(TimestampUtils timestampUtils, int rowCount) {
        this.timestampUtils = timestampUtils;
        this.rowCount = rowCount;
    }

    public void set(int row, Object obj) throws SQLException {
        if (null != obj) {
            this.doSet(row, obj);
        }
    }

    protected abstract void doSet(int var1, Object var2) throws SQLException;

    public abstract Object[] getArray();

    protected static String asString(Clob in) throws SQLException {
        return in.getSubString(1L, (int)in.length());
    }

    protected Calendar getDefaultCalendar() {
        if (this.timestampUtils.hasFastDefaultTimeZone()) {
            return this.timestampUtils.getSharedCalendar(null);
        }
        Calendar sharedCalendar = this.timestampUtils.getSharedCalendar(this.defaultTimeZone);
        if (this.defaultTimeZone == null) {
            this.defaultTimeZone = sharedCalendar.getTimeZone();
        }
        return sharedCalendar;
    }

    protected static PSQLException cannotCoerceException(Object value) {
        return new PSQLException(GT.tr("Cannot cast to boolean: \"{0}\"", String.valueOf(value)), PSQLState.CANNOT_COERCE);
    }

    protected static PSQLException cannotCastException(String fromType, String toType) {
        return JdbcColumnValues.cannotCastException(fromType, toType, null);
    }

    protected static PSQLException cannotCastException(String fromType, String toType, Exception cause) {
        return new PSQLException(GT.tr("Cannot convert an instance of {0} to type {1}", fromType, toType), PSQLState.INVALID_PARAMETER_TYPE, (Throwable)cause);
    }
}

