/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.handler.jdbc;

import com.alibaba.hologres.client.impl.handler.jdbc.JdbcColumnValues;
import com.alibaba.hologres.org.postgresql.jdbc.TimestampUtils;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class JdbcByteaColumnValues
extends JdbcColumnValues {
    private static final Charset UTF8 = Charset.forName("utf-8");
    byte[][] array;

    public JdbcByteaColumnValues(TimestampUtils timestampUtils, int rowCount) {
        super(timestampUtils, rowCount);
        this.array = new byte[rowCount][];
    }

    @Override
    public void doSet(int row, Object obj) throws SQLException {
        this.array[row] = JdbcByteaColumnValues.castToBytes(obj);
    }

    private static byte[] castToBytes(Object in) throws SQLException {
        try {
            if (in instanceof byte[]) {
                return (byte[])in;
            }
            return in.toString().getBytes(UTF8);
        }
        catch (Exception e) {
            throw JdbcByteaColumnValues.cannotCastException(in.getClass().getName(), "byte[]", e);
        }
    }

    @Override
    public Object[] getArray() {
        return this.array;
    }
}

