/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.binlog;

import com.alibaba.blink.dataformat.BinaryArray;
import com.alibaba.blink.dataformat.BinaryRow;
import com.alibaba.blink.memory.MemorySegment;
import com.alibaba.blink.memory.MemorySegmentFactory;
import com.alibaba.hologres.client.exception.ExceptionCode;
import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.impl.binlog.ArrayBuffer;
import com.alibaba.hologres.client.impl.binlog.BinlogEventType;
import com.alibaba.hologres.client.impl.binlog.TableSchemaSupplier;
import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.client.model.binlog.BinlogRecord;
import com.alibaba.hologres.org.postgresql.jdbc.ArrayUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.security.InvalidParameterException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoloBinlogDecoder {
    public static final int BINLOG_PROTOCOL_VERSION = 0;
    public static final int BINLOG_HEADER_LEN = 24;
    public static final long ONE_DAY_IN_MILLIES = 86400000L;
    public static final long TIMEZONE_OFFSET = TimeZone.getDefault().getRawOffset();
    public static final Logger LOGGER = LoggerFactory.getLogger(HoloBinlogDecoder.class);
    private Column[] columns;
    private int columnCount;
    private long tableVersion = -1L;
    private TableSchema schema;
    private Boolean binlogIgnoreBeforeUpdate = false;
    private Boolean binlogIgnoreDelete = false;
    private TableSchemaSupplier tableSchemaSupplier;

    public HoloBinlogDecoder(TableSchema schema, Boolean binlogIgnoreDelete, Boolean binlogIgnoreBeforeUpdate) throws HoloClientException {
        this.binlogIgnoreDelete = binlogIgnoreDelete;
        this.binlogIgnoreBeforeUpdate = binlogIgnoreBeforeUpdate;
        this.init(schema);
    }

    public HoloBinlogDecoder(TableSchemaSupplier supplier, Boolean binlogIgnoreDelete, Boolean binlogIgnoreBeforeUpdate) throws HoloClientException {
        this.tableSchemaSupplier = supplier;
        this.binlogIgnoreDelete = binlogIgnoreDelete;
        this.binlogIgnoreBeforeUpdate = binlogIgnoreBeforeUpdate;
        this.init(supplier.apply());
    }

    public HoloBinlogDecoder(TableSchema schema) throws HoloClientException {
        this(schema, (Boolean)false, (Boolean)false);
    }

    public HoloBinlogDecoder(TableSchemaSupplier supplier) throws HoloClientException {
        this(supplier, (Boolean)false, (Boolean)false);
    }

    private static long parseSchemaVersion(TableSchema schema) throws HoloClientException {
        try {
            return Long.parseLong(schema.getSchemaVersion());
        }
        catch (Exception e) {
            throw new HoloClientException(ExceptionCode.INTERNAL_ERROR, String.format("parse schema version fail for table %s, schema version %s", schema.getTableNameObj().getFullName(), schema.getSchemaVersion()), e);
        }
    }

    private void init(TableSchema schema) throws HoloClientException {
        this.schema = schema;
        this.columns = schema.getColumnSchema();
        this.columnCount = this.columns.length;
        this.tableVersion = HoloBinlogDecoder.parseSchemaVersion(schema);
    }

    public TableSchemaSupplier getTableSchemaSupplier() {
        return this.tableSchemaSupplier;
    }

    public void setTableSchemaSupplier(TableSchemaSupplier tableSchemaSupplier) {
        this.tableSchemaSupplier = tableSchemaSupplier;
    }

    public TableSchema getSchema() {
        return this.schema;
    }

    private List<BinaryRow> deserialize(int shardId, byte[] headerBytes, byte[] dataBytes) throws HoloClientException {
        LongBuffer longBuffer = ByteBuffer.wrap(headerBytes).order(ByteOrder.BIG_ENDIAN).asLongBuffer();
        long binlogProtocolVersion = longBuffer.get(0);
        long currentTableVersion = longBuffer.get(1);
        if (0L != binlogProtocolVersion) {
            throw new IllegalStateException("binlog version mismatch, expected: 0, actual: " + binlogProtocolVersion);
        }
        if (currentTableVersion != this.tableVersion) {
            LOGGER.warn("Table {} have been altered, current client table version id is {}, binlog table version id is {}.", new Object[]{this.schema.getTableNameObj().getFullName(), this.tableVersion, currentTableVersion});
            if (this.tableSchemaSupplier != null) {
                int tryCount = 3;
                while (this.tableVersion < currentTableVersion && --tryCount > 0) {
                    this.init(this.tableSchemaSupplier.apply());
                }
                if (this.tableVersion != currentTableVersion) {
                    throw new HoloClientException(ExceptionCode.META_NOT_MATCH, String.format("binlog table version for table %s is %s but client table version is %s after refresh", this.schema.getTableNameObj().getFullName(), currentTableVersion, this.schema.getSchemaVersion()));
                }
                LOGGER.info("Table {} have been altered, update shardId [{}] current client table version id to {}.", new Object[]{this.schema.getTableNameObj().getFullName(), shardId, this.tableVersion});
            } else {
                throw new HoloClientException(ExceptionCode.META_NOT_MATCH, String.format("binlog table version for table %s is %s but client table version is %s ", this.schema.getTableNameObj().getFullName(), currentTableVersion, this.schema.getSchemaVersion()));
            }
        }
        IntBuffer buffer = ByteBuffer.wrap(dataBytes).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int rowCount = buffer.get(1);
        MemorySegment segment = MemorySegmentFactory.wrap(dataBytes);
        ArrayList<BinaryRow> rows = new ArrayList<BinaryRow>();
        for (int i = 0; i < rowCount; ++i) {
            int offsetNext;
            int offset = buffer.get(2 + i);
            int n = offsetNext = i == rowCount - 1 ? dataBytes.length : buffer.get(3 + i);
            if (offset > offsetNext) {
                throw new IllegalStateException("invalid offset in pos " + i + ", offset=" + offset + ", offsetNext=" + offsetNext);
            }
            BinaryRow row = new BinaryRow(this.columnCount + 3);
            row.pointTo(segment, offset, offsetNext - offset);
            rows.add(row);
        }
        return rows;
    }

    private void convertBinaryRowToRecord(Column column, BinaryRow currentRow, Record currentRecord, int index) throws HoloClientException {
        int offsetIndex = index + 3;
        if (currentRow.isNullAt(offsetIndex)) {
            currentRecord.setObject(index, null);
            return;
        }
        block0 : switch (column.getType()) {
            case 1: 
            case 12: 
            case 1111: {
                currentRecord.setObject(index, currentRow.getString(offsetIndex));
                break;
            }
            case 91: {
                currentRecord.setObject(index, new Date(currentRow.getLong(offsetIndex) * 86400000L));
                break;
            }
            case 92: 
            case 2013: {
                if ("timetz".equals(column.getTypeName())) {
                    long time = ByteBuffer.wrap(currentRow.getByteArray(offsetIndex)).order(ByteOrder.LITTLE_ENDIAN).asLongBuffer().get(0);
                    int zoneOffset = ByteBuffer.wrap(currentRow.getByteArray(offsetIndex)).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer().get(2);
                    currentRecord.setObject(index, new Time(time / 1000L + (long)zoneOffset * 1000L));
                    break;
                }
                currentRecord.setObject(index, new Time(currentRow.getLong(offsetIndex) / 1000L - TIMEZONE_OFFSET));
                break;
            }
            case 93: 
            case 2014: {
                if ("timestamptz".equals(column.getTypeName())) {
                    currentRecord.setObject(index, new Timestamp(currentRow.getLong(offsetIndex)));
                    break;
                }
                currentRecord.setObject(index, new Timestamp(currentRow.getLong(offsetIndex) / 1000L - TIMEZONE_OFFSET));
                break;
            }
            case 5: {
                currentRecord.setObject(index, currentRow.getShort(offsetIndex));
                break;
            }
            case 4: {
                currentRecord.setObject(index, currentRow.getInt(offsetIndex));
                break;
            }
            case -5: {
                currentRecord.setObject(index, currentRow.getLong(offsetIndex));
                break;
            }
            case 2: 
            case 3: {
                int scale = column.getScale();
                byte[] value = currentRow.getByteArray(offsetIndex);
                ArrayUtil.reverse(value);
                BigInteger bigInteger = new BigInteger(value);
                BigDecimal bigDecimal = new BigDecimal(bigInteger);
                bigDecimal = bigDecimal.movePointLeft(scale);
                bigDecimal = bigDecimal.setScale(scale, 1);
                currentRecord.setObject(index, bigDecimal);
                break;
            }
            case 6: 
            case 7: {
                currentRecord.setObject(index, Float.valueOf(currentRow.getFloat(offsetIndex)));
                break;
            }
            case 8: {
                currentRecord.setObject(index, currentRow.getDouble(offsetIndex));
                break;
            }
            case -3: 
            case -2: {
                currentRecord.setObject(index, currentRow.getByteArray(offsetIndex));
                break;
            }
            case 2003: {
                switch (column.getTypeName()) {
                    case "_int4": {
                        currentRecord.setObject(index, currentRow.getArray(offsetIndex).toIntArray());
                        break block0;
                    }
                    case "_int8": {
                        currentRecord.setObject(index, currentRow.getArray(offsetIndex).toLongArray());
                        break block0;
                    }
                    case "_float4": {
                        currentRecord.setObject(index, currentRow.getArray(offsetIndex).toFloatArray());
                        break block0;
                    }
                    case "_float8": {
                        currentRecord.setObject(index, currentRow.getArray(offsetIndex).toDoubleArray());
                        break block0;
                    }
                    case "_bool": {
                        currentRecord.setObject(index, currentRow.getArray(offsetIndex).toBooleanArray());
                        break block0;
                    }
                    case "_text": {
                        BinaryArray binaryArray = currentRow.getArray(offsetIndex);
                        String[] stringArrays = new String[binaryArray.numElements()];
                        for (int i = 0; i < binaryArray.numElements(); ++i) {
                            stringArrays[i] = binaryArray.getString(i);
                        }
                        currentRecord.setObject(index, stringArrays);
                        break block0;
                    }
                }
                break;
            }
            case -7: 
            case 16: {
                currentRecord.setObject(index, currentRow.getBoolean(offsetIndex));
                break;
            }
            default: {
                throw new HoloClientException(ExceptionCode.DATA_TYPE_ERROR, "unsupported type " + column.getType() + " type name:" + column.getTypeName());
            }
        }
    }

    public List<BinlogRecord> decode(int shardId, ByteBuffer byteBuffer) throws HoloClientException {
        ArrayBuffer<BinlogRecord> array = new ArrayBuffer<BinlogRecord>(10, BinlogRecord[].class);
        this.decode(shardId, byteBuffer, array);
        ArrayList<BinlogRecord> list = new ArrayList<BinlogRecord>();
        array.beginRead();
        while (array.remain() > 0) {
            list.add(array.pop());
        }
        return list;
    }

    public void decode(int shardId, ByteBuffer byteBuffer, ArrayBuffer<BinlogRecord> array) throws HoloClientException {
        if (byteBuffer.limit() < 24) {
            throw new IllegalStateException("Invalid ByteBuffer");
        }
        byte[] headerBytes = new byte[16];
        byte[] dataBytes = new byte[byteBuffer.limit() - 16];
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset(), headerBytes, 0, 16);
        System.arraycopy(byteBuffer.array(), byteBuffer.arrayOffset() + 16, dataBytes, 0, byteBuffer.limit() - 16);
        List<BinaryRow> list = this.deserialize(shardId, headerBytes, dataBytes);
        ArrayList<BinlogRecord> records = new ArrayList<BinlogRecord>();
        for (BinaryRow currentRow : list) {
            long lsn = currentRow.getLong(0);
            long eventType = currentRow.getLong(1);
            long timestamp = currentRow.getLong(2);
            BinlogEventType type = null;
            try {
                type = BinlogEventType.of(eventType);
            }
            catch (InvalidParameterException e) {
                throw new HoloClientException(ExceptionCode.INTERNAL_ERROR, "unknow binlog eventtype " + eventType, e);
            }
            BinlogRecord currentRecord = new BinlogRecord(this.schema, lsn, type, timestamp);
            currentRecord.setShardId(shardId);
            if (this.binlogIgnoreDelete.booleanValue() && type == BinlogEventType.DELETE) {
                records.add(currentRecord);
                continue;
            }
            if (this.binlogIgnoreBeforeUpdate.booleanValue() && type == BinlogEventType.BEFORE_UPDATE) {
                records.add(currentRecord);
                continue;
            }
            for (int index = 0; index < this.columnCount; ++index) {
                this.convertBinaryRowToRecord(this.columns[index], currentRow, currentRecord, index);
            }
            array.add(currentRecord);
        }
    }
}

