/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl.action;

import com.alibaba.hologres.client.impl.action.AbstractAction;
import com.alibaba.hologres.client.impl.collector.BatchState;
import com.alibaba.hologres.client.model.Record;
import com.alibaba.hologres.client.model.TableSchema;
import java.security.InvalidParameterException;
import java.util.List;

public class PutAction
extends AbstractAction<Void> {
    final List<Record> recordList;
    final long byteSize;
    BatchState state;
    TableSchema schema;

    public PutAction(List<Record> recordList, long byteSize, BatchState state) {
        this.recordList = recordList;
        this.byteSize = byteSize;
        this.state = state;
        if (recordList.size() > 0) {
            this.schema = recordList.get(0).getSchema();
            for (Record record : recordList) {
                if (record.getSchema().equals(this.schema)) continue;
                throw new InvalidParameterException("Records in PutAction must for the same table. the first table is " + this.schema.getTableNameObj().getFullName() + " but found another table " + record.getSchema().getTableNameObj().getFullName());
            }
        } else {
            throw new InvalidParameterException("Empty records in PutAction is invalid");
        }
    }

    public List<Record> getRecordList() {
        return this.recordList;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public BatchState getState() {
        return this.state;
    }

    public TableSchema getSchema() {
        return this.schema;
    }
}

