/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.impl;

import com.alibaba.hologres.client.HoloConfig;
import com.alibaba.hologres.client.exception.ExceptionCode;
import com.alibaba.hologres.client.exception.HoloClientException;
import com.alibaba.hologres.client.impl.ConnectionHolder;
import com.alibaba.hologres.client.impl.ObjectChan;
import com.alibaba.hologres.client.impl.action.AbstractAction;
import com.alibaba.hologres.client.impl.action.CopyAction;
import com.alibaba.hologres.client.impl.action.EmptyAction;
import com.alibaba.hologres.client.impl.action.GetAction;
import com.alibaba.hologres.client.impl.action.MetaAction;
import com.alibaba.hologres.client.impl.action.PutAction;
import com.alibaba.hologres.client.impl.action.ScanAction;
import com.alibaba.hologres.client.impl.action.SqlAction;
import com.alibaba.hologres.client.impl.binlog.action.BinlogAction;
import com.alibaba.hologres.client.impl.binlog.handler.BinlogActionHandler;
import com.alibaba.hologres.client.impl.handler.ActionHandler;
import com.alibaba.hologres.client.impl.handler.CopyActionHandler;
import com.alibaba.hologres.client.impl.handler.EmptyActionHandler;
import com.alibaba.hologres.client.impl.handler.GetActionHandler;
import com.alibaba.hologres.client.impl.handler.MetaActionHandler;
import com.alibaba.hologres.client.impl.handler.PutActionHandler;
import com.alibaba.hologres.client.impl.handler.ScanActionHandler;
import com.alibaba.hologres.client.impl.handler.SqlActionHandler;
import com.alibaba.hologres.client.utils.Metrics;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker
implements Runnable {
    public static final Logger LOGGER = LoggerFactory.getLogger(Worker.class);
    final ConnectionHolder connectionHolder;
    ObjectChan<AbstractAction> recordCollector = new ObjectChan();
    final AtomicBoolean started;
    final HoloConfig config;
    AtomicReference<Throwable> fatal = new AtomicReference<Object>(null);
    private final String name;
    Map<Class, ActionHandler> handlerMap = new HashMap<Class, ActionHandler>();

    public Worker(HoloConfig config, AtomicBoolean started, int index, boolean isShardEnv) {
        this.config = config;
        this.connectionHolder = new ConnectionHolder(config, this, isShardEnv);
        this.started = started;
        this.name = "Worker-" + index;
        this.handlerMap.put(EmptyAction.class, new EmptyActionHandler(config));
        this.handlerMap.put(GetAction.class, new GetActionHandler(this.connectionHolder, config));
        this.handlerMap.put(MetaAction.class, new MetaActionHandler(this.connectionHolder, config));
        this.handlerMap.put(SqlAction.class, new SqlActionHandler(this.connectionHolder, config));
        this.handlerMap.put(CopyAction.class, new CopyActionHandler(this.connectionHolder, config));
        this.handlerMap.put(PutAction.class, new PutActionHandler(this.connectionHolder, config));
        this.handlerMap.put(ScanAction.class, new ScanActionHandler(this.connectionHolder, config));
        this.handlerMap.put(BinlogAction.class, new BinlogActionHandler(started, config));
    }

    public boolean offer(AbstractAction action) throws HoloClientException {
        if (this.fatal.get() != null) {
            throw new HoloClientException(ExceptionCode.INTERNAL_ERROR, "fatal", this.fatal.get());
        }
        if (action != null) {
            if (!this.started.get()) {
                throw new HoloClientException(ExceptionCode.ALREADY_CLOSE, "worker is close");
            }
            return this.recordCollector.set(action);
        }
        return this.recordCollector.set(new EmptyAction());
    }

    protected <T extends AbstractAction> void handle(T action) throws HoloClientException {
        String metricsName = null;
        long start = System.nanoTime();
        try {
            ActionHandler handler = this.handlerMap.get(action.getClass());
            if (handler == null) {
                throw new HoloClientException(ExceptionCode.INTERNAL_ERROR, "Unknown action:" + action.getClass().getName());
            }
            metricsName = handler.getCostMsMetricName();
            handler.handle(action);
        }
        catch (Throwable e) {
            if (action.getFuture() != null && !action.getFuture().isDone()) {
                action.getFuture().completeExceptionally(e);
            }
            throw e;
        }
        finally {
            long end = System.nanoTime();
            long cost = (end - start) / 1000000L;
            if (metricsName != null) {
                Metrics.registry().meter(metricsName).mark(cost);
            }
            Metrics.registry().meter("all_cost_ms").mark(cost);
        }
    }

    @Override
    public void run() {
        LOGGER.info("worker:{} start", (Object)this);
        while (this.started.get()) {
            try {
                AbstractAction action = this.recordCollector.get(2000L, TimeUnit.MILLISECONDS);
                if (null != action) {
                    try {
                        this.handle(action);
                    }
                    finally {
                        this.recordCollector.clear();
                        if (action.getSemaphore() != null) {
                            action.getSemaphore().release();
                        }
                    }
                }
                if (System.currentTimeMillis() - this.connectionHolder.getLastActiveTs() <= this.config.getConnectionMaxIdleMs()) continue;
                this.connectionHolder.close();
            }
            catch (Throwable e) {
                LOGGER.error("should not happen", e);
                this.fatal.set(e);
                break;
            }
        }
        LOGGER.info("worker:{} stop", (Object)this);
        this.connectionHolder.close();
    }

    public String toString() {
        return this.name;
    }
}

