/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hologres.client.ddl;

import com.alibaba.hologres.client.model.Column;
import com.alibaba.hologres.client.model.TableSchema;
import com.alibaba.hologres.client.utils.CommonUtil;
import java.util.ArrayList;

public class DDLGeneratorUtil {
    public static String generateCreateTableStatement(TableSchema table) {
        StringBuilder statement = new StringBuilder();
        if (table.getNotExist().booleanValue()) {
            statement.append("CREATE").append(" ").append("TABLE").append(" ").append("IF NOT EXISTS").append(" ").append(String.format("%s.%s", table.getSchemaName(), table.getTableName()));
        } else {
            statement.append("CREATE").append(" ").append("TABLE").append(" ").append(String.format("%s.%s", table.getSchemaName(), table.getTableName()));
        }
        statement.append(DDLGeneratorUtil.generateTableColumnsStatement(table.getColumnSchema()));
        if (!CommonUtil.isEmpty(table.getPartitionInfo())) {
            statement.append("\n").append(DDLGeneratorUtil.generatePartitionInfo(table.getPartitionInfo(), true));
        } else {
            statement.append(";").append("\n");
        }
        statement.append(DDLGeneratorUtil.generateTableCallStatement(table));
        return statement.toString();
    }

    public static String generatesCommentStatement(TableSchema table) {
        Column[] columns;
        StringBuilder statement = new StringBuilder();
        if (CommonUtil.isNotEmpty(table.getComment())) {
            statement.append(DDLGeneratorUtil.genCommentStatement(String.format("%s.%s", table.getSchemaName(), table.getTableName()), null, table.getComment()));
        }
        for (Column column : columns = table.getColumnSchema()) {
            if (!CommonUtil.isNotEmpty(column.getComment())) continue;
            statement.append(DDLGeneratorUtil.genCommentStatement(String.format("%s.%s", table.getSchemaName(), table.getTableName()), column.getName(), column.getComment()));
        }
        return statement.toString();
    }

    private static String generateTableColumnsStatement(Column[] columns) {
        if (columns == null || columns.length == 0) {
            return "(\n)";
        }
        StringBuilder statement = new StringBuilder();
        ArrayList<String> primaryKeyList = new ArrayList<String>();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (CommonUtil.isEmpty(column.getName())) continue;
            if (i == 0) {
                statement.append(" ").append("(").append("\n");
            } else {
                statement.append(",").append("\n");
            }
            String dataType = column.getTypeName();
            if (column.getArrayType() != null && column.getArrayType().booleanValue()) {
                dataType = dataType + "[]";
            }
            statement.append(" ").append(column.getName()).append(" ").append(dataType);
            if (!column.getAllowNull().booleanValue()) {
                statement.append(" ").append("NOT NULL");
            }
            if (column.getPrimaryKey().booleanValue()) {
                primaryKeyList.add(column.getName());
            }
            if (i != columns.length - 1) continue;
            if (!primaryKeyList.isEmpty()) {
                statement.append(",").append("\n").append("PRIMARY KEY").append(" ").append("(");
                statement.append(CommonUtil.join(primaryKeyList, ","));
                statement.append(")");
            }
            statement.append("\n").append(")");
        }
        return statement.toString();
    }

    private static String generatePartitionInfo(String partitionInfo, boolean needList) {
        if (CommonUtil.isNotEmpty(partitionInfo)) {
            if (needList) {
                return "PARTITION BY LIST(\"" + partitionInfo + "\"" + ")" + ";\n";
            }
            return "PARTITION BY " + partitionInfo + ";\n";
        }
        return "";
    }

    private static String generateTableCallStatement(TableSchema table) {
        String tableName = String.format("%s.%s", table.getSchemaName(), table.getTableName());
        StringBuilder statement = new StringBuilder();
        if (CommonUtil.isNotEmpty(table.getOrientation())) {
            statement.append(DDLGeneratorUtil.genCallPrecedureStatement(tableName, "orientation", table.getOrientation()));
        }
        if (CommonUtil.isNotEmpty(table.getClusteringKey())) {
            statement.append(DDLGeneratorUtil.genCallPrecedureStatement(tableName, "clustering_key", CommonUtil.join(table.getClusteringKey(), ",")));
        }
        if (CommonUtil.isNotEmpty(table.getSegmentKey())) {
            statement.append(DDLGeneratorUtil.genCallPrecedureStatement(tableName, "segment_key", CommonUtil.join(table.getSegmentKey(), ",")));
        }
        if (CommonUtil.isNotEmpty(table.getBitmapIndexKey())) {
            statement.append(DDLGeneratorUtil.genCallPrecedureStatement(tableName, "bitmap_columns", CommonUtil.join(table.getBitmapIndexKey(), ",")));
        }
        if (CommonUtil.isNotEmpty(table.getDictionaryEncoding())) {
            statement.append(DDLGeneratorUtil.genCallPrecedureStatement(tableName, "dictionary_encoding_columns", CommonUtil.join(table.getDictionaryEncoding(), ",")));
        }
        if (table.getLifecycle() != null) {
            statement.append(DDLGeneratorUtil.genCallPrecedureStatement(tableName, "time_to_live_in_seconds", table.getLifecycle().toString()));
        }
        return statement.toString();
    }

    private static String genCallPrecedureStatement(String tableName, String key, String value) {
        return String.format("%s('%s', '%s', '%s');\n", "CALL SET_TABLE_PROPERTY", tableName, key, value);
    }

    public static String genCommentStatement(String tableName, String columnName, String comment) {
        if (CommonUtil.isNotEmpty(columnName)) {
            return String.format("comment on column %s.%s is '%s';\n", tableName, columnName, comment.replaceAll("'", "''"));
        }
        return String.format("comment on table %s is '%s';\n", tableName, comment.replaceAll("'", "''"));
    }
}

