/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.blink.util;

import com.alibaba.blink.dataformat.BinaryRow;
import com.alibaba.blink.dataformat.BinaryString;
import com.alibaba.blink.memory.MemorySegment;
import com.alibaba.blink.memory.MemorySegmentFactory;
import com.alibaba.blink.memory.MemoryUtils;
import java.nio.ByteOrder;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import sun.misc.Unsafe;

public class BinaryRowUtil {
    public static final Unsafe UNSAFE = MemoryUtils.UNSAFE;
    public static final int BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    public static final int BOOLEAN_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(boolean[].class);
    public static final int SHORT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(short[].class);
    public static final int INT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
    public static final int LONG_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
    public static final int FLOAT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(float[].class);
    public static final int DOUBLE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(double[].class);
    public static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final int LONG_BYTES = 8;
    public static final BinaryRow EMPTY_ROW = new BinaryRow(0);

    public static int compareBoolean(boolean a, boolean b) {
        return Boolean.compare(a, b);
    }

    public static int compareByte(byte a, byte b) {
        return Byte.compare(a, b);
    }

    public static int compareShort(short a, short b) {
        return Short.compare(a, b);
    }

    public static int compareInt(int a, int b) {
        return Integer.compare(a, b);
    }

    public static int compareLong(long a, long b) {
        return Long.compare(a, b);
    }

    public static int compareFloat(float a, float b) {
        return Float.compare(a, b);
    }

    public static int compareDouble(double a, double b) {
        return Double.compare(a, b);
    }

    public static int compareChar(char a, char b) {
        return Character.compare(a, b);
    }

    public static int compareBinaryString(BinaryString a, BinaryString b) {
        return a.compareTo(b);
    }

    public static int compareDate(Date a, Date b) {
        return a.compareTo(b);
    }

    public static int compareTime(Time a, Time b) {
        return a.compareTo(b);
    }

    public static int compareTimestamp(Timestamp a, Timestamp b) {
        return a.compareTo(b);
    }

    public static int compareByteArray(byte[] a, byte[] b) {
        return BinaryRowUtil.compareByteArray(a, 0, a.length, b, 0, b.length);
    }

    public static int compareByteArray(byte[] buffer1, int offset1, int length1, byte[] buffer2, int offset2, int length2) {
        int i;
        if (buffer1 == buffer2 && offset1 == offset2 && length1 == length2) {
            return 0;
        }
        int minLength = Math.min(length1, length2);
        int minWords = minLength / 8;
        int offset1Adj = offset1 + BYTE_ARRAY_BASE_OFFSET;
        int offset2Adj = offset2 + BYTE_ARRAY_BASE_OFFSET;
        for (i = 0; i < minWords * 8; i += 8) {
            int y;
            long rw;
            long lw = UNSAFE.getLong(buffer1, (long)offset1Adj + (long)i);
            long diff = lw ^ (rw = UNSAFE.getLong(buffer2, (long)offset2Adj + (long)i));
            if (diff == 0L) continue;
            if (!LITTLE_ENDIAN) {
                return BinaryRowUtil.lessThanUnsigned(lw, rw) ? -1 : 1;
            }
            int n = 0;
            int x = (int)diff;
            if (x == 0) {
                x = (int)(diff >>> 32);
                n = 32;
            }
            if ((y = x << 16) == 0) {
                n += 16;
            } else {
                x = y;
            }
            y = x << 8;
            if (y == 0) {
                n += 8;
            }
            return (int)((lw >>> n & 0xFFL) - (rw >>> n & 0xFFL));
        }
        for (i = minWords * 8; i < minLength; ++i) {
            int result = BinaryRowUtil.unsignedByteToInt(buffer1[offset1 + i]) - BinaryRowUtil.unsignedByteToInt(buffer2[offset2 + i]);
            if (result == 0) continue;
            return result;
        }
        return length1 - length2;
    }

    private static int unsignedByteToInt(byte value) {
        return value & 0xFF;
    }

    private static boolean lessThanUnsigned(long x1, long x2) {
        return x1 + Long.MIN_VALUE < x2 + Long.MIN_VALUE;
    }

    public static int hashInt(int value) {
        return Integer.hashCode(value);
    }

    public static int hashLong(long value) {
        return Long.hashCode(value);
    }

    public static int hashShort(short value) {
        return Short.hashCode(value);
    }

    public static int hashByte(byte value) {
        return Byte.hashCode(value);
    }

    public static int hashFloat(float value) {
        return Float.hashCode(value);
    }

    public static int hashDouble(double value) {
        return Double.hashCode(value);
    }

    public static int hashBoolean(boolean value) {
        return Boolean.hashCode(value);
    }

    public static int hashChar(char value) {
        return Character.hashCode(value);
    }

    public static int hashObject(Object value) {
        return value.hashCode();
    }

    public static int hashString(BinaryString value) {
        return value.hashCode();
    }

    public static void minNormalizedKey(MemorySegment target, int offset, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            target.put(offset + i, (byte)0);
        }
    }

    public static void maxNormalizedKey(MemorySegment target, int offset, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            target.put(offset + i, (byte)-1);
        }
    }

    public static void putBinaryStringNormalizedKey(BinaryString value, MemorySegment target, int offset, int numBytes) {
        int i;
        int limit = offset + numBytes;
        int end = value.numBytes();
        for (i = 0; i < end && offset < limit; ++i) {
            target.put(offset++, value.getByte(i));
        }
        for (i = offset; i < limit; ++i) {
            target.put(i, (byte)0);
        }
    }

    public static void putByteArrayNormalizedKey(byte[] value, MemorySegment target, int offset, int numBytes) {
        int i;
        int limit = offset + numBytes;
        int end = value.length;
        for (i = 0; i < end && offset < limit; ++i) {
            target.put(offset++, value[i]);
        }
        for (i = offset; i < limit; ++i) {
            target.put(i, (byte)0);
        }
    }

    public static boolean byteArrayEquals(byte[] left, byte[] right, int length) {
        return BinaryRowUtil.byteArrayEquals(left, BYTE_ARRAY_BASE_OFFSET, right, BYTE_ARRAY_BASE_OFFSET, length);
    }

    public static boolean byteArrayEquals(Object left, long leftOffset, Object right, long rightOffset, int length) {
        int i;
        for (i = 0; i <= length - 8; i += 8) {
            if (UNSAFE.getLong(left, leftOffset + (long)i) == UNSAFE.getLong(right, rightOffset + (long)i)) continue;
            return false;
        }
        while (i < length) {
            if (UNSAFE.getByte(left, leftOffset + (long)i) != UNSAFE.getByte(right, rightOffset + (long)i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(MemorySegment[] segments1, int offset1, MemorySegment[] segments2, int offset2, int len) {
        if (BinaryRowUtil.allInFirstSeg(segments1, offset1, len) && BinaryRowUtil.allInFirstSeg(segments2, offset2, len)) {
            return segments1[0].equalTo(segments2[0], offset1, offset2, len);
        }
        return BinaryRowUtil.equalsSlow(segments1, offset1, segments2, offset2, len);
    }

    public static boolean equalsSlow(MemorySegment[] segments1, int offset1, MemorySegment[] segments2, int offset2, int len) {
        if (len == 0) {
            return true;
        }
        int segSize1 = segments1[0].size();
        int segSize2 = segments2[0].size();
        int segIndex1 = offset1 / segSize1;
        int segIndex2 = offset2 / segSize2;
        int segOffset1 = offset1 - segSize1 * segIndex1;
        int segOffset2 = offset2 - segSize2 * segIndex2;
        while (len > 0) {
            int equalLen = Math.min(Math.min(len, segSize1 - segOffset1), segSize2 - segOffset2);
            if (!segments1[segIndex1].equalTo(segments2[segIndex2], segOffset1, segOffset2, equalLen)) {
                return false;
            }
            len -= equalLen;
            if ((segOffset1 += equalLen) == segSize1) {
                segOffset1 = 0;
                ++segIndex1;
            }
            if ((segOffset2 += equalLen) != segSize2) continue;
            segOffset2 = 0;
            ++segIndex2;
        }
        return true;
    }

    public static byte[] copy(MemorySegment[] segments, int offset, int numBytes) {
        return BinaryRowUtil.copy(segments, offset, new byte[numBytes], 0, numBytes);
    }

    public static byte[] copy(MemorySegment[] segments, int offset, byte[] bytes, int bytesOffset, int numBytes) {
        if (BinaryRowUtil.allInFirstSeg(segments, offset, numBytes)) {
            segments[0].get(offset, bytes, bytesOffset, numBytes);
        } else {
            BinaryRowUtil.copySlow(segments, offset, bytes, bytesOffset, numBytes);
        }
        return bytes;
    }

    public static void copySlow(MemorySegment[] segments, int offset, byte[] bytes, int numBytes) {
        BinaryRowUtil.copySlow(segments, offset, bytes, 0, numBytes);
    }

    public static void copySlow(MemorySegment[] segments, int offset, byte[] bytes, int bytesOffset, int numBytes) {
        int remainSize = numBytes;
        for (MemorySegment segment : segments) {
            int remain = segment.size() - offset;
            if (remain > 0) {
                int nCopy = Math.min(remain, remainSize);
                segment.get(offset, bytes, numBytes - remainSize + bytesOffset, nCopy);
                offset = 0;
                if ((remainSize -= nCopy) != 0) continue;
                return;
            }
            offset = -remain;
        }
    }

    public static void copyToUnsafe(MemorySegment[] segments, int offset, Object target, int pointer, int numBytes) {
        if (segments.length == 1) {
            segments[0].copyToUnsafe(offset, target, pointer, numBytes);
        } else {
            BinaryRowUtil.copyToUnsafeSlow(segments, offset, target, pointer, numBytes);
        }
    }

    private static void copyToUnsafeSlow(MemorySegment[] segments, int offset, Object target, int pointer, int numBytes) {
        int remainSize = numBytes;
        for (MemorySegment segment : segments) {
            int remain = segment.size() - offset;
            if (remain > 0) {
                int nCopy = Math.min(remain, remainSize);
                segment.copyToUnsafe(offset, target, numBytes - remainSize + pointer, nCopy);
                offset = 0;
                if ((remainSize -= nCopy) != 0) continue;
                return;
            }
            offset = -remain;
        }
    }

    public static void copyFromBytes(MemorySegment[] segments, int offset, byte[] target, int pointer, int numBytes) {
        BinaryRowUtil.copyFromUnsafe(segments, offset, target, BYTE_ARRAY_BASE_OFFSET + pointer, numBytes);
    }

    public static void copyFromUnsafe(MemorySegment[] segments, int offset, Object target, int pointer, int numBytes) {
        if (segments.length == 1) {
            segments[0].copyFromUnsafe(offset, target, pointer, numBytes);
        } else {
            BinaryRowUtil.copyFromUnsafeSlow(segments, offset, target, pointer, numBytes);
        }
    }

    private static void copyFromUnsafeSlow(MemorySegment[] segments, int offset, Object target, int pointer, int numBytes) {
        int remainSize = numBytes;
        for (MemorySegment segment : segments) {
            int remain = segment.size() - offset;
            if (remain > 0) {
                int nCopy = Math.min(remain, remainSize);
                segment.copyFromUnsafe(offset, target, numBytes - remainSize + pointer, nCopy);
                offset = 0;
                if ((remainSize -= nCopy) != 0) continue;
                return;
            }
            offset = -remain;
        }
    }

    private static boolean allInFirstSeg(MemorySegment[] segments, int offset, int numBytes) {
        return numBytes + offset <= segments[0].size();
    }

    public static int find(MemorySegment[] segments1, int offset1, int numBytes1, MemorySegment[] segments2, int offset2, int numBytes2) {
        if (numBytes2 == 0) {
            return offset1;
        }
        if (BinaryRowUtil.allInFirstSeg(segments1, offset1, numBytes1) && BinaryRowUtil.allInFirstSeg(segments2, offset2, numBytes2)) {
            byte first = segments2[0].get(offset2);
            int end = numBytes1 - numBytes2 + offset1;
            for (int i = offset1; i <= end; ++i) {
                if (segments1[0].get(i) != first || !segments1[0].equalTo(segments2[0], i, offset2, numBytes2)) continue;
                return i;
            }
            return -1;
        }
        return BinaryRowUtil.findSlow(segments1, offset1, numBytes1, segments2, offset2, numBytes2);
    }

    private static int findSlow(MemorySegment[] segments1, int offset1, int numBytes1, MemorySegment[] segments2, int offset2, int numBytes2) {
        int end = numBytes1 - numBytes2 + offset1;
        for (int i = offset1; i <= end; ++i) {
            if (!BinaryRowUtil.equalsSlow(segments1, i, segments2, offset2, numBytes2)) continue;
            return i;
        }
        return -1;
    }

    static {
        int size = EMPTY_ROW.getFixedLengthPartSize();
        byte[] bytes = new byte[size];
        EMPTY_ROW.pointTo(MemorySegmentFactory.wrap(bytes), 0, size);
    }
}

