/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.blink.dataformat;

import com.alibaba.blink.dataformat.BinaryRow;
import com.alibaba.blink.dataformat.BinaryWriter;
import com.alibaba.blink.memory.MemorySegmentFactory;
import com.alibaba.blink.util.BitSetUtil;

public class BinaryRowWriter
extends BinaryWriter {
    private final int nullBitsSizeInBytes;
    private final BinaryRow row;
    private final int fixedSize;

    public BinaryRowWriter(BinaryRow row) {
        this(row, 0);
    }

    public BinaryRowWriter(BinaryRow row, int initialSize) {
        this.nullBitsSizeInBytes = BinaryRow.calculateBitSetWidthInBytes(row.getArity());
        this.cursor = this.fixedSize = row.getFixedLengthPartSize();
        this.segment = MemorySegmentFactory.wrap(new byte[this.fixedSize + initialSize]);
        this.row = row;
        this.row.pointTo(this.segment, 0, this.segment.size());
    }

    public void reset() {
        this.resetCursor();
        for (int i = 0; i < this.nullBitsSizeInBytes; i += 8) {
            this.segment.putLong(i, 0L);
        }
    }

    public void resetCursor() {
        this.cursor = this.fixedSize;
    }

    public void setNullAt(int pos) {
        BitSetUtil.set(this.segment, 0, pos + 8);
        this.segment.putLong(this.getFieldOffset(pos), 0L);
    }

    @Override
    public int getFieldOffset(int pos) {
        return this.nullBitsSizeInBytes + 8 * pos;
    }

    @Override
    public void setOffsetAndSize(int pos, int offset, long size) {
        long offsetAndSize = (long)offset << 32 | size;
        this.segment.putLong(this.getFieldOffset(pos), offsetAndSize);
    }

    public void writeHeader(byte header) {
        this.segment.put(0, header);
    }

    @Override
    public void writeBoolean(int pos, boolean value) {
        this.segment.putBoolean(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeByte(int pos, byte value) {
        this.segment.put(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeShort(int pos, short value) {
        this.segment.putShort(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeInt(int pos, int value) {
        this.segment.putInt(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeLong(int pos, long value) {
        this.segment.putLong(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeFloat(int pos, float value) {
        if (Float.isNaN(value)) {
            value = Float.NaN;
        }
        this.segment.putFloat(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeDouble(int pos, double value) {
        if (Double.isNaN(value)) {
            value = Double.NaN;
        }
        this.segment.putDouble(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeChar(int pos, char value) {
        this.segment.putChar(this.getFieldOffset(pos), value);
    }

    @Override
    public void afterGrow() {
        this.row.pointTo(this.segment, 0, this.segment.size());
    }

    public void complete() {
        this.row.setTotalSize(this.cursor);
    }
}

