/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.eclipse.jetty.io;

import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.io.ByteBufferPool;
import com.alibaba.lindorm.thirdparty.org.eclipse.jetty.util.BufferUtil;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ArrayByteBufferPool
implements ByteBufferPool {
    private final int _min;
    private final Bucket[] _direct;
    private final Bucket[] _indirect;
    private final int _inc;

    public ArrayByteBufferPool() {
        this(0, 1024, 65536);
    }

    public ArrayByteBufferPool(int minSize, int increment2, int maxSize) {
        if (minSize >= increment2) {
            throw new IllegalArgumentException("minSize >= increment");
        }
        if (maxSize % increment2 != 0 || increment2 >= maxSize) {
            throw new IllegalArgumentException("increment must be a divisor of maxSize");
        }
        this._min = minSize;
        this._inc = increment2;
        this._direct = new Bucket[maxSize / increment2];
        this._indirect = new Bucket[maxSize / increment2];
        int size = 0;
        for (int i = 0; i < this._direct.length; ++i) {
            this._direct[i] = new Bucket(size += this._inc);
            this._indirect[i] = new Bucket(size);
        }
    }

    @Override
    public ByteBuffer acquire(int size, boolean direct) {
        ByteBuffer buffer;
        Bucket bucket = this.bucketFor(size, direct);
        ByteBuffer byteBuffer = buffer = bucket == null ? null : bucket._queue.poll();
        if (buffer == null) {
            int capacity = bucket == null ? size : bucket._size;
            buffer = direct ? BufferUtil.allocateDirect(capacity) : BufferUtil.allocate(capacity);
        }
        return buffer;
    }

    @Override
    public void release(ByteBuffer buffer) {
        Bucket bucket;
        if (buffer != null && (bucket = this.bucketFor(buffer.capacity(), buffer.isDirect())) != null) {
            BufferUtil.clear(buffer);
            bucket._queue.offer(buffer);
        }
    }

    public void clear() {
        for (int i = 0; i < this._direct.length; ++i) {
            this._direct[i]._queue.clear();
            this._indirect[i]._queue.clear();
        }
    }

    private Bucket bucketFor(int size, boolean direct) {
        if (size <= this._min) {
            return null;
        }
        int b = (size - 1) / this._inc;
        if (b >= this._direct.length) {
            return null;
        }
        Bucket bucket = direct ? this._direct[b] : this._indirect[b];
        return bucket;
    }

    Bucket[] bucketsFor(boolean direct) {
        return direct ? this._direct : this._indirect;
    }

    public static class Bucket {
        public final int _size;
        public final Queue<ByteBuffer> _queue = new ConcurrentLinkedQueue<ByteBuffer>();

        Bucket(int size) {
            this._size = size;
        }

        public String toString() {
            return String.format("Bucket@%x{%d,%d}", this.hashCode(), this._size, this._queue.size());
        }
    }
}

