/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.codehaus.janino;

import com.alibaba.lindorm.thirdparty.org.codehaus.commons.compiler.CompileException;
import com.alibaba.lindorm.thirdparty.org.codehaus.commons.compiler.Location;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.CodeContext;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.IClass;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.JaninoRuntimeException;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.Mod;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.Visitor;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.util.Traverser;
import com.alibaba.lindorm.thirdparty.org.codehaus.janino.util.iterator.ReverseListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class Java {
    private Java() {
    }

    private static void setEnclosingBlockStatement(ArrayInitializerOrRvalue aiorv, BlockStatement enclosingBlockStatement) {
        if (aiorv instanceof Rvalue) {
            ((Rvalue)aiorv).setEnclosingBlockStatement(enclosingBlockStatement);
        } else if (aiorv instanceof ArrayInitializer) {
            for (ArrayInitializerOrRvalue v : ((ArrayInitializer)aiorv).values) {
                Java.setEnclosingBlockStatement(v, enclosingBlockStatement);
            }
        } else {
            throw new JaninoRuntimeException("Unexpected array or initializer class " + aiorv.getClass().getName());
        }
    }

    public static String join(Object[] a, String separator) {
        return Java.join(a, separator, 0, a.length);
    }

    public static String join(Object[] a, String separator, int off, int len) {
        if (a == null) {
            return "(null)";
        }
        if (off >= len) {
            return "";
        }
        StringBuilder sb = new StringBuilder(a[off].toString());
        ++off;
        while (off < len) {
            sb.append(separator);
            sb.append(a[off]);
            ++off;
        }
        return sb.toString();
    }

    public static class Wildcard
    implements TypeArgument {
        public static final int BOUNDS_NONE = 0;
        public static final int BOUNDS_EXTENDS = 1;
        public static final int BOUNDS_SUPER = 2;
        public final int bounds;
        public final ReferenceType referenceType;

        public Wildcard() {
            this.bounds = 0;
            this.referenceType = null;
        }

        public Wildcard(int bounds, ReferenceType referenceType) {
            assert (bounds == 1 || bounds == 2);
            this.bounds = bounds;
            assert (referenceType != null);
            this.referenceType = referenceType;
        }

        @Override
        public void accept(Visitor.TypeArgumentVisitor visitor) {
            visitor.visitWildcard(this);
        }

        public String toString() {
            return this.bounds == 1 ? "? extends " + this.referenceType : (this.bounds == 2 ? "? super " + this.referenceType : "?");
        }
    }

    public static class LocalVariable {
        public final boolean finaL;
        public final IClass type;
        public LocalVariableSlot slot;

        public LocalVariable(boolean finaL, IClass type) {
            this.finaL = finaL;
            this.type = type;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.finaL) {
                sb.append("final ");
            }
            sb.append(this.type).append(" ");
            return sb.toString();
        }

        public void setSlot(LocalVariableSlot slot) {
            this.slot = slot;
        }

        public short getSlotIndex() {
            if (this.slot == null) {
                return -1;
            }
            return this.slot.getSlotIndex();
        }
    }

    public static class LocalVariableSlot {
        private short slotIndex = (short)-1;
        private String name;
        private final IClass type;
        private CodeContext.Offset start;
        private CodeContext.Offset end;

        public LocalVariableSlot(String name, short slotNumber, IClass type) {
            this.name = name;
            this.slotIndex = slotNumber;
            this.type = type;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("local var(").append(this.name).append(", ").append(this.slotIndex);
            if (this.name != null) {
                buf.append(", ").append(this.type);
                buf.append(", ").append(this.start.offset);
                buf.append(", ").append(this.end.offset);
            }
            buf.append(")");
            return buf.toString();
        }

        public short getSlotIndex() {
            return this.slotIndex;
        }

        public void setSlotIndex(short slotIndex) {
            this.slotIndex = slotIndex;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public CodeContext.Offset getStart() {
            return this.start;
        }

        public void setStart(CodeContext.Offset start) {
            this.start = start;
        }

        public CodeContext.Offset getEnd() {
            return this.end;
        }

        public void setEnd(CodeContext.Offset end) {
            this.end = end;
        }

        public IClass getType() {
            return this.type;
        }
    }

    public static final class SimpleConstant
    extends Rvalue {
        final Object value;

        public SimpleConstant(Location location) {
            super(location);
            this.value = null;
        }

        public SimpleConstant(Location location, byte value) {
            super(location);
            this.value = value;
        }

        public SimpleConstant(Location location, short value) {
            super(location);
            this.value = value;
        }

        public SimpleConstant(Location location, int value) {
            super(location);
            this.value = value;
        }

        public SimpleConstant(Location location, long value) {
            super(location);
            this.value = value;
        }

        public SimpleConstant(Location location, float value) {
            super(location);
            this.value = Float.valueOf(value);
        }

        public SimpleConstant(Location location, double value) {
            super(location);
            this.value = value;
        }

        public SimpleConstant(Location location, char value) {
            super(location);
            this.value = Character.valueOf(value);
        }

        public SimpleConstant(Location location, boolean value) {
            super(location);
            this.value = value;
        }

        public SimpleConstant(Location location, String value) {
            super(location);
            this.value = value;
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitSimpleConstant(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitSimpleConstant(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitSimpleConstant(this);
        }

        @Override
        public String toString() {
            return "[" + this.value + ']';
        }
    }

    public static final class NullLiteral
    extends Literal {
        public NullLiteral(Location location, String value) {
            super(location, value);
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitNullLiteral(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitNullLiteral(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitNullLiteral(this);
        }
    }

    public static final class StringLiteral
    extends Literal {
        public StringLiteral(Location location, String value) {
            super(location, value);
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitStringLiteral(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitStringLiteral(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitStringLiteral(this);
        }
    }

    public static final class CharacterLiteral
    extends Literal {
        public CharacterLiteral(Location location, String value) {
            super(location, value);
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitCharacterLiteral(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitCharacterLiteral(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitCharacterLiteral(this);
        }
    }

    public static final class BooleanLiteral
    extends Literal {
        public BooleanLiteral(Location location, String value) {
            super(location, value);
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitBooleanLiteral(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitBooleanLiteral(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitBooleanLiteral(this);
        }
    }

    public static final class FloatingPointLiteral
    extends Literal {
        public FloatingPointLiteral(Location location, String value) {
            super(location, value);
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitFloatingPointLiteral(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitFloatingPointLiteral(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitFloatingPointLiteral(this);
        }
    }

    public static final class IntegerLiteral
    extends Literal {
        public IntegerLiteral(Location location, String value) {
            super(location, value);
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitIntegerLiteral(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitIntegerLiteral(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitIntegerLiteral(this);
        }
    }

    public static abstract class Literal
    extends Rvalue {
        public final String value;

        public Literal(Location location, String value) {
            super(location);
            this.value = value;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }

    public static interface ArrayInitializerOrRvalue
    extends Locatable {
    }

    public static final class ArrayInitializer
    extends Located
    implements ArrayInitializerOrRvalue {
        public final ArrayInitializerOrRvalue[] values;

        public ArrayInitializer(Location location, ArrayInitializerOrRvalue[] values) {
            super(location);
            this.values = values;
        }

        public String toString() {
            return " { (" + this.values.length + " values) }";
        }
    }

    public static final class NewInitializedArray
    extends Rvalue {
        public final ArrayType arrayType;
        public final ArrayInitializer arrayInitializer;
        public final IClass arrayIClass;

        public NewInitializedArray(Location location, ArrayType arrayType, ArrayInitializer arrayInitializer) {
            super(location);
            this.arrayType = arrayType;
            this.arrayInitializer = arrayInitializer;
            this.arrayIClass = null;
        }

        NewInitializedArray(Location location, IClass arrayIClass, ArrayInitializer arrayInitializer) {
            super(location);
            this.arrayType = null;
            this.arrayInitializer = arrayInitializer;
            this.arrayIClass = arrayIClass;
        }

        @Override
        public String toString() {
            return "new " + this.arrayType.toString() + " { ... }";
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitNewInitializedArray(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitNewInitializedArray(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitNewInitializedArray(this);
        }
    }

    public static final class NewArray
    extends Rvalue {
        public final Type type;
        public final Rvalue[] dimExprs;
        public final int dims;

        public NewArray(Location location, Type type, Rvalue[] dimExprs, int dims) {
            super(location);
            this.type = type;
            this.dimExprs = dimExprs;
            this.dims = dims;
        }

        @Override
        public String toString() {
            return "new " + this.type.toString() + "[]...";
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitNewArray(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitNewArray(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitNewArray(this);
        }
    }

    public static final class ParameterAccess
    extends Rvalue {
        public final FunctionDeclarator.FormalParameter formalParameter;

        public ParameterAccess(Location location, FunctionDeclarator.FormalParameter formalParameter) {
            super(location);
            this.formalParameter = formalParameter;
        }

        @Override
        public String toString() {
            return this.formalParameter.name;
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitParameterAccess(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitParameterAccess(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitParameterAccess(this);
        }
    }

    public static final class NewAnonymousClassInstance
    extends Rvalue {
        public final Rvalue optionalQualification;
        public final AnonymousClassDeclaration anonymousClassDeclaration;
        public final Rvalue[] arguments;

        public NewAnonymousClassInstance(Location location, Rvalue optionalQualification, AnonymousClassDeclaration anonymousClassDeclaration, Rvalue[] arguments) {
            super(location);
            this.optionalQualification = optionalQualification;
            this.anonymousClassDeclaration = anonymousClassDeclaration;
            this.arguments = arguments;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.optionalQualification != null) {
                sb.append(this.optionalQualification.toString()).append('.');
            }
            sb.append("new ").append(this.anonymousClassDeclaration.baseType.toString()).append("() { ... }");
            return sb.toString();
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitNewAnonymousClassInstance(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitNewAnonymousClassInstance(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitNewAnonymousClassInstance(this);
        }
    }

    public static final class NewClassInstance
    extends Rvalue {
        public final Rvalue optionalQualification;
        public final Type type;
        public final Rvalue[] arguments;
        protected IClass iClass;

        public NewClassInstance(Location location, Rvalue optionalQualification, Type type, Rvalue[] arguments) {
            super(location);
            this.optionalQualification = optionalQualification;
            this.type = type;
            this.arguments = arguments;
        }

        public NewClassInstance(Location location, Rvalue optionalQualification, IClass iClass, Rvalue[] arguments) {
            super(location);
            this.optionalQualification = optionalQualification;
            this.type = null;
            this.arguments = arguments;
            this.iClass = iClass;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.optionalQualification != null) {
                sb.append(this.optionalQualification.toString()).append('.');
            }
            sb.append("new ");
            if (this.type != null) {
                sb.append(this.type.toString());
            } else if (this.iClass != null) {
                sb.append(this.iClass.toString());
            } else {
                sb.append("???");
            }
            sb.append('(');
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.arguments[i].toString());
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitNewClassInstance(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitNewClassInstance(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitNewClassInstance(this);
        }
    }

    public static abstract class Invocation
    extends Rvalue {
        public final String methodName;
        public final Rvalue[] arguments;

        protected Invocation(Location location, String methodName, Rvalue[] arguments) {
            super(location);
            this.methodName = methodName;
            this.arguments = arguments;
        }
    }

    public static final class SuperclassMethodInvocation
    extends Invocation {
        public SuperclassMethodInvocation(Location location, String methodName, Rvalue[] arguments) {
            super(location, methodName, arguments);
        }

        @Override
        public String toString() {
            return "super." + this.methodName + "()";
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitSuperclassMethodInvocation(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitSuperclassMethodInvocation(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitSuperclassMethodInvocation(this);
        }
    }

    public static final class MethodInvocation
    extends Invocation {
        public final Atom optionalTarget;
        IClass.IMethod iMethod;

        public MethodInvocation(Location location, Atom optionalTarget, String methodName, Rvalue[] arguments) {
            super(location, methodName, arguments);
            this.optionalTarget = optionalTarget;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.optionalTarget != null) {
                sb.append(this.optionalTarget.toString()).append('.');
            }
            sb.append(this.methodName).append('(');
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.arguments[i].toString());
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitMethodInvocation(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitMethodInvocation(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitMethodInvocation(this);
        }
    }

    public static final class SuperConstructorInvocation
    extends ConstructorInvocation {
        public final Rvalue optionalQualification;

        public SuperConstructorInvocation(Location location, Rvalue optionalQualification, Rvalue[] arguments) {
            super(location, arguments);
            this.optionalQualification = optionalQualification;
            if (optionalQualification != null) {
                optionalQualification.setEnclosingBlockStatement(this);
            }
        }

        @Override
        public String toString() {
            return "super()";
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            ((Visitor.BlockStatementVisitor)((Object)visitor)).visitSuperConstructorInvocation(this);
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitSuperConstructorInvocation(this);
        }
    }

    public static final class AlternateConstructorInvocation
    extends ConstructorInvocation {
        public AlternateConstructorInvocation(Location location, Rvalue[] arguments) {
            super(location, arguments);
        }

        @Override
        public String toString() {
            return "this()";
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            ((Visitor.BlockStatementVisitor)((Object)visitor)).visitAlternateConstructorInvocation(this);
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitAlternateConstructorInvocation(this);
        }
    }

    public static abstract class ConstructorInvocation
    extends Atom
    implements BlockStatement {
        public final Rvalue[] arguments;
        private Scope enclosingScope;
        public Map<String, LocalVariable> localVariables;

        protected ConstructorInvocation(Location location, Rvalue[] arguments) {
            super(location);
            this.arguments = arguments;
            for (Rvalue a : arguments) {
                a.setEnclosingBlockStatement(this);
            }
        }

        @Override
        public void setEnclosingScope(Scope enclosingScope) {
            if (this.enclosingScope != null && enclosingScope != null) {
                throw new JaninoRuntimeException("Enclosing scope is already set for statement \"" + this.toString() + "\" at " + this.getLocation());
            }
            this.enclosingScope = enclosingScope;
        }

        @Override
        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        @Override
        public LocalVariable findLocalVariable(String name) {
            if (this.localVariables == null) {
                return null;
            }
            return this.localVariables.get(name);
        }
    }

    public static final class ParenthesizedExpression
    extends Lvalue {
        public final Rvalue value;

        public ParenthesizedExpression(Location location, Rvalue value) {
            super(location);
            this.value = value;
        }

        @Override
        public String toString() {
            return '(' + this.value.toString() + ')';
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitParenthesizedExpression(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitParenthesizedExpression(this);
        }

        @Override
        public void accept(Visitor.LvalueVisitor visitor) {
            visitor.visitParenthesizedExpression(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitParenthesizedExpression(this);
        }
    }

    public static final class Cast
    extends Rvalue {
        public final Type targetType;
        public final Rvalue value;

        public Cast(Location location, Type targetType, Rvalue value) {
            super(location);
            this.targetType = targetType;
            this.value = value;
        }

        @Override
        public String toString() {
            return '(' + this.targetType.toString() + ") " + this.value.toString();
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitCast(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitCast(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitCast(this);
        }
    }

    public static final class BinaryOperation
    extends BooleanRvalue {
        public final Rvalue lhs;
        public final String op;
        public final Rvalue rhs;

        public BinaryOperation(Location location, Rvalue lhs, String op, Rvalue rhs) {
            super(location);
            this.lhs = lhs;
            this.op = op;
            this.rhs = rhs;
        }

        @Override
        public String toString() {
            return this.lhs.toString() + ' ' + this.op + ' ' + this.rhs.toString();
        }

        public Iterator<Rvalue> unrollLeftAssociation() {
            Rvalue lhs;
            ArrayList<Rvalue> operands = new ArrayList<Rvalue>();
            BinaryOperation bo = this;
            while (true) {
                operands.add(bo.rhs);
                lhs = bo.lhs;
                if (!(lhs instanceof BinaryOperation) || ((BinaryOperation)lhs).op != this.op) break;
                bo = (BinaryOperation)lhs;
            }
            operands.add(lhs);
            return new ReverseListIterator<Rvalue>(operands.listIterator(operands.size()));
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitBinaryOperation(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitBinaryOperation(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitBinaryOperation(this);
        }
    }

    public static final class Instanceof
    extends Rvalue {
        public final Rvalue lhs;
        public final Type rhs;

        public Instanceof(Location location, Rvalue lhs, Type rhs) {
            super(location);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public String toString() {
            return this.lhs.toString() + " instanceof " + this.rhs.toString();
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitInstanceof(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitInstanceof(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitInstanceof(this);
        }
    }

    public static final class UnaryOperation
    extends BooleanRvalue {
        public final String operator;
        public final Rvalue operand;

        public UnaryOperation(Location location, String operator, Rvalue operand) {
            super(location);
            this.operator = operator;
            this.operand = operand;
        }

        @Override
        public String toString() {
            return this.operator + this.operand.toString();
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitUnaryOperation(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitUnaryOperation(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitUnaryOperation(this);
        }
    }

    public static final class SuperclassFieldAccessExpression
    extends Lvalue {
        public final Type optionalQualification;
        public final String fieldName;
        Rvalue value;

        public SuperclassFieldAccessExpression(Location location, Type optionalQualification, String fieldName) {
            super(location);
            this.optionalQualification = optionalQualification;
            this.fieldName = fieldName;
        }

        @Override
        public String toString() {
            return (this.optionalQualification == null ? "super." : this.optionalQualification.toString() + ".super.") + this.fieldName;
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitSuperclassFieldAccessExpression(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitSuperclassFieldAccessExpression(this);
        }

        @Override
        public void accept(Visitor.LvalueVisitor visitor) {
            visitor.visitSuperclassFieldAccessExpression(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitSuperclassFieldAccessExpression(this);
        }
    }

    public static final class FieldAccessExpression
    extends Lvalue {
        public final Atom lhs;
        public final String fieldName;
        Rvalue value;

        public FieldAccessExpression(Location location, Atom lhs, String fieldName) {
            super(location);
            this.lhs = lhs;
            this.fieldName = fieldName;
        }

        @Override
        public String toString() {
            return this.lhs.toString() + '.' + this.fieldName;
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitFieldAccessExpression(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitFieldAccessExpression(this);
        }

        @Override
        public void accept(Visitor.LvalueVisitor visitor) {
            visitor.visitFieldAccessExpression(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitFieldAccessExpression(this);
        }
    }

    public static final class ArrayAccessExpression
    extends Lvalue {
        public final Rvalue lhs;
        public final Rvalue index;

        public ArrayAccessExpression(Location location, Rvalue lhs, Rvalue index) {
            super(location);
            this.lhs = lhs;
            this.index = index;
        }

        @Override
        public String toString() {
            return this.lhs.toString() + '[' + this.index + ']';
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitArrayAccessExpression(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitArrayAccessExpression(this);
        }

        @Override
        public void accept(Visitor.LvalueVisitor visitor) {
            visitor.visitArrayAccessExpression(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitArrayAccessExpression(this);
        }
    }

    public static final class Crement
    extends Rvalue {
        public final boolean pre;
        public final String operator;
        public final Lvalue operand;

        public Crement(Location location, String operator, Lvalue operand) {
            super(location);
            this.pre = true;
            this.operator = operator;
            this.operand = operand;
        }

        public Crement(Location location, Lvalue operand, String operator) {
            super(location);
            this.pre = false;
            this.operator = operator;
            this.operand = operand;
        }

        @Override
        public String toString() {
            return this.pre ? this.operator + this.operand : this.operand + this.operator;
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitCrement(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitCrement(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitCrement(this);
        }
    }

    public static final class ConditionalExpression
    extends Rvalue {
        public final Rvalue lhs;
        public final Rvalue mhs;
        public final Rvalue rhs;

        public ConditionalExpression(Location location, Rvalue lhs, Rvalue mhs, Rvalue rhs) {
            super(location);
            this.lhs = lhs;
            this.mhs = mhs;
            this.rhs = rhs;
        }

        @Override
        public String toString() {
            return this.lhs.toString() + " ? " + this.mhs.toString() + " : " + this.rhs.toString();
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitConditionalExpression(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitConditionalExpression(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitConditionalExpression(this);
        }
    }

    public static final class Assignment
    extends Rvalue {
        public final Lvalue lhs;
        public final String operator;
        public final Rvalue rhs;

        public Assignment(Location location, Lvalue lhs, String operator, Rvalue rhs) {
            super(location);
            this.lhs = lhs;
            this.operator = operator;
            this.rhs = rhs;
        }

        @Override
        public String toString() {
            return this.lhs.toString() + ' ' + this.operator + ' ' + this.rhs.toString();
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitAssignment(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitAssignment(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitAssignment(this);
        }
    }

    public static final class ClassLiteral
    extends Rvalue {
        public final Type type;

        public ClassLiteral(Location location, Type type) {
            super(location);
            this.type = type;
        }

        @Override
        public String toString() {
            return this.type.toString() + ".class";
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitClassLiteral(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitClassLiteral(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitClassLiteral(this);
        }
    }

    public static final class QualifiedThisReference
    extends Rvalue {
        public final Type qualification;
        ClassDeclaration declaringClass;
        TypeBodyDeclaration declaringTypeBodyDeclaration;
        IClass targetIClass;

        public QualifiedThisReference(Location location, Type qualification) {
            super(location);
            if (qualification == null) {
                throw new NullPointerException();
            }
            this.qualification = qualification;
        }

        @Override
        public String toString() {
            return this.qualification.toString() + ".this";
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitQualifiedThisReference(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitQualifiedThisReference(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitQualifiedThisReference(this);
        }
    }

    public static final class ThisReference
    extends Rvalue {
        IClass iClass;

        public ThisReference(Location location) {
            super(location);
        }

        @Override
        public String toString() {
            return "this";
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitThisReference(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitThisReference(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitThisReference(this);
        }
    }

    public static final class ArrayLength
    extends Rvalue {
        public final Rvalue lhs;

        public ArrayLength(Location location, Rvalue lhs) {
            super(location);
            this.lhs = lhs;
        }

        @Override
        public String toString() {
            return this.lhs.toString() + ".length";
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitArrayLength(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitArrayLength(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitArrayLength(this);
        }
    }

    public static final class FieldAccess
    extends Lvalue {
        public final Atom lhs;
        public final IClass.IField field;

        public FieldAccess(Location location, Atom lhs, IClass.IField field) {
            super(location);
            this.lhs = lhs;
            this.field = field;
        }

        @Override
        public String toString() {
            return this.lhs.toString() + '.' + this.field.getName();
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitFieldAccess(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitFieldAccess(this);
        }

        @Override
        public void accept(Visitor.LvalueVisitor visitor) {
            visitor.visitFieldAccess(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitFieldAccess(this);
        }
    }

    public static final class LocalVariableAccess
    extends Lvalue {
        public final LocalVariable localVariable;

        public LocalVariableAccess(Location location, LocalVariable localVariable) {
            super(location);
            this.localVariable = localVariable;
        }

        @Override
        public String toString() {
            return this.localVariable.toString();
        }

        @Override
        public void accept(Visitor.LvalueVisitor visitor) {
            visitor.visitLocalVariableAccess(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitLocalVariableAccess(this);
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitLocalVariableAccess(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitLocalVariableAccess(this);
        }
    }

    public static final class Package
    extends Atom {
        public final String name;

        public Package(Location location, String name) {
            super(location);
            this.name = name;
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitPackage(this);
        }
    }

    public static final class AmbiguousName
    extends Lvalue {
        public final String[] identifiers;
        public final int n;
        private Type type;
        Atom reclassified;

        public AmbiguousName(Location location, String[] identifiers) {
            this(location, identifiers, identifiers.length);
        }

        public AmbiguousName(Location location, String[] identifiers, int n) {
            super(location);
            this.identifiers = identifiers;
            this.n = n;
        }

        @Override
        public Type toType() {
            if (this.type == null) {
                String[] is = new String[this.n];
                System.arraycopy(this.identifiers, 0, is, 0, this.n);
                this.type = new ReferenceType(this.getLocation(), is, null);
                this.type.setEnclosingScope(this.getEnclosingBlockStatement());
            }
            return this.type;
        }

        @Override
        public String toString() {
            return Java.join(this.identifiers, ".", 0, this.n);
        }

        @Override
        public Lvalue toLvalue() {
            if (this.reclassified != null) {
                return this.reclassified.toLvalue();
            }
            return this;
        }

        @Override
        public Rvalue toRvalue() {
            if (this.reclassified != null) {
                return this.reclassified.toRvalue();
            }
            return this;
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitAmbiguousName(this);
        }

        @Override
        public void accept(Visitor.RvalueVisitor visitor) {
            visitor.visitAmbiguousName(this);
        }

        @Override
        public void accept(Visitor.LvalueVisitor visitor) {
            visitor.visitAmbiguousName(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitAmbiguousName(this);
        }
    }

    public static abstract class Lvalue
    extends Rvalue {
        protected Lvalue(Location location) {
            super(location);
        }

        @Override
        public Lvalue toLvalue() {
            return this;
        }

        public abstract void accept(Visitor.LvalueVisitor var1);
    }

    public static abstract class BooleanRvalue
    extends Rvalue {
        protected BooleanRvalue(Location location) {
            super(location);
        }
    }

    public static abstract class Rvalue
    extends Atom
    implements ArrayInitializerOrRvalue,
    ElementValue {
        private BlockStatement enclosingBlockStatement;
        static final Object CONSTANT_VALUE_UNKNOWN = new Object(){

            public String toString() {
                return "CONSTANT_VALUE_UNKNOWN";
            }
        };
        Object constantValue = CONSTANT_VALUE_UNKNOWN;

        protected Rvalue(Location location) {
            super(location);
        }

        public final void setEnclosingBlockStatement(final BlockStatement enclosingBlockStatement) {
            this.accept((Visitor.RvalueVisitor)new Traverser(){

                @Override
                public void traverseRvalue(Rvalue rv) {
                    if (rv.enclosingBlockStatement != null && enclosingBlockStatement != rv.enclosingBlockStatement) {
                        throw new JaninoRuntimeException("Enclosing block statement for rvalue \"" + rv + "\" at " + rv.getLocation() + " is already set");
                    }
                    rv.enclosingBlockStatement = enclosingBlockStatement;
                    super.traverseRvalue(rv);
                }

                @Override
                public void traverseAnonymousClassDeclaration(AnonymousClassDeclaration acd) {
                    acd.setEnclosingScope(enclosingBlockStatement);
                }

                @Override
                public void traverseType(Type t) {
                    if (t.enclosingScope != null && enclosingBlockStatement != t.enclosingScope) {
                        throw new JaninoRuntimeException("Enclosing scope already set for type \"" + this.toString() + "\" at " + t.getLocation());
                    }
                    t.enclosingScope = enclosingBlockStatement;
                    super.traverseType(t);
                }
            }.comprehensiveVisitor());
        }

        public BlockStatement getEnclosingBlockStatement() {
            return this.enclosingBlockStatement;
        }

        @Override
        public Rvalue toRvalue() {
            return this;
        }

        public abstract void accept(Visitor.RvalueVisitor var1);
    }

    public static final class ArrayType
    extends Type
    implements TypeArgument {
        public final Type componentType;

        public ArrayType(Type componentType) {
            super(componentType.getLocation());
            this.componentType = componentType;
        }

        @Override
        public void setEnclosingScope(Scope enclosingScope) {
            super.setEnclosingScope(enclosingScope);
            this.componentType.setEnclosingScope(enclosingScope);
        }

        @Override
        public String toString() {
            return this.componentType.toString() + "[]";
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitArrayType(this);
        }

        @Override
        public void accept(Visitor.TypeVisitor visitor) {
            visitor.visitArrayType(this);
        }

        @Override
        public void accept(Visitor.TypeArgumentVisitor visitor) {
            visitor.visitArrayType(this);
        }
    }

    public static final class RvalueMemberType
    extends Type {
        public final Rvalue rvalue;
        public final String identifier;

        public RvalueMemberType(Location location, Rvalue rvalue, String identifier) {
            super(location);
            this.rvalue = rvalue;
            this.identifier = identifier;
        }

        @Override
        public String toString() {
            return this.identifier;
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitRvalueMemberType(this);
        }

        @Override
        public void accept(Visitor.TypeVisitor visitor) {
            visitor.visitRvalueMemberType(this);
        }
    }

    public static interface TypeArgument {
        public void accept(Visitor.TypeArgumentVisitor var1);
    }

    public static final class ReferenceType
    extends Type
    implements TypeArgument {
        public final String[] identifiers;
        public final TypeArgument[] optionalTypeArguments;

        public ReferenceType(Location location, String[] identifiers, TypeArgument[] optionalTypeArguments) {
            super(location);
            assert (identifiers != null);
            this.identifiers = identifiers;
            this.optionalTypeArguments = optionalTypeArguments;
        }

        @Override
        public String toString() {
            String s = Java.join(this.identifiers, ".");
            if (this.optionalTypeArguments != null) {
                s = s + '<' + Java.join(this.optionalTypeArguments, ", ") + ">";
            }
            return s;
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitReferenceType(this);
        }

        @Override
        public void accept(Visitor.TypeVisitor visitor) {
            visitor.visitReferenceType(this);
        }

        @Override
        public void accept(Visitor.TypeArgumentVisitor visitor) {
            visitor.visitReferenceType(this);
        }
    }

    public static final class BasicType
    extends Type {
        public final int index;
        public static final int VOID = 0;
        public static final int BYTE = 1;
        public static final int SHORT = 2;
        public static final int CHAR = 3;
        public static final int INT = 4;
        public static final int LONG = 5;
        public static final int FLOAT = 6;
        public static final int DOUBLE = 7;
        public static final int BOOLEAN = 8;

        public BasicType(Location location, int index) {
            super(location);
            this.index = index;
        }

        @Override
        public String toString() {
            switch (this.index) {
                case 0: {
                    return "void";
                }
                case 1: {
                    return "byte";
                }
                case 2: {
                    return "short";
                }
                case 3: {
                    return "char";
                }
                case 4: {
                    return "int";
                }
                case 5: {
                    return "long";
                }
                case 6: {
                    return "float";
                }
                case 7: {
                    return "double";
                }
                case 8: {
                    return "boolean";
                }
            }
            throw new JaninoRuntimeException("Invalid index " + this.index);
        }

        @Override
        public void accept(Visitor.TypeVisitor visitor) {
            visitor.visitBasicType(this);
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitBasicType(this);
        }
    }

    public static final class SimpleType
    extends Type {
        public final IClass iClass;

        public SimpleType(Location location, IClass iClass) {
            super(location);
            this.iClass = iClass;
        }

        @Override
        public String toString() {
            return this.iClass.toString();
        }

        @Override
        public void accept(Visitor.AtomVisitor visitor) {
            visitor.visitSimpleType(this);
        }

        @Override
        public void accept(Visitor.TypeVisitor visitor) {
            visitor.visitSimpleType(this);
        }
    }

    public static abstract class Type
    extends Atom {
        private Scope enclosingScope;

        protected Type(Location location) {
            super(location);
        }

        public void setEnclosingScope(Scope enclosingScope) {
            if (this.enclosingScope != null && enclosingScope != this.enclosingScope) {
                throw new JaninoRuntimeException("Enclosing scope already set for type \"" + this.toString() + "\" at " + this.getLocation());
            }
            this.enclosingScope = enclosingScope;
        }

        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        @Override
        public Type toType() {
            return this;
        }

        public abstract void accept(Visitor.TypeVisitor var1);
    }

    public static abstract class Atom
    extends Located {
        public Atom(Location location) {
            super(location);
        }

        public Type toType() {
            return null;
        }

        public Rvalue toRvalue() {
            return null;
        }

        public Lvalue toLvalue() {
            return null;
        }

        public abstract String toString();

        public final Type toTypeOrCompileException() throws CompileException {
            Type result = this.toType();
            if (result == null) {
                this.throwCompileException("Expression \"" + this.toString() + "\" is not a type");
            }
            return result;
        }

        public final Rvalue toRvalueOrCompileException() throws CompileException {
            Rvalue result = this.toRvalue();
            if (result == null) {
                this.throwCompileException("Expression \"" + this.toString() + "\" is not an rvalue");
            }
            return result;
        }

        public final Lvalue toLvalueOrCompileException() throws CompileException {
            Lvalue result = this.toLvalue();
            if (result == null) {
                this.throwCompileException("Expression \"" + this.toString() + "\" is not an lvalue");
            }
            return result;
        }

        public abstract void accept(Visitor.AtomVisitor var1);
    }

    public static final class EmptyStatement
    extends Statement {
        public EmptyStatement(Location location) {
            super(location);
        }

        public String toString() {
            return ";";
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitEmptyStatement(this);
        }
    }

    public static final class AssertStatement
    extends Statement {
        public final Rvalue expression1;
        public final Rvalue optionalExpression2;

        public AssertStatement(Location location, Rvalue expression1, Rvalue optionalExpression2) {
            super(location);
            this.expression1 = expression1;
            this.optionalExpression2 = optionalExpression2;
            this.expression1.setEnclosingBlockStatement(this);
            if (this.optionalExpression2 != null) {
                this.optionalExpression2.setEnclosingBlockStatement(this);
            }
        }

        public String toString() {
            return this.optionalExpression2 == null ? "assert " + this.expression1 + ';' : "assert " + this.expression1 + " : " + this.optionalExpression2 + ';';
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitAssertStatement(this);
        }
    }

    public static final class ContinueStatement
    extends Statement {
        public final String optionalLabel;

        public ContinueStatement(Location location, String optionalLabel) {
            super(location);
            this.optionalLabel = optionalLabel;
        }

        public String toString() {
            return this.optionalLabel == null ? "continue;" : "continue " + this.optionalLabel + ';';
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitContinueStatement(this);
        }
    }

    public static final class BreakStatement
    extends Statement {
        public final String optionalLabel;

        public BreakStatement(Location location, String optionalLabel) {
            super(location);
            this.optionalLabel = optionalLabel;
        }

        public String toString() {
            return this.optionalLabel == null ? "break;" : "break " + this.optionalLabel + ';';
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitBreakStatement(this);
        }
    }

    public static final class ThrowStatement
    extends Statement {
        public final Rvalue expression;

        public ThrowStatement(Location location, Rvalue expression) {
            super(location);
            this.expression = expression;
            this.expression.setEnclosingBlockStatement(this);
        }

        public String toString() {
            return "throw " + this.expression + ';';
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitThrowStatement(this);
        }
    }

    public static final class ReturnStatement
    extends Statement {
        public final Rvalue optionalReturnValue;

        public ReturnStatement(Location location, Rvalue optionalReturnValue) {
            super(location);
            this.optionalReturnValue = optionalReturnValue;
            if (optionalReturnValue != null) {
                optionalReturnValue.setEnclosingBlockStatement(this);
            }
        }

        public String toString() {
            return this.optionalReturnValue == null ? "return;" : "return " + this.optionalReturnValue + ';';
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitReturnStatement(this);
        }
    }

    public static final class LocalVariableDeclarationStatement
    extends Statement {
        public final Modifiers modifiers;
        public final Type type;
        public final VariableDeclarator[] variableDeclarators;

        public LocalVariableDeclarationStatement(Location location, Modifiers modifiers, Type type, VariableDeclarator[] variableDeclarators) {
            super(location);
            this.modifiers = modifiers;
            this.type = type;
            this.variableDeclarators = variableDeclarators;
            this.type.setEnclosingScope(this);
            for (VariableDeclarator vd : variableDeclarators) {
                if (vd.optionalInitializer == null) continue;
                Java.setEnclosingBlockStatement(vd.optionalInitializer, this);
            }
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitLocalVariableDeclarationStatement(this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.modifiers.flags != 0) {
                sb.append(Mod.shortToString(this.modifiers.flags)).append(' ');
            }
            sb.append(this.type).append(' ').append(this.variableDeclarators[0].toString());
            for (int i = 1; i < this.variableDeclarators.length; ++i) {
                sb.append(", ").append(this.variableDeclarators[i].toString());
            }
            return sb.append(';').toString();
        }
    }

    public static final class DoStatement
    extends ContinuableStatement {
        public final Rvalue condition;

        public DoStatement(Location location, BlockStatement body, Rvalue condition) {
            super(location, body);
            this.condition = condition;
            this.condition.setEnclosingBlockStatement(this);
        }

        public String toString() {
            return "do " + this.body + " while(" + this.condition + ");";
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitDoStatement(this);
        }
    }

    public static final class SynchronizedStatement
    extends Statement {
        public final Rvalue expression;
        public final BlockStatement body;
        short monitorLvIndex = (short)-1;

        public SynchronizedStatement(Location location, Rvalue expression, BlockStatement body) {
            super(location);
            this.expression = expression;
            this.expression.setEnclosingBlockStatement(this);
            this.body = body;
            this.body.setEnclosingScope(this);
        }

        public String toString() {
            return "synchronized(" + this.expression + ") " + this.body;
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitSynchronizedStatement(this);
        }
    }

    static class Padder
    extends CodeContext.Inserter
    implements CodeContext.FixUp {
        public Padder(CodeContext codeContext) {
        }

        @Override
        public void fixUp() {
            int x = this.offset % 4;
            if (x != 0) {
                CodeContext ca = this.getCodeContext();
                ca.pushInserter(this);
                ca.makeSpace((short)-1, 4 - x);
                ca.popInserter();
            }
        }
    }

    public static final class SwitchStatement
    extends BreakableStatement {
        public final Rvalue condition;
        public final List<SwitchBlockStatementGroup> sbsgs;

        public SwitchStatement(Location location, Rvalue condition, List<SwitchBlockStatementGroup> sbsgs) {
            super(location);
            this.condition = condition;
            this.condition.setEnclosingBlockStatement(this);
            this.sbsgs = sbsgs;
            for (SwitchBlockStatementGroup sbsg : this.sbsgs) {
                for (Rvalue cl : sbsg.caseLabels) {
                    cl.setEnclosingBlockStatement(this);
                }
                for (BlockStatement bs : sbsg.blockStatements) {
                    bs.setEnclosingScope(this);
                }
            }
        }

        public String toString() {
            return "switch (" + this.condition + ") { (" + this.sbsgs.size() + " statement groups) }";
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitSwitchStatement(this);
        }

        public static class SwitchBlockStatementGroup
        extends Located {
            public final List<Rvalue> caseLabels;
            public final boolean hasDefaultLabel;
            public final List<BlockStatement> blockStatements;

            public SwitchBlockStatementGroup(Location location, List<Rvalue> caseLabels, boolean hasDefaultLabel, List<BlockStatement> blockStatements) {
                super(location);
                this.caseLabels = caseLabels;
                this.hasDefaultLabel = hasDefaultLabel;
                this.blockStatements = blockStatements;
            }

            public String toString() {
                return this.caseLabels.size() + (this.hasDefaultLabel ? " case label(s) plus DEFAULT" : " case label(s)");
            }
        }
    }

    public static class CatchClause
    extends Located
    implements Scope {
        public final FunctionDeclarator.FormalParameter caughtException;
        public final Block body;
        private TryStatement enclosingTryStatement;
        public boolean reachable;

        public CatchClause(Location location, FunctionDeclarator.FormalParameter caughtException, Block body) {
            super(location);
            this.caughtException = caughtException;
            this.caughtException.type.setEnclosingScope(this);
            this.body = body;
            this.body.setEnclosingScope(this);
        }

        public void setEnclosingTryStatement(TryStatement enclosingTryStatement) {
            if (this.enclosingTryStatement != null && enclosingTryStatement != this.enclosingTryStatement) {
                throw new JaninoRuntimeException("Enclosing TRY statement already set for catch clause " + this.toString() + " at " + this.getLocation());
            }
            this.enclosingTryStatement = enclosingTryStatement;
        }

        @Override
        public Scope getEnclosingScope() {
            return this.enclosingTryStatement;
        }

        public String toString() {
            return "catch (" + this.caughtException + ") " + this.body;
        }
    }

    public static final class TryStatement
    extends Statement {
        public final BlockStatement body;
        public final List<CatchClause> catchClauses;
        public final Block optionalFinally;
        CodeContext.Offset finallyOffset;

        public TryStatement(Location location, BlockStatement body, List<CatchClause> catchClauses, Block optionalFinally) {
            super(location);
            this.body = body;
            this.body.setEnclosingScope(this);
            this.catchClauses = catchClauses;
            for (CatchClause cc : this.catchClauses) {
                cc.setEnclosingTryStatement(this);
            }
            this.optionalFinally = optionalFinally;
            if (optionalFinally != null) {
                optionalFinally.setEnclosingScope(this);
            }
        }

        public String toString() {
            return "try ... " + this.catchClauses.size() + (this.optionalFinally == null ? " catches" : " catches ... finally");
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitTryStatement(this);
        }
    }

    public static final class WhileStatement
    extends ContinuableStatement {
        public final Rvalue condition;

        public WhileStatement(Location location, Rvalue condition, BlockStatement body) {
            super(location, body);
            this.condition = condition;
            this.condition.setEnclosingBlockStatement(this);
        }

        public String toString() {
            return "while (" + this.condition + ") " + this.body + ';';
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitWhileStatement(this);
        }
    }

    public static final class ForEachStatement
    extends ContinuableStatement {
        public final FunctionDeclarator.FormalParameter currentElement;
        public final Rvalue expression;

        public ForEachStatement(Location location, FunctionDeclarator.FormalParameter currentElement, Rvalue expression, BlockStatement body) {
            super(location, body);
            this.currentElement = currentElement;
            this.currentElement.type.setEnclosingScope(this);
            this.expression = expression;
            this.expression.setEnclosingBlockStatement(this);
        }

        public String toString() {
            return "for (... : ...) ...";
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitForEachStatement(this);
        }
    }

    public static final class ForStatement
    extends ContinuableStatement {
        public final BlockStatement optionalInit;
        public final Rvalue optionalCondition;
        public final Rvalue[] optionalUpdate;

        public ForStatement(Location location, BlockStatement optionalInit, Rvalue optionalCondition, Rvalue[] optionalUpdate, BlockStatement body) {
            super(location, body);
            this.optionalInit = optionalInit;
            if (optionalInit != null) {
                optionalInit.setEnclosingScope(this);
            }
            this.optionalCondition = optionalCondition;
            if (optionalCondition != null) {
                optionalCondition.setEnclosingBlockStatement(this);
            }
            this.optionalUpdate = optionalUpdate;
            if (optionalUpdate != null) {
                for (Rvalue rv : optionalUpdate) {
                    rv.setEnclosingBlockStatement(this);
                }
            }
        }

        public String toString() {
            return "for (...; ...; ...) ...";
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitForStatement(this);
        }
    }

    public static final class IfStatement
    extends Statement {
        public final Rvalue condition;
        public final BlockStatement thenStatement;
        public final BlockStatement optionalElseStatement;

        public IfStatement(Location location, Rvalue condition, BlockStatement thenStatement, BlockStatement optionalElseStatement) {
            super(location);
            this.condition = condition;
            this.condition.setEnclosingBlockStatement(this);
            this.thenStatement = thenStatement;
            this.thenStatement.setEnclosingScope(this);
            this.optionalElseStatement = optionalElseStatement;
            if (optionalElseStatement != null) {
                optionalElseStatement.setEnclosingScope(this);
            }
        }

        public String toString() {
            return this.optionalElseStatement == null ? "if" : "if ... else";
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitIfStatement(this);
        }
    }

    public static final class LocalClassDeclarationStatement
    extends Statement {
        public final LocalClassDeclaration lcd;

        public LocalClassDeclarationStatement(LocalClassDeclaration lcd) {
            super(lcd.getLocation());
            this.lcd = lcd;
            this.lcd.setEnclosingScope(this);
        }

        public String toString() {
            return this.lcd.toString();
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitLocalClassDeclarationStatement(this);
        }
    }

    public static final class ExpressionStatement
    extends Statement {
        public final Rvalue rvalue;

        public ExpressionStatement(Rvalue rvalue) throws CompileException {
            super(rvalue.getLocation());
            if (!(rvalue instanceof Assignment || rvalue instanceof Crement || rvalue instanceof MethodInvocation || rvalue instanceof SuperclassMethodInvocation || rvalue instanceof NewClassInstance || rvalue instanceof NewAnonymousClassInstance)) {
                String expressionType = rvalue.getClass().getName();
                expressionType = expressionType.substring(expressionType.lastIndexOf(46) + 1);
                this.throwCompileException(expressionType + " is not allowed as an expression statement. " + "Expressions statements must be one of assignments, method invocations, or object allocations.");
            }
            this.rvalue = rvalue;
            this.rvalue.setEnclosingBlockStatement(this);
        }

        public String toString() {
            return this.rvalue.toString() + ';';
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitExpressionStatement(this);
        }
    }

    public static abstract class ContinuableStatement
    extends BreakableStatement {
        protected CodeContext.Offset whereToContinue;
        public final BlockStatement body;

        protected ContinuableStatement(Location location, BlockStatement body) {
            super(location);
            this.body = body;
            this.body.setEnclosingScope(this);
        }
    }

    public static abstract class BreakableStatement
    extends Statement {
        CodeContext.Offset whereToBreak;

        protected BreakableStatement(Location location) {
            super(location);
        }
    }

    public static final class Block
    extends Statement {
        public final List<BlockStatement> statements = new ArrayList<BlockStatement>();

        public Block(Location location) {
            super(location);
        }

        public void addStatement(BlockStatement statement) {
            this.statements.add(statement);
            statement.setEnclosingScope(this);
        }

        public void addStatements(List<BlockStatement> statements) {
            this.statements.addAll(statements);
            for (BlockStatement bs : statements) {
                bs.setEnclosingScope(this);
            }
        }

        public BlockStatement[] getStatements() {
            return this.statements.toArray(new BlockStatement[this.statements.size()]);
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitBlock(this);
        }

        public String toString() {
            return "{ ... }";
        }
    }

    public static final class LabeledStatement
    extends BreakableStatement {
        public final String label;
        public final Statement body;

        public LabeledStatement(Location location, String label, Statement body) {
            super(location);
            this.label = label;
            this.body = body;
            this.body.setEnclosingScope(this);
        }

        public String toString() {
            return this.label + ": " + this.body;
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitLabeledStatement(this);
        }
    }

    public static abstract class Statement
    extends Located
    implements BlockStatement {
        private Scope enclosingScope;
        public Map<String, LocalVariable> localVariables;

        protected Statement(Location location) {
            super(location);
        }

        @Override
        public void setEnclosingScope(Scope enclosingScope) {
            if (this.enclosingScope != null && enclosingScope != this.enclosingScope) {
                throw new JaninoRuntimeException("Enclosing scope is already set for statement \"" + this.toString() + "\" at " + this.getLocation());
            }
            this.enclosingScope = enclosingScope;
        }

        @Override
        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        @Override
        public LocalVariable findLocalVariable(String name) {
            if (this.localVariables == null) {
                return null;
            }
            return this.localVariables.get(name);
        }
    }

    public static interface BlockStatement
    extends Locatable,
    Scope {
        public void setEnclosingScope(Scope var1);

        @Override
        public Scope getEnclosingScope();

        public void accept(Visitor.BlockStatementVisitor var1);

        public LocalVariable findLocalVariable(String var1);
    }

    public static final class VariableDeclarator
    extends Located {
        public final String name;
        public final int brackets;
        public final ArrayInitializerOrRvalue optionalInitializer;
        public LocalVariable localVariable;

        public VariableDeclarator(Location location, String name, int brackets, ArrayInitializerOrRvalue optionalInitializer) {
            super(location);
            this.name = name;
            this.brackets = brackets;
            this.optionalInitializer = optionalInitializer;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            for (int i = 0; i < this.brackets; ++i) {
                sb.append("[]");
            }
            if (this.optionalInitializer != null) {
                sb.append(" = ").append(this.optionalInitializer);
            }
            return sb.toString();
        }
    }

    public static final class FieldDeclaration
    extends Statement
    implements TypeBodyDeclaration,
    DocCommentable {
        private final String optionalDocComment;
        public final Modifiers modifiers;
        public final Type type;
        public final VariableDeclarator[] variableDeclarators;

        public FieldDeclaration(Location location, String optionalDocComment, Modifiers modifiers, Type type, VariableDeclarator[] variableDeclarators) {
            super(location);
            this.optionalDocComment = optionalDocComment;
            this.modifiers = modifiers;
            this.type = type;
            this.variableDeclarators = variableDeclarators;
            this.type.setEnclosingScope(this);
            for (VariableDeclarator vd : variableDeclarators) {
                if (vd.optionalInitializer == null) continue;
                Java.setEnclosingBlockStatement(vd.optionalInitializer, this);
            }
        }

        public Annotation[] getAnnotations() {
            return this.modifiers.annotations;
        }

        @Override
        public void setDeclaringType(TypeDeclaration declaringType) {
            this.setEnclosingScope(declaringType);
        }

        @Override
        public TypeDeclaration getDeclaringType() {
            return (TypeDeclaration)this.getEnclosingScope();
        }

        @Override
        public boolean isStatic() {
            return Mod.isStatic(this.modifiers.flags);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(Mod.shortToString(this.modifiers.flags)).append(' ').append(this.type);
            sb.append(' ').append(this.variableDeclarators[0]);
            for (int i = 1; i < this.variableDeclarators.length; ++i) {
                sb.append(", ").append(this.variableDeclarators[i]);
            }
            return sb.toString();
        }

        @Override
        public void accept(Visitor.TypeBodyDeclarationVisitor visitor) {
            visitor.visitFieldDeclaration(this);
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitFieldDeclaration(this);
        }

        @Override
        public String getDocComment() {
            return this.optionalDocComment;
        }

        @Override
        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }
    }

    public static final class MethodDeclarator
    extends FunctionDeclarator {
        IClass.IMethod iMethod;

        public MethodDeclarator(Location location, String optionalDocComment, Modifiers modifiers, Type type, String name, FunctionDeclarator.FormalParameters parameters, Type[] thrownExceptions, List<? extends BlockStatement> optionalStatements) {
            super(location, optionalDocComment, modifiers, type, name, parameters, thrownExceptions, optionalStatements);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name).append('(');
            FunctionDeclarator.FormalParameter[] fps = this.formalParameters.parameters;
            for (int i = 0; i < fps.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(fps[i].toString(i == fps.length - 1 && this.formalParameters.variableArity));
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        public void accept(Visitor.TypeBodyDeclarationVisitor visitor) {
            visitor.visitMethodDeclarator(this);
        }

        @Override
        public void accept(Visitor.FunctionDeclaratorVisitor visitor) {
            visitor.visitMethodDeclarator(this);
        }
    }

    public static final class ConstructorDeclarator
    extends FunctionDeclarator {
        IClass.IConstructor iConstructor;
        public final ConstructorInvocation optionalConstructorInvocation;
        final Map<String, LocalVariable> syntheticParameters = new HashMap<String, LocalVariable>();

        public ConstructorDeclarator(Location location, String optionalDocComment, Modifiers modifiers, FunctionDeclarator.FormalParameters parameters, Type[] thrownExceptions, ConstructorInvocation optionalConstructorInvocation, List<BlockStatement> statements) {
            super(location, optionalDocComment, modifiers, new BasicType(location, 0), "<init>", parameters, thrownExceptions, statements);
            this.optionalConstructorInvocation = optionalConstructorInvocation;
            if (optionalConstructorInvocation != null) {
                optionalConstructorInvocation.setEnclosingScope(this);
            }
        }

        public ClassDeclaration getDeclaringClass() {
            return (ClassDeclaration)this.getEnclosingScope();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getDeclaringClass().getClassName()).append('(');
            FunctionDeclarator.FormalParameter[] fps = this.formalParameters.parameters;
            for (int i = 0; i < fps.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(fps[i].toString(i == fps.length - 1 && this.formalParameters.variableArity));
            }
            sb.append(')');
            return sb.toString();
        }

        @Override
        public void accept(Visitor.TypeBodyDeclarationVisitor visitor) {
            visitor.visitConstructorDeclarator(this);
        }

        @Override
        public void accept(Visitor.FunctionDeclaratorVisitor visitor) {
            visitor.visitConstructorDeclarator(this);
        }
    }

    public static abstract class FunctionDeclarator
    extends AbstractTypeBodyDeclaration
    implements DocCommentable {
        private final String optionalDocComment;
        public final Modifiers modifiers;
        public final Type type;
        public final String name;
        public final FormalParameters formalParameters;
        public final Type[] thrownExceptions;
        public final List<? extends BlockStatement> optionalStatements;
        IClass returnType;
        public Map<String, LocalVariable> localVariables;

        public FunctionDeclarator(Location location, String optionalDocComment, Modifiers modifiers, Type type, String name, FormalParameters parameters, Type[] thrownExceptions, List<? extends BlockStatement> optionalStatements) {
            super(location, Mod.isStatic(modifiers.flags));
            this.optionalDocComment = optionalDocComment;
            this.modifiers = parameters.variableArity ? modifiers.add(128) : modifiers;
            this.type = type;
            this.name = name;
            this.formalParameters = parameters;
            this.thrownExceptions = thrownExceptions;
            this.optionalStatements = optionalStatements;
            this.type.setEnclosingScope(this);
            for (FormalParameter formalParameter : parameters.parameters) {
                formalParameter.type.setEnclosingScope(this);
            }
            for (Located located : thrownExceptions) {
                ((Type)located).setEnclosingScope(this);
            }
            if (optionalStatements != null) {
                for (BlockStatement blockStatement : optionalStatements) {
                    if (("<init>".equals(name) || "<clinit>".equals(name)) && blockStatement.getEnclosingScope() != null) continue;
                    blockStatement.setEnclosingScope(this);
                }
            }
        }

        public Annotation[] getAnnotations() {
            return this.modifiers.annotations;
        }

        public abstract void accept(Visitor.FunctionDeclaratorVisitor var1);

        @Override
        public void setDeclaringType(TypeDeclaration declaringType) {
            super.setDeclaringType(declaringType);
            for (Annotation a : this.modifiers.annotations) {
                a.setEnclosingScope(declaringType);
            }
        }

        @Override
        public Scope getEnclosingScope() {
            return this.getDeclaringType();
        }

        @Override
        public String getDocComment() {
            return this.optionalDocComment;
        }

        @Override
        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }

        public static final class FormalParameter
        extends Located {
            public final boolean finaL;
            public final Type type;
            public final String name;
            public LocalVariable localVariable;

            public FormalParameter(Location location, boolean finaL, Type type, String name) {
                super(location);
                this.finaL = finaL;
                this.type = type;
                this.name = name;
            }

            public String toString(boolean hasEllipsis) {
                return this.type.toString() + (hasEllipsis ? "... " : " ") + this.name;
            }

            public String toString() {
                return this.toString(false);
            }
        }

        public static final class FormalParameters
        extends Located {
            public final FormalParameter[] parameters;
            public final boolean variableArity;

            public FormalParameters() {
                this(null, new FormalParameter[0], false);
            }

            public FormalParameters(Location location, FormalParameter[] parameters, boolean variableArity) {
                super(location);
                this.parameters = parameters;
                this.variableArity = variableArity;
            }

            public String toString() {
                if (this.parameters.length == 0) {
                    return "()";
                }
                StringBuilder sb = new StringBuilder("(");
                for (int i = 0; i < this.parameters.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(this.parameters[i].toString(i == this.parameters.length - 1 && this.variableArity));
                }
                return sb.append(')').toString();
            }
        }
    }

    public static final class Initializer
    extends AbstractTypeBodyDeclaration
    implements BlockStatement {
        public final Block block;

        public Initializer(Location location, boolean statiC, Block block) {
            super(location, statiC);
            this.block = block;
            this.block.setEnclosingScope(this);
        }

        public String toString() {
            return this.statiC ? "static " + this.block : this.block.toString();
        }

        @Override
        public void accept(Visitor.TypeBodyDeclarationVisitor visitor) {
            visitor.visitInitializer(this);
        }

        @Override
        public void accept(Visitor.BlockStatementVisitor visitor) {
            visitor.visitInitializer(this);
        }

        @Override
        public LocalVariable findLocalVariable(String name) {
            return this.block.findLocalVariable(name);
        }
    }

    public static abstract class AbstractTypeBodyDeclaration
    extends Located
    implements TypeBodyDeclaration {
        private TypeDeclaration declaringType;
        public final boolean statiC;

        protected AbstractTypeBodyDeclaration(Location location, boolean statiC) {
            super(location);
            this.statiC = statiC;
        }

        @Override
        public void setDeclaringType(TypeDeclaration declaringType) {
            if (this.declaringType != null && declaringType != null) {
                throw new JaninoRuntimeException("Declaring type for type body declaration \"" + this.toString() + "\"at " + this.getLocation() + " is already set");
            }
            this.declaringType = declaringType;
        }

        @Override
        public TypeDeclaration getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public boolean isStatic() {
            return this.statiC;
        }

        public void setEnclosingScope(Scope enclosingScope) {
            this.declaringType = (TypeDeclaration)enclosingScope;
        }

        @Override
        public Scope getEnclosingScope() {
            return this.declaringType;
        }
    }

    public static interface TypeBodyDeclaration
    extends Locatable,
    Scope {
        public void setDeclaringType(TypeDeclaration var1);

        public TypeDeclaration getDeclaringType();

        public boolean isStatic();

        public void accept(Visitor.TypeBodyDeclarationVisitor var1);
    }

    public static class TypeParameter {
        public final String name;
        public final ReferenceType[] optionalBound;

        public TypeParameter(String name, ReferenceType[] optionalBound) {
            assert (name != null);
            this.name = name;
            this.optionalBound = optionalBound;
        }

        public String toString() {
            return this.optionalBound == null ? this.name : this.name + " extends " + Java.join(this.optionalBound, " & ");
        }
    }

    public static final class PackageMemberInterfaceDeclaration
    extends InterfaceDeclaration
    implements PackageMemberTypeDeclaration {
        public PackageMemberInterfaceDeclaration(Location location, String optionalDocComment, Modifiers modifiers, String name, TypeParameter[] optionalTypeParameters, Type[] extendedTypes) throws CompileException {
            super(location, optionalDocComment, modifiers, name, optionalTypeParameters, extendedTypes);
            if ((modifiers.flags & 0xE) != 0) {
                this.throwCompileException("Modifiers \"protected\", \"private\" and \"static\" not allowed in package member interface declaration");
            }
        }

        @Override
        public void setDeclaringCompilationUnit(CompilationUnit declaringCompilationUnit) {
            this.setEnclosingScope(declaringCompilationUnit);
        }

        @Override
        public CompilationUnit getDeclaringCompilationUnit() {
            return (CompilationUnit)this.getEnclosingScope();
        }

        @Override
        public String getClassName() {
            String className = this.getName();
            CompilationUnit compilationUnit = (CompilationUnit)this.getEnclosingScope();
            if (compilationUnit.optionalPackageDeclaration != null) {
                className = compilationUnit.optionalPackageDeclaration.packageName + '.' + className;
            }
            return className;
        }

        @Override
        public void accept(Visitor.TypeDeclarationVisitor visitor) {
            visitor.visitPackageMemberInterfaceDeclaration(this);
        }
    }

    public static final class MemberInterfaceDeclaration
    extends InterfaceDeclaration
    implements MemberTypeDeclaration {
        public MemberInterfaceDeclaration(Location location, String optionalDocComment, Modifiers modifiers, String name, TypeParameter[] optionalTypeParameters, Type[] extendedTypes) {
            super(location, optionalDocComment, modifiers, name, optionalTypeParameters, extendedTypes);
        }

        @Override
        public String getClassName() {
            NamedTypeDeclaration declaringType = (NamedTypeDeclaration)this.getEnclosingScope();
            return declaringType.getClassName() + '$' + this.getName();
        }

        @Override
        public void setDeclaringType(TypeDeclaration declaringType) {
            this.setEnclosingScope(declaringType);
        }

        @Override
        public TypeDeclaration getDeclaringType() {
            return (TypeDeclaration)this.getEnclosingScope();
        }

        @Override
        public boolean isStatic() {
            return Mod.isStatic(this.getModifierFlags());
        }

        @Override
        public void accept(Visitor.TypeDeclarationVisitor visitor) {
            visitor.visitMemberInterfaceDeclaration(this);
        }

        @Override
        public void accept(Visitor.TypeBodyDeclarationVisitor visitor) {
            visitor.visitMemberInterfaceDeclaration(this);
        }
    }

    public static abstract class InterfaceDeclaration
    extends AbstractTypeDeclaration
    implements NamedTypeDeclaration,
    DocCommentable {
        private final String optionalDocComment;
        public final String name;
        public final TypeParameter[] optionalTypeParameters;
        public final Type[] extendedTypes;
        public final List<FieldDeclaration> constantDeclarations = new ArrayList<FieldDeclaration>();
        IClass[] interfaces;

        protected InterfaceDeclaration(Location location, String optionalDocComment, Modifiers modifiers, String name, TypeParameter[] optionalTypeParameters, Type[] extendedTypes) {
            super(location, modifiers);
            this.optionalDocComment = optionalDocComment;
            this.name = name;
            this.optionalTypeParameters = optionalTypeParameters;
            this.extendedTypes = extendedTypes;
            for (Type extendedType : extendedTypes) {
                extendedType.setEnclosingScope(new EnclosingScopeOfTypeDeclaration(this));
            }
        }

        @Override
        public String toString() {
            return this.name;
        }

        public void addConstantDeclaration(FieldDeclaration fd) {
            this.constantDeclarations.add(fd);
            fd.setDeclaringType(this);
            if (this.resolvedType != null) {
                this.resolvedType.clearIFieldCaches();
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TypeParameter[] getOptionalTypeParameters() {
            return this.optionalTypeParameters;
        }

        @Override
        public String getDocComment() {
            return this.optionalDocComment;
        }

        @Override
        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }
    }

    public static final class PackageMemberClassDeclaration
    extends NamedClassDeclaration
    implements PackageMemberTypeDeclaration {
        public PackageMemberClassDeclaration(Location location, String optionalDocComment, Modifiers modifiers, String name, TypeParameter[] optionalTypeParameters, Type optionalExtendedType, Type[] implementedTypes) throws CompileException {
            super(location, optionalDocComment, modifiers, name, optionalTypeParameters, optionalExtendedType, implementedTypes);
            if ((modifiers.flags & 0xE) != 0) {
                this.throwCompileException("Modifiers \"protected\", \"private\" and \"static\" not allowed in package member class declaration");
            }
        }

        @Override
        public void setDeclaringCompilationUnit(CompilationUnit declaringCompilationUnit) {
            this.setEnclosingScope(declaringCompilationUnit);
        }

        @Override
        public CompilationUnit getDeclaringCompilationUnit() {
            return (CompilationUnit)this.getEnclosingScope();
        }

        @Override
        public String getClassName() {
            String className = this.getName();
            CompilationUnit compilationUnit = (CompilationUnit)this.getEnclosingScope();
            if (compilationUnit.optionalPackageDeclaration != null) {
                className = compilationUnit.optionalPackageDeclaration.packageName + '.' + className;
            }
            return className;
        }

        @Override
        public void accept(Visitor.TypeDeclarationVisitor visitor) {
            visitor.visitPackageMemberClassDeclaration(this);
        }
    }

    public static final class LocalClassDeclaration
    extends NamedClassDeclaration
    implements InnerClassDeclaration {
        public LocalClassDeclaration(Location location, String optionalDocComment, Modifiers modifiers, String name, TypeParameter[] optionalTypeParameters, Type optionalExtendedType, Type[] implementedTypes) {
            super(location, optionalDocComment, modifiers, name, optionalTypeParameters, optionalExtendedType, implementedTypes);
        }

        @Override
        public String getClassName() {
            Scope s = this.getEnclosingScope();
            while (!(s instanceof TypeDeclaration)) {
                s = s.getEnclosingScope();
            }
            return ((TypeDeclaration)s).getClassName() + '$' + this.name;
        }

        @Override
        public void accept(Visitor.TypeDeclarationVisitor visitor) {
            visitor.visitLocalClassDeclaration(this);
        }
    }

    public static final class MemberClassDeclaration
    extends NamedClassDeclaration
    implements MemberTypeDeclaration,
    InnerClassDeclaration {
        public MemberClassDeclaration(Location location, String optionalDocComment, Modifiers modifiers, String name, TypeParameter[] optionalTypeParameters, Type optionalExtendedType, Type[] implementedTypes) {
            super(location, optionalDocComment, modifiers, name, optionalTypeParameters, optionalExtendedType, implementedTypes);
        }

        @Override
        public void setDeclaringType(TypeDeclaration declaringType) {
            this.setEnclosingScope(declaringType);
        }

        @Override
        public TypeDeclaration getDeclaringType() {
            return (TypeDeclaration)this.getEnclosingScope();
        }

        @Override
        public boolean isStatic() {
            return Mod.isStatic(this.getModifierFlags());
        }

        @Override
        public String getClassName() {
            return this.getDeclaringType().getClassName() + '$' + this.getName();
        }

        @Override
        public void accept(Visitor.TypeDeclarationVisitor visitor) {
            visitor.visitMemberClassDeclaration(this);
        }

        @Override
        public void accept(Visitor.TypeBodyDeclarationVisitor visitor) {
            visitor.visitMemberClassDeclaration(this);
        }
    }

    public static final class EnclosingScopeOfTypeDeclaration
    implements Scope {
        public final TypeDeclaration typeDeclaration;

        public EnclosingScopeOfTypeDeclaration(TypeDeclaration typeDeclaration) {
            this.typeDeclaration = typeDeclaration;
        }

        @Override
        public Scope getEnclosingScope() {
            return this.typeDeclaration.getEnclosingScope();
        }
    }

    public static abstract class NamedClassDeclaration
    extends ClassDeclaration
    implements NamedTypeDeclaration,
    DocCommentable {
        private final String optionalDocComment;
        public final String name;
        public final TypeParameter[] optionalTypeParameters;
        public final Type optionalExtendedType;
        public final Type[] implementedTypes;

        public NamedClassDeclaration(Location location, String optionalDocComment, Modifiers modifiers, String name, TypeParameter[] optionalTypeParameters, Type optionalExtendedType, Type[] implementedTypes) {
            super(location, modifiers);
            this.optionalDocComment = optionalDocComment;
            this.name = name;
            this.optionalTypeParameters = optionalTypeParameters;
            this.optionalExtendedType = optionalExtendedType;
            if (optionalExtendedType != null) {
                optionalExtendedType.setEnclosingScope(new EnclosingScopeOfTypeDeclaration(this));
            }
            this.implementedTypes = implementedTypes;
            for (Type implementedType : implementedTypes) {
                implementedType.setEnclosingScope(new EnclosingScopeOfTypeDeclaration(this));
            }
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TypeParameter[] getOptionalTypeParameters() {
            return this.optionalTypeParameters;
        }

        @Override
        public String getDocComment() {
            return this.optionalDocComment;
        }

        @Override
        public boolean hasDeprecatedDocTag() {
            return this.optionalDocComment != null && this.optionalDocComment.indexOf("@deprecated") != -1;
        }
    }

    public static final class AnonymousClassDeclaration
    extends ClassDeclaration
    implements InnerClassDeclaration {
        public final Type baseType;
        private String myName;

        public AnonymousClassDeclaration(Location location, Type baseType) {
            super(location, new Modifiers(18));
            this.baseType = baseType;
            this.baseType.setEnclosingScope(new EnclosingScopeOfTypeDeclaration(this));
        }

        @Override
        public void accept(Visitor.TypeDeclarationVisitor visitor) {
            visitor.visitAnonymousClassDeclaration(this);
        }

        @Override
        public String getClassName() {
            if (this.myName == null) {
                Scope s = this.getEnclosingScope();
                while (!(s instanceof TypeDeclaration)) {
                    s = s.getEnclosingScope();
                }
                this.myName = ((TypeDeclaration)s).createAnonymousClassName();
            }
            return this.myName;
        }

        @Override
        public String toString() {
            return this.getClassName();
        }
    }

    public static abstract class ClassDeclaration
    extends AbstractTypeDeclaration {
        public final List<ConstructorDeclarator> constructors = new ArrayList<ConstructorDeclarator>();
        public final List<BlockStatement> variableDeclaratorsAndInitializers = new ArrayList<BlockStatement>();
        final SortedMap<String, IClass.IField> syntheticFields = new TreeMap<String, IClass.IField>();

        public ClassDeclaration(Location location, Modifiers modifiers) {
            super(location, modifiers);
        }

        public void addConstructor(ConstructorDeclarator cd) {
            this.constructors.add(cd);
            cd.setDeclaringType(this);
        }

        public void addFieldDeclaration(FieldDeclaration fd) {
            this.variableDeclaratorsAndInitializers.add(fd);
            fd.setDeclaringType(this);
            if (this.resolvedType != null) {
                this.resolvedType.clearIFieldCaches();
            }
        }

        public void addInitializer(Initializer i) {
            this.variableDeclaratorsAndInitializers.add(i);
            i.setDeclaringType(this);
            if (this.resolvedType != null) {
                this.resolvedType.clearIFieldCaches();
            }
        }

        public void defineSyntheticField(IClass.IField iField) throws CompileException {
            if (!(this instanceof InnerClassDeclaration)) {
                throw new JaninoRuntimeException();
            }
            IClass.IField if2 = (IClass.IField)this.syntheticFields.get(iField.getName());
            if (if2 != null) {
                if (iField.getType() != if2.getType()) {
                    throw new JaninoRuntimeException();
                }
                return;
            }
            this.syntheticFields.put(iField.getName(), iField);
        }

        ConstructorDeclarator[] getConstructors() {
            if (this.constructors.isEmpty()) {
                ConstructorDeclarator defaultConstructor = new ConstructorDeclarator(this.getLocation(), null, new Modifiers(1), new FunctionDeclarator.FormalParameters(), new Type[0], null, Collections.EMPTY_LIST);
                defaultConstructor.setDeclaringType(this);
                return new ConstructorDeclarator[]{defaultConstructor};
            }
            return this.constructors.toArray(new ConstructorDeclarator[this.constructors.size()]);
        }
    }

    public static abstract class AbstractTypeDeclaration
    implements TypeDeclaration {
        private final Location location;
        private final Modifiers modifiers;
        private final List<MethodDeclarator> declaredMethods = new ArrayList<MethodDeclarator>();
        private final List<MemberTypeDeclaration> declaredClassesAndInterfaces = new ArrayList<MemberTypeDeclaration>();
        private Scope enclosingScope;
        IClass resolvedType;
        public int anonymousClassCount;
        public int localClassCount;

        public AbstractTypeDeclaration(Location location, Modifiers modifiers) {
            this.location = location;
            this.modifiers = modifiers;
        }

        @Override
        public short getModifierFlags() {
            return this.modifiers.flags;
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.modifiers.annotations;
        }

        public void setEnclosingScope(Scope enclosingScope) {
            if (this.enclosingScope != null && enclosingScope != this.enclosingScope) {
                throw new JaninoRuntimeException("Enclosing scope is already set for type declaration \"" + this.toString() + "\" at " + this.getLocation());
            }
            this.enclosingScope = enclosingScope;
        }

        @Override
        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        public void invalidateMethodCaches() {
            if (this.resolvedType != null) {
                this.resolvedType.invalidateMethodCaches();
            }
        }

        public void addMemberTypeDeclaration(MemberTypeDeclaration mcoid) {
            this.declaredClassesAndInterfaces.add(mcoid);
            mcoid.setDeclaringType(this);
        }

        public void addDeclaredMethod(MethodDeclarator method) {
            this.declaredMethods.add(method);
            method.setDeclaringType(this);
        }

        @Override
        public Collection<MemberTypeDeclaration> getMemberTypeDeclarations() {
            return this.declaredClassesAndInterfaces;
        }

        @Override
        public MemberTypeDeclaration getMemberTypeDeclaration(String name) {
            for (MemberTypeDeclaration mtd : this.declaredClassesAndInterfaces) {
                if (!mtd.getName().equals(name)) continue;
                return mtd;
            }
            return null;
        }

        @Override
        public MethodDeclarator getMethodDeclaration(String name) {
            for (MethodDeclarator md : this.declaredMethods) {
                if (!md.name.equals(name)) continue;
                return md;
            }
            return null;
        }

        @Override
        public List<MethodDeclarator> getMethodDeclarations() {
            return this.declaredMethods;
        }

        @Override
        public String createLocalTypeName(String localTypeName) {
            return this.getClassName() + '$' + ++this.localClassCount + '$' + localTypeName;
        }

        @Override
        public String createAnonymousClassName() {
            return this.getClassName() + '$' + ++this.anonymousClassCount;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public void throwCompileException(String message) throws CompileException {
            throw new CompileException(message, this.location);
        }

        public abstract String toString();
    }

    static interface InnerClassDeclaration
    extends TypeDeclaration {
        public void defineSyntheticField(IClass.IField var1) throws CompileException;
    }

    public static interface NamedTypeDeclaration
    extends TypeDeclaration {
        public String getName();

        public TypeParameter[] getOptionalTypeParameters();
    }

    public static interface MemberTypeDeclaration
    extends NamedTypeDeclaration,
    TypeBodyDeclaration {
    }

    public static interface PackageMemberTypeDeclaration
    extends NamedTypeDeclaration {
        public void setDeclaringCompilationUnit(CompilationUnit var1);

        public CompilationUnit getDeclaringCompilationUnit();
    }

    public static interface DocCommentable {
        public String getDocComment();

        public boolean hasDeprecatedDocTag();
    }

    public static interface TypeDeclaration
    extends Locatable,
    Scope {
        public short getModifierFlags();

        public Annotation[] getAnnotations();

        public MemberTypeDeclaration getMemberTypeDeclaration(String var1);

        public Collection<MemberTypeDeclaration> getMemberTypeDeclarations();

        public MethodDeclarator getMethodDeclaration(String var1);

        public List<MethodDeclarator> getMethodDeclarations();

        public String getClassName();

        public String createLocalTypeName(String var1);

        public String createAnonymousClassName();

        public void accept(Visitor.TypeDeclarationVisitor var1);
    }

    public static class PackageDeclaration
    extends Located {
        public final String packageName;

        public PackageDeclaration(Location location, String packageName) {
            super(location);
            this.packageName = packageName;
        }
    }

    public static class ElementValueArrayInitializer
    implements ElementValue {
        public final ElementValue[] elementValues;

        public ElementValueArrayInitializer(ElementValue[] elementValues) {
            this.elementValues = elementValues;
        }

        public String toString() {
            switch (this.elementValues.length) {
                case 0: {
                    return "{}";
                }
                case 1: {
                    return "{ " + this.elementValues[0] + " }";
                }
            }
            return "{ " + this.elementValues[0] + ", ... }";
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitElementValueArrayInitializer(this);
        }
    }

    public static interface ElementValue {
        public void accept(Visitor.ElementValueVisitor var1);
    }

    public static class ElementValuePair {
        public final String identifier;
        public final ElementValue elementValue;

        public ElementValuePair(String identifier, ElementValue elementValue) {
            this.identifier = identifier;
            this.elementValue = elementValue;
        }

        public String toString() {
            return this.identifier + " = " + this.elementValue;
        }
    }

    public static class Modifiers {
        public final short flags;
        public final Annotation[] annotations;

        public Modifiers() {
            this.flags = 0;
            this.annotations = new Annotation[0];
        }

        public Modifiers(short modifiers) {
            this.flags = modifiers;
            this.annotations = new Annotation[0];
        }

        public Modifiers(short modifiers, Annotation[] annotations) {
            this.flags = modifiers;
            this.annotations = annotations;
        }

        public Modifiers add(int modifiersToAdd) {
            return new Modifiers((short)(this.flags | modifiersToAdd), this.annotations);
        }

        public Modifiers remove(int modifiersToRemove) {
            return new Modifiers((short)(this.flags & ~modifiersToRemove), this.annotations);
        }

        public Modifiers changeAccess(int newAccess) {
            return new Modifiers((short)(this.flags & 0xFFFFFFF8 | newAccess), this.annotations);
        }
    }

    public static final class NormalAnnotation
    implements Annotation {
        public final Type type;
        public final ElementValuePair[] elementValuePairs;

        public NormalAnnotation(Type type, ElementValuePair[] elementValuePairs) {
            this.type = type;
            this.elementValuePairs = elementValuePairs;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        public String toString() {
            switch (this.elementValuePairs.length) {
                case 0: {
                    return "@" + this.type + "()";
                }
                case 1: {
                    return "@" + this.type + "(" + this.elementValuePairs[0] + ")";
                }
            }
            return "@" + this.type + "(" + this.elementValuePairs[0] + ", ...)";
        }

        @Override
        public void setEnclosingScope(Scope enclosingScope) {
            this.setEnclosingScope(enclosingScope);
        }

        @Override
        public void accept(Visitor.AnnotationVisitor visitor) {
            visitor.visitNormalAnnotation(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitNormalAnnotation(this);
        }
    }

    public static final class SingleElementAnnotation
    implements Annotation {
        public final Type type;
        public final ElementValue elementValue;

        public SingleElementAnnotation(Type type, ElementValue elementValue) {
            this.type = type;
            this.elementValue = elementValue;
        }

        @Override
        public void setEnclosingScope(Scope enclosingScope) {
            this.type.setEnclosingScope(enclosingScope);
        }

        public String toString() {
            return "@" + this.type + '(' + this.elementValue + ')';
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public void accept(Visitor.AnnotationVisitor visitor) {
            visitor.visitSingleElementAnnotation(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitSingleElementAnnotation(this);
        }
    }

    public static final class MarkerAnnotation
    implements Annotation {
        public final Type type;

        public MarkerAnnotation(Type type) {
            this.type = type;
        }

        @Override
        public void setEnclosingScope(Scope enclosingScope) {
            this.type.setEnclosingScope(enclosingScope);
        }

        public String toString() {
            return "@" + this.type;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public void accept(Visitor.AnnotationVisitor visitor) {
            visitor.visitMarkerAnnotation(this);
        }

        @Override
        public void accept(Visitor.ElementValueVisitor visitor) {
            visitor.visitMarkerAnnotation(this);
        }
    }

    public static interface Annotation
    extends ElementValue {
        public void accept(Visitor.AnnotationVisitor var1);

        public void setEnclosingScope(Scope var1);

        public Type getType();
    }

    public static final class CompilationUnit
    implements Scope {
        public final String optionalFileName;
        public PackageDeclaration optionalPackageDeclaration;
        public final List<ImportDeclaration> importDeclarations = new ArrayList<ImportDeclaration>();
        public final List<PackageMemberTypeDeclaration> packageMemberTypeDeclarations = new ArrayList<PackageMemberTypeDeclaration>();

        public CompilationUnit(String optionalFileName) {
            this.optionalFileName = optionalFileName;
        }

        @Override
        public Scope getEnclosingScope() {
            throw new JaninoRuntimeException("A compilation unit has no enclosing scope");
        }

        public void setPackageDeclaration(PackageDeclaration packageDeclaration) {
            this.optionalPackageDeclaration = packageDeclaration;
        }

        public void addImportDeclaration(ImportDeclaration id) {
            this.importDeclarations.add(id);
        }

        public void addPackageMemberTypeDeclaration(PackageMemberTypeDeclaration pmtd) {
            this.packageMemberTypeDeclarations.add(pmtd);
            pmtd.setDeclaringCompilationUnit(this);
        }

        public PackageMemberTypeDeclaration[] getPackageMemberTypeDeclarations() {
            return this.packageMemberTypeDeclarations.toArray(new PackageMemberTypeDeclaration[this.packageMemberTypeDeclarations.size()]);
        }

        public PackageMemberTypeDeclaration getPackageMemberTypeDeclaration(String name) {
            for (PackageMemberTypeDeclaration pmtd : this.packageMemberTypeDeclarations) {
                if (!pmtd.getName().equals(name)) continue;
                return pmtd;
            }
            return null;
        }

        public static abstract class ImportDeclaration
        extends Located {
            public ImportDeclaration(Location location) {
                super(location);
            }

            public abstract void accept(Visitor.ImportVisitor var1);
        }

        public static class StaticImportOnDemandDeclaration
        extends ImportDeclaration {
            public final String[] identifiers;

            public StaticImportOnDemandDeclaration(Location location, String[] identifiers) {
                super(location);
                this.identifiers = identifiers;
            }

            @Override
            public final void accept(Visitor.ImportVisitor visitor) {
                visitor.visitStaticImportOnDemandDeclaration(this);
            }
        }

        public static class SingleStaticImportDeclaration
        extends ImportDeclaration {
            public final String[] identifiers;

            public SingleStaticImportDeclaration(Location location, String[] identifiers) {
                super(location);
                this.identifiers = identifiers;
            }

            @Override
            public final void accept(Visitor.ImportVisitor visitor) {
                visitor.visitSingleStaticImportDeclaration(this);
            }
        }

        public static class TypeImportOnDemandDeclaration
        extends ImportDeclaration {
            public final String[] identifiers;

            public TypeImportOnDemandDeclaration(Location location, String[] identifiers) {
                super(location);
                this.identifiers = identifiers;
            }

            @Override
            public final void accept(Visitor.ImportVisitor visitor) {
                visitor.visitTypeImportOnDemandDeclaration(this);
            }

            public String toString() {
                return "import " + Java.join(this.identifiers, ".") + ".*;";
            }
        }

        public static class SingleTypeImportDeclaration
        extends ImportDeclaration {
            public final String[] identifiers;

            public SingleTypeImportDeclaration(Location location, String[] identifiers) {
                super(location);
                this.identifiers = identifiers;
            }

            @Override
            public final void accept(Visitor.ImportVisitor visitor) {
                visitor.visitSingleTypeImportDeclaration(this);
            }

            public String toString() {
                return "import " + Java.join(this.identifiers, ".") + ';';
            }
        }
    }

    public static abstract class Located
    implements Locatable {
        public static final Located NOWHERE = new Located(Location.NOWHERE){};
        private final Location location;

        protected Located(Location location) {
            this.location = location;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public void throwCompileException(String message) throws CompileException {
            throw new CompileException(message, this.location);
        }
    }

    public static interface Locatable {
        public Location getLocation();

        public void throwCompileException(String var1) throws CompileException;
    }

    public static interface Scope {
        public Scope getEnclosingScope();
    }
}

