/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.util.graph;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.graph.DefaultEdge;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.graph.DirectedGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultDirectedGraph<V, E extends DefaultEdge>
implements DirectedGraph<V, E> {
    final Set<E> edges = new LinkedHashSet();
    final Map<V, VertexInfo<V, E>> vertexMap = new LinkedHashMap<V, VertexInfo<V, E>>();
    final DirectedGraph.EdgeFactory<V, E> edgeFactory;

    public DefaultDirectedGraph(DirectedGraph.EdgeFactory<V, E> edgeFactory) {
        this.edgeFactory = edgeFactory;
    }

    public static <V> DefaultDirectedGraph<V, DefaultEdge> create() {
        return DefaultDirectedGraph.create(DefaultEdge.factory());
    }

    public static <V, E extends DefaultEdge> DefaultDirectedGraph<V, E> create(DirectedGraph.EdgeFactory<V, E> edgeFactory) {
        return new DefaultDirectedGraph<V, E>(edgeFactory);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("graph(").append("vertices: ").append(this.vertexMap.keySet()).append(", edges: ").append(this.edges).append(")");
        return buf.toString();
    }

    @Override
    public boolean addVertex(V vertex) {
        if (this.vertexMap.containsKey(vertex)) {
            return false;
        }
        this.vertexMap.put(vertex, new VertexInfo());
        return true;
    }

    @Override
    public Set<E> edgeSet() {
        return Collections.unmodifiableSet(this.edges);
    }

    @Override
    public E addEdge(V vertex, V targetVertex) {
        VertexInfo<V, E> info = this.vertexMap.get(vertex);
        if (info == null) {
            throw new IllegalArgumentException("no vertex " + vertex);
        }
        VertexInfo<V, E> info2 = this.vertexMap.get(targetVertex);
        if (info2 == null) {
            throw new IllegalArgumentException("no vertex " + targetVertex);
        }
        DefaultEdge edge = (DefaultEdge)this.edgeFactory.createEdge(vertex, targetVertex);
        if (this.edges.add(edge)) {
            info.outEdges.add(edge);
            return (E)edge;
        }
        return null;
    }

    @Override
    public E getEdge(V source, V target) {
        VertexInfo<V, E> info = this.vertexMap.get(source);
        for (DefaultEdge outEdge : info.outEdges) {
            if (!outEdge.target.equals(target)) continue;
            return (E)outEdge;
        }
        return null;
    }

    @Override
    public boolean removeEdge(V source, V target) {
        VertexInfo<V, E> info = this.vertexMap.get(source);
        List outEdges = info.outEdges;
        int size = outEdges.size();
        for (int i = 0; i < size; ++i) {
            DefaultEdge edge = (DefaultEdge)outEdges.get(i);
            if (!edge.target.equals(target)) continue;
            outEdges.remove(i);
            this.edges.remove(edge);
            return true;
        }
        return false;
    }

    @Override
    public Set<V> vertexSet() {
        return this.vertexMap.keySet();
    }

    @Override
    public void removeAllVertices(Collection<V> collection) {
        this.vertexMap.keySet().removeAll(collection);
        for (VertexInfo<V, E> info : this.vertexMap.values()) {
            Iterator iterator = info.outEdges.iterator();
            while (iterator.hasNext()) {
                DefaultEdge next = (DefaultEdge)iterator.next();
                if (!collection.contains(next.target)) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public List<E> getOutwardEdges(V source) {
        return this.vertexMap.get(source).outEdges;
    }

    @Override
    public List<E> getInwardEdges(V target) {
        ArrayList<DefaultEdge> list = new ArrayList<DefaultEdge>();
        for (VertexInfo<V, E> info : this.vertexMap.values()) {
            for (DefaultEdge edge : info.outEdges) {
                if (!edge.target.equals(target)) continue;
                list.add(edge);
            }
        }
        return list;
    }

    final V source(E edge) {
        return (V)((DefaultEdge)edge).source;
    }

    final V target(E edge) {
        return (V)((DefaultEdge)edge).target;
    }

    static class VertexInfo<V, E> {
        public List<E> outEdges = new ArrayList();

        VertexInfo() {
        }
    }
}

