/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.avatica.util.TimeUnitRange;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlLiteral;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.OracleSqlOperatorTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.SqlFloorFunction;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.SqlStdOperatorTable;

public class OracleSqlDialect
extends SqlDialect {
    public static final SqlDialect DEFAULT = new OracleSqlDialect(EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.ORACLE).withIdentifierQuoteString("\""));

    public OracleSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    protected boolean allowsAs() {
        return false;
    }

    @Override
    public boolean supportsAliasedValues() {
        return false;
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.getOperator() == SqlStdOperatorTable.SUBSTRING) {
            SqlUtil.unparseFunctionSyntax(OracleSqlOperatorTable.SUBSTR, writer, call);
        } else {
            switch (call.getKind()) {
                case FLOOR: {
                    if (call.operandCount() != 2) {
                        super.unparseCall(writer, call, leftPrec, rightPrec);
                        return;
                    }
                    SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
                    TimeUnitRange timeUnit = timeUnitNode.getValueAs(TimeUnitRange.class);
                    SqlCall call2 = SqlFloorFunction.replaceTimeUnitOperand(call, timeUnit.name(), timeUnitNode.getParserPosition());
                    SqlFloorFunction.unparseDatetimeFunction(writer, call2, "TRUNC", true);
                    break;
                }
                default: {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                }
            }
        }
    }
}

