/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl;

import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalcitePrepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.jdbc.CalciteSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelRoot;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.schema.ColumnStrategy;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlCall;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlDataTypeSpec;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlDrop;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlIdentifier;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlNodeList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlOperator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlSelect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlAlterIndex;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlAlterTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlAlterUser;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlCheckConstraint;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlCreateForeignSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlCreateIndex;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlCreateMaterializedView;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlCreateSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlCreateTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlCreateUser;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlCreateView;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlDropIndex;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlDropMaterializedView;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlDropSchema;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlDropTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlDropUser;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlDropView;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.ddl.SqlKeyConstraint;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.CalciteSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParseException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.parser.SqlParserPos;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.pretty.SqlPrettyWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.tools.FrameworkConfig;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.tools.Frameworks;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.tools.Planner;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.tools.RelConversionException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.tools.ValidationException;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Pair;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public class SqlDdlNodes {
    private SqlDdlNodes() {
    }

    public static SqlCreateSchema createSchema(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name) {
        return new SqlCreateSchema(pos, replace, ifNotExists, name);
    }

    public static SqlCreateUser createUser(SqlParserPos pos, boolean replace, SqlIdentifier user, String password) {
        return new SqlCreateUser(pos, replace, user, password);
    }

    public static SqlCreateForeignSchema createForeignSchema(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNode type, SqlNode library, SqlNodeList optionList) {
        return new SqlCreateForeignSchema(pos, replace, ifNotExists, name, type, library, optionList);
    }

    public static SqlCreateTable createTable(SqlParserPos pos, boolean replace, boolean isPipe, boolean ifNotExists, SqlIdentifier name, SqlNodeList columnList, SqlNode query, List<Pair<String, String>> tableParamList) {
        return new SqlCreateTable(pos, replace, isPipe, ifNotExists, name, columnList, query, tableParamList);
    }

    public static SqlCreateView createView(SqlParserPos pos, boolean replace, SqlIdentifier name, SqlNodeList columnList, SqlNode query) {
        return new SqlCreateView(pos, replace, name, columnList, query);
    }

    public static SqlCreateMaterializedView createMaterializedView(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNodeList columnList, SqlNode query) {
        return new SqlCreateMaterializedView(pos, replace, ifNotExists, name, columnList, query);
    }

    public static SqlDropSchema dropSchema(SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        return new SqlDropSchema(pos, ifExists, name);
    }

    public static SqlDropUser dropUser(SqlParserPos pos, SqlIdentifier user) {
        return new SqlDropUser(pos, user);
    }

    public static SqlDropTable dropTable(SqlParserPos pos, boolean isPipe, boolean ifExists, SqlIdentifier name) {
        return new SqlDropTable(pos, isPipe, ifExists, name);
    }

    public static SqlDropIndex dropIndex(SqlParserPos pos, boolean ifExists, SqlIdentifier indexName, SqlIdentifier tableName) {
        return new SqlDropIndex(pos, ifExists, indexName, tableName);
    }

    public static SqlAlterIndex alterIndex(SqlParserPos pos, boolean ifExists, SqlIdentifier indexName, SqlIdentifier tableName, SqlIdentifier indexState) {
        return new SqlAlterIndex(pos, ifExists, indexName, tableName, indexState);
    }

    public static SqlDrop dropView(SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        return new SqlDropView(pos, ifExists, name);
    }

    public static SqlDrop dropMaterializedView(SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        return new SqlDropMaterializedView(pos, ifExists, name);
    }

    public static SqlNode column(SqlParserPos pos, SqlIdentifier name, SqlDataTypeSpec dataType, SqlNode expression, ColumnStrategy strategy) {
        return new SqlColumnDeclaration(pos, name, dataType, expression, strategy);
    }

    public static SqlNode check(SqlParserPos pos, SqlIdentifier name, SqlNode expression) {
        return new SqlCheckConstraint(pos, name, expression);
    }

    public static SqlKeyConstraint unique(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList) {
        return new SqlKeyConstraint(pos, name, columnList);
    }

    public static SqlKeyConstraint primary(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList) {
        return new SqlKeyConstraint(pos, name, columnList){

            @Override
            public SqlOperator getOperator() {
                return PRIMARY;
            }
        };
    }

    public static SqlAlterTable alterTable(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList, int alterType, List<Pair<String, String>> tableParamList) {
        return new SqlAlterTable(pos, name, columnList, alterType, tableParamList);
    }

    public static SqlAlterUser alterUser(SqlParserPos pos, SqlIdentifier user, SqlIdentifier key1, String value1, SqlIdentifier key2, String value2) {
        return new SqlAlterUser(pos, user, key1, value1, key2, value2);
    }

    public static SqlCreateIndex createIndex(SqlParserPos pos, boolean replace, boolean isLocal, boolean ifNotExists, SqlIdentifier indexName, SqlIdentifier tableName, List<Pair<SqlIdentifier, Boolean>> indexColumnList, SqlNodeList dupColumnList, List<Pair<String, String>> tableParamList) {
        return new SqlCreateIndex(pos, replace, isLocal, ifNotExists, indexName, tableName, indexColumnList, dupColumnList, tableParamList);
    }

    static Pair<CalciteSchema, String> schema(CalcitePrepare.Context context, boolean mutable, SqlIdentifier id) {
        String name;
        List<String> path;
        if (id.isSimple()) {
            path = context.getDefaultSchemaPath();
            name = id.getSimple();
        } else {
            path = Util.skipLast(id.names);
            name = Util.last(id.names);
        }
        CalciteSchema schema = mutable ? context.getMutableRootSchema() : context.getRootSchema();
        for (String p : path) {
            schema = schema.getSubSchema(p, true);
        }
        return Pair.of(schema, name);
    }

    static SqlNode renameColumns(SqlNodeList columnList, SqlNode query) {
        if (columnList == null) {
            return query;
        }
        SqlParserPos p = query.getParserPosition();
        SqlNodeList selectList = new SqlNodeList(ImmutableList.of(SqlIdentifier.star(p)), p);
        SqlCall from = SqlStdOperatorTable.AS.createCall(p, (List<? extends SqlNode>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(query)).add(new SqlIdentifier("_", p))).addAll((Iterable)columnList)).build()));
        return new SqlSelect(p, null, selectList, from, null, null, null, null, null, null, null, false, null, false);
    }

    protected static void populate(SqlIdentifier name, SqlNode query, CalcitePrepare.Context context) {
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(context.getRootSchema().plus()).build();
        Planner planner = Frameworks.getPlanner(config);
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            SqlPrettyWriter w = new SqlPrettyWriter(CalciteSqlDialect.DEFAULT, false, pw);
            pw.print("INSERT INTO ");
            name.unparse(w, 0, 0);
            pw.print(" ");
            query.unparse(w, 0, 0);
            pw.flush();
            String sql = sw.toString();
            SqlNode query1 = planner.parse(sql);
            SqlNode query2 = planner.validate(query1);
            RelRoot r = planner.rel(query2);
            PreparedStatement prepare = context.getRelRunner().prepare(r.rel);
            int rowCount = prepare.executeUpdate();
            Util.discard(rowCount);
            prepare.close();
        }
        catch (SqlParseException | RelConversionException | ValidationException | SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

