/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.sql;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.config.NullCollation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlDialectFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.AccessSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.AnsiSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.CalciteSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.Db2SqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.DerbySqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.FirebirdSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.H2SqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.HiveSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.HsqldbSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.InfobrightSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.InformixSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.IngresSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.InterbaseSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.LucidDbSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.MssqlSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.MysqlSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.NeoviewSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.NetezzaSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.OracleSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.ParaccelSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.PhoenixSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.RedshiftSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.SybaseSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.TeradataSqlDialect;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.dialect.VerticaSqlDialect;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;

public class SqlDialectFactoryImpl
implements SqlDialectFactory {
    @Override
    public SqlDialect create(DatabaseMetaData databaseMetaData) {
        int databaseMinorVersion;
        int databaseMajorVersion;
        String databaseProductName;
        try {
            databaseProductName = databaseMetaData.getDatabaseProductName();
            databaseMajorVersion = databaseMetaData.getDatabaseMajorVersion();
            databaseMinorVersion = databaseMetaData.getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            throw new RuntimeException("while detecting database product", e);
        }
        String upperProductName = databaseProductName.toUpperCase(Locale.ROOT).trim();
        String quoteString = this.getIdentifierQuoteString(databaseMetaData);
        NullCollation nullCollation = this.getNullCollation(databaseMetaData);
        SqlDialect.Context c = SqlDialect.EMPTY_CONTEXT.withDatabaseProductName(databaseProductName).withDatabaseMajorVersion(databaseMajorVersion).withDatabaseMinorVersion(databaseMinorVersion).withIdentifierQuoteString(quoteString).withNullCollation(nullCollation);
        switch (upperProductName) {
            case "ACCESS": {
                return new AccessSqlDialect(c);
            }
            case "APACHE DERBY": {
                return new DerbySqlDialect(c);
            }
            case "DBMS:CLOUDSCAPE": {
                return new DerbySqlDialect(c);
            }
            case "HIVE": {
                return new HiveSqlDialect(c);
            }
            case "INGRES": {
                return new IngresSqlDialect(c);
            }
            case "INTERBASE": {
                return new InterbaseSqlDialect(c);
            }
            case "LUCIDDB": {
                return new LucidDbSqlDialect(c);
            }
            case "ORACLE": {
                return new OracleSqlDialect(c);
            }
            case "PHOENIX": {
                return new PhoenixSqlDialect(c);
            }
            case "MYSQL (INFOBRIGHT)": {
                return new InfobrightSqlDialect(c);
            }
            case "MYSQL": {
                return new MysqlSqlDialect(c);
            }
            case "REDSHIFT": {
                return new RedshiftSqlDialect(c);
            }
        }
        if (databaseProductName.startsWith("DB2")) {
            return new Db2SqlDialect(c);
        }
        if (upperProductName.contains("FIREBIRD")) {
            return new FirebirdSqlDialect(c);
        }
        if (databaseProductName.startsWith("Informix")) {
            return new InformixSqlDialect(c);
        }
        if (upperProductName.contains("NETEZZA")) {
            return new NetezzaSqlDialect(c);
        }
        if (upperProductName.contains("PARACCEL")) {
            return new ParaccelSqlDialect(c);
        }
        if (databaseProductName.startsWith("HP Neoview")) {
            return new NeoviewSqlDialect(c);
        }
        if (upperProductName.contains("POSTGRE")) {
            return new PostgresqlSqlDialect(c);
        }
        if (upperProductName.contains("SQL SERVER")) {
            return new MssqlSqlDialect(c);
        }
        if (upperProductName.contains("SYBASE")) {
            return new SybaseSqlDialect(c);
        }
        if (upperProductName.contains("TERADATA")) {
            return new TeradataSqlDialect(c);
        }
        if (upperProductName.contains("HSQL")) {
            return new HsqldbSqlDialect(c);
        }
        if (upperProductName.contains("H2")) {
            return new H2SqlDialect(c);
        }
        if (upperProductName.contains("VERTICA")) {
            return new VerticaSqlDialect(c);
        }
        return new AnsiSqlDialect(c);
    }

    private NullCollation getNullCollation(DatabaseMetaData databaseMetaData) {
        try {
            if (databaseMetaData.nullsAreSortedAtEnd()) {
                return NullCollation.LAST;
            }
            if (databaseMetaData.nullsAreSortedAtStart()) {
                return NullCollation.FIRST;
            }
            if (databaseMetaData.nullsAreSortedLow()) {
                return NullCollation.LOW;
            }
            if (databaseMetaData.nullsAreSortedHigh()) {
                return NullCollation.HIGH;
            }
            throw new IllegalArgumentException("cannot deduce null collation");
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("cannot deduce null collation", e);
        }
    }

    private String getIdentifierQuoteString(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.getIdentifierQuoteString();
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("cannot deduce identifier quote string", e);
        }
    }

    static SqlDialect simple(SqlDialect.DatabaseProduct databaseProduct) {
        switch (databaseProduct) {
            case ACCESS: {
                return AccessSqlDialect.DEFAULT;
            }
            case CALCITE: {
                return CalciteSqlDialect.DEFAULT;
            }
            case DB2: {
                return Db2SqlDialect.DEFAULT;
            }
            case DERBY: {
                return DerbySqlDialect.DEFAULT;
            }
            case FIREBIRD: {
                return FirebirdSqlDialect.DEFAULT;
            }
            case H2: {
                return H2SqlDialect.DEFAULT;
            }
            case HIVE: {
                return HiveSqlDialect.DEFAULT;
            }
            case HSQLDB: {
                return HsqldbSqlDialect.DEFAULT;
            }
            case INFOBRIGHT: {
                return InfobrightSqlDialect.DEFAULT;
            }
            case INFORMIX: {
                return InformixSqlDialect.DEFAULT;
            }
            case INGRES: {
                return IngresSqlDialect.DEFAULT;
            }
            case INTERBASE: {
                return InterbaseSqlDialect.DEFAULT;
            }
            case LUCIDDB: {
                return LucidDbSqlDialect.DEFAULT;
            }
            case MSSQL: {
                return MssqlSqlDialect.DEFAULT;
            }
            case MYSQL: {
                return MysqlSqlDialect.DEFAULT;
            }
            case NEOVIEW: {
                return NeoviewSqlDialect.DEFAULT;
            }
            case NETEZZA: {
                return NetezzaSqlDialect.DEFAULT;
            }
            case ORACLE: {
                return OracleSqlDialect.DEFAULT;
            }
            case PARACCEL: {
                return ParaccelSqlDialect.DEFAULT;
            }
            case PHOENIX: {
                return PhoenixSqlDialect.DEFAULT;
            }
            case POSTGRESQL: {
                return PostgresqlSqlDialect.DEFAULT;
            }
            case REDSHIFT: {
                return RedshiftSqlDialect.DEFAULT;
            }
            case SYBASE: {
                return SybaseSqlDialect.DEFAULT;
            }
            case TERADATA: {
                return TeradataSqlDialect.DEFAULT;
            }
            case VERTICA: {
                return VerticaSqlDialect.DEFAULT;
            }
        }
        return null;
    }
}

