/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCost;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptPlanner;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptUtil;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTraitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.prepare.Prepare;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.SingleRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.SqlKind;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.sql.type.SqlTypeUtil;
import java.util.List;

public abstract class TableModify
extends SingleRel {
    protected Prepare.CatalogReader catalogReader;
    protected final RelOptTable table;
    private final Operation operation;
    private final List<String> updateColumnList;
    private final List<RexNode> sourceExpressionList;
    private RelDataType inputRowType;
    private final boolean flattened;

    protected TableModify(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode input, Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
        super(cluster, traitSet, input);
        this.table = table;
        this.catalogReader = catalogReader;
        this.operation = operation;
        this.updateColumnList = updateColumnList;
        this.sourceExpressionList = sourceExpressionList;
        if (operation == Operation.UPDATE) {
            Preconditions.checkNotNull(updateColumnList);
            Preconditions.checkNotNull(sourceExpressionList);
            Preconditions.checkArgument(sourceExpressionList.size() == updateColumnList.size());
        } else {
            Preconditions.checkArgument(updateColumnList == null);
            Preconditions.checkArgument(sourceExpressionList == null);
        }
        if (table.getRelOptSchema() != null) {
            cluster.getPlanner().registerSchema(table.getRelOptSchema());
        }
        this.flattened = flattened;
    }

    public Prepare.CatalogReader getCatalogReader() {
        return this.catalogReader;
    }

    @Override
    public RelOptTable getTable() {
        return this.table;
    }

    public List<String> getUpdateColumnList() {
        return this.updateColumnList;
    }

    public List<RexNode> getSourceExpressionList() {
        return this.sourceExpressionList;
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public boolean isInsert() {
        return this.operation == Operation.INSERT;
    }

    public boolean isUpdate() {
        return this.operation == Operation.UPDATE;
    }

    public boolean isDelete() {
        return this.operation == Operation.DELETE;
    }

    public boolean isMerge() {
        return this.operation == Operation.MERGE;
    }

    @Override
    public RelDataType deriveRowType() {
        return RelOptUtil.createDmlRowType(SqlKind.INSERT, this.getCluster().getTypeFactory());
    }

    @Override
    public RelDataType getExpectedInputRowType(int ordinalInParent) {
        assert (ordinalInParent == 0);
        if (this.inputRowType != null) {
            return this.inputRowType;
        }
        RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
        RelDataType rowType = this.table.getRowType();
        switch (this.operation) {
            case UPDATE: {
                this.inputRowType = typeFactory.createJoinType(rowType, this.getCatalogReader().createTypeFromProjection(rowType, this.updateColumnList));
                break;
            }
            case MERGE: {
                this.inputRowType = typeFactory.createJoinType(typeFactory.createJoinType(rowType, rowType), this.getCatalogReader().createTypeFromProjection(rowType, this.updateColumnList));
                break;
            }
            default: {
                this.inputRowType = rowType;
            }
        }
        if (this.flattened) {
            this.inputRowType = SqlTypeUtil.flattenRecordType(typeFactory, this.inputRowType, null);
        }
        return this.inputRowType;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("table", this.table.getQualifiedName()).item("operation", (Object)this.getOperation()).itemIf("updateColumnList", this.updateColumnList, this.updateColumnList != null).itemIf("sourceExpressionList", this.sourceExpressionList, this.sourceExpressionList != null).item("flattened", this.flattened);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
    }

    public static enum Operation {
        INSERT,
        UPDATE,
        DELETE,
        MERGE;

    }
}

