/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Preconditions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCost;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptPlanner;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTraitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelDistribution;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelDistributionTraitDef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelDistributions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelInput;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelWriter;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.SingleRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Util;
import java.util.List;

public abstract class Exchange
extends SingleRel {
    public final RelDistribution distribution;

    protected Exchange(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDistribution distribution) {
        super(cluster, traitSet, input);
        this.distribution = Preconditions.checkNotNull(distribution);
        assert (traitSet.containsIfApplicable(distribution)) : "traits=" + traitSet + ", distribution" + distribution;
        assert (distribution != RelDistributions.ANY);
    }

    public Exchange(RelInput input) {
        this(input.getCluster(), input.getTraitSet().plus(input.getCollation()), input.getInput(), RelDistributionTraitDef.INSTANCE.canonize(input.getDistribution()));
    }

    @Override
    public final Exchange copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Exchange.sole(inputs), this.distribution);
    }

    public abstract Exchange copy(RelTraitSet var1, RelNode var2, RelDistribution var3);

    public RelDistribution getDistribution() {
        return this.distribution;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rowCount = mq.getRowCount(this);
        double bytesPerRow = this.getRowType().getFieldCount() * 4;
        return planner.getCostFactory().makeCost(Util.nLogN(rowCount) * bytesPerRow, rowCount, 0.0);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("distribution", this.distribution);
    }
}

