/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree;

import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.Enumerator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.ArrayLengthRecordField;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expression;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expressions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Primitive;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.PseudoField;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.ReflectedPseudoField;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class Types {
    private Types() {
    }

    public static Type of(Type type, Type ... typeArguments) {
        if (typeArguments.length == 0) {
            return type;
        }
        return new ParameterizedTypeImpl(type, Types.toList(typeArguments), null);
    }

    public static Type getElementType(Type type) {
        if (type instanceof ArrayType) {
            return ((ArrayType)type).getComponentType();
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        Class clazz = Types.toClass(type);
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (Collection.class.isAssignableFrom(clazz) || Iterable.class.isAssignableFrom(clazz) || Iterator.class.isAssignableFrom(clazz) || Enumerator.class.isAssignableFrom(clazz)) {
            if (type instanceof ParameterizedType) {
                return ((ParameterizedType)type).getActualTypeArguments()[0];
            }
            return Object.class;
        }
        return null;
    }

    private static <T> List<T> toList(T[] ts) {
        switch (ts.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(ts[0]);
            }
        }
        return Arrays.asList((Object[])ts.clone());
    }

    static Field getField(String fieldName, Class clazz) {
        try {
            return clazz.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unknown field '" + fieldName + "' in class " + clazz, e);
        }
    }

    static PseudoField getField(String fieldName, Type type) {
        if (type instanceof RecordType) {
            return Types.getRecordField(fieldName, (RecordType)type);
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            return Types.getSystemField(fieldName, (Class)type);
        }
        return Types.field(Types.getField(fieldName, Types.toClass(type)));
    }

    private static RecordField getRecordField(String fieldName, RecordType type) {
        for (RecordField field : type.getRecordFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        throw new RuntimeException("Unknown field '" + fieldName + "' in type " + type);
    }

    private static RecordField getSystemField(String fieldName, Class clazz) {
        return new ArrayLengthRecordField(fieldName, clazz);
    }

    public static Class toClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Types.toClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            return Types.toClass(typeVariable.getBounds()[0]);
        }
        throw new RuntimeException("unsupported type " + type);
    }

    static Class[] toClassArray(Collection<Type> types) {
        ArrayList<Class> classes = new ArrayList<Class>();
        for (Type type : types) {
            classes.add(Types.toClass(type));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    static Class[] toClassArray(Iterable<? extends Expression> arguments) {
        ArrayList<Class> classes = new ArrayList<Class>();
        for (Expression expression : arguments) {
            classes.add(Types.toClass(expression.getType()));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static Type getComponentType(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        if (type instanceof ArrayType) {
            return ((ArrayType)type).getComponentType();
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        if (type instanceof ParameterizedType) {
            return Types.getComponentType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            return Types.getComponentType(typeVariable.getBounds()[0]);
        }
        return null;
    }

    static Type getComponentTypeN(Type type) {
        Type oldType;
        do {
            oldType = type;
        } while ((type = Types.getComponentType(type)) != null);
        return oldType;
    }

    static String boxClassName(Type type) {
        if (!(type instanceof Class)) {
            return type.toString();
        }
        Primitive primitive = Primitive.of(type);
        if (primitive != null) {
            return primitive.boxClass.getSimpleName();
        }
        return Types.className(type);
    }

    public static Type box(Type type) {
        Primitive primitive = Primitive.of(type);
        if (primitive != null) {
            return primitive.boxClass;
        }
        return type;
    }

    public static Type unbox(Type type) {
        Primitive primitive = Primitive.ofBox(type);
        if (primitive != null) {
            return primitive.primitiveClass;
        }
        return type;
    }

    static String className(Type type) {
        if (type instanceof ArrayType) {
            return Types.className(((ArrayType)type).getComponentType()) + "[]";
        }
        if (!(type instanceof Class)) {
            return type.toString();
        }
        Class clazz = (Class)type;
        if (clazz.isArray()) {
            return Types.className(clazz.getComponentType()) + "[]";
        }
        String className = clazz.getName();
        if (!clazz.isPrimitive() && clazz.getPackage() != null && clazz.getPackage().getName().equals("java.lang")) {
            return className.substring("java.lang.".length());
        }
        return className.replace('$', '.');
    }

    public static boolean isAssignableFrom(Type type0, Type type) {
        return Types.toClass(type0).isAssignableFrom(Types.toClass(type));
    }

    public static boolean isArray(Type type) {
        return Types.toClass(type).isArray();
    }

    public static Field nthField(int ordinal, Class clazz) {
        return clazz.getFields()[ordinal];
    }

    public static PseudoField nthField(int ordinal, Type clazz) {
        if (clazz instanceof RecordType) {
            RecordType recordType = (RecordType)clazz;
            return recordType.getRecordFields().get(ordinal);
        }
        return Types.field(Types.toClass(clazz).getFields()[ordinal]);
    }

    static boolean allAssignable(boolean varArgs, Class[] parameterTypes, Class[] argumentTypes) {
        if (varArgs ? argumentTypes.length < parameterTypes.length - 1 : parameterTypes.length != argumentTypes.length) {
            return false;
        }
        for (int i = 0; i < argumentTypes.length; ++i) {
            Class<Object> parameterType;
            Class<Object> clazz = parameterType = !varArgs || i < parameterTypes.length - 1 ? parameterTypes[i] : Object.class;
            if (Types.assignableFrom(parameterType, argumentTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignableFrom(Class parameter, Class argument) {
        return parameter.isAssignableFrom(argument) || parameter.isPrimitive() && argument.isPrimitive() && Primitive.of(parameter).assignableFrom(Primitive.of(argument));
    }

    public static Method lookupMethod(Class clazz, String methodName, Class ... argumentTypes) {
        try {
            return clazz.getMethod(methodName, argumentTypes);
        }
        catch (NoSuchMethodException e) {
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(methodName) || !Types.allAssignable(method.isVarArgs(), method.getParameterTypes(), argumentTypes)) continue;
                return method;
            }
            throw new RuntimeException("while resolving method '" + methodName + Arrays.toString(argumentTypes) + "' in class " + clazz, e);
        }
    }

    public static Constructor lookupConstructor(Type type, Class ... argumentTypes) {
        Constructor<?>[] constructors;
        Class clazz = Types.toClass(type);
        for (Constructor<?> constructor : constructors = clazz.getDeclaredConstructors()) {
            if (!Types.allAssignable(constructor.isVarArgs(), constructor.getParameterTypes(), argumentTypes)) continue;
            return constructor;
        }
        if (constructors.length == 0 && argumentTypes.length == 0) {
            Constructor<?>[] constructors1 = clazz.getConstructors();
            try {
                return clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        throw new RuntimeException("while resolving constructor in class " + type + " with types " + Arrays.toString(argumentTypes));
    }

    public static Field lookupField(Type type, String name) {
        Class clazz = Types.toClass(type);
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("while resolving field in class " + type);
        }
    }

    public static void discard(Object o) {
    }

    static Type gcd(Type ... types) {
        if (types.length == 0) {
            return Object.class;
        }
        Type best = types[0];
        Primitive bestPrimitive = Primitive.of(best);
        if (bestPrimitive != null) {
            for (int i = 1; i < types.length; ++i) {
                Primitive primitive = Primitive.of(types[i]);
                if (primitive == null) {
                    return Object.class;
                }
                if (primitive.assignableFrom(bestPrimitive)) {
                    bestPrimitive = primitive;
                    continue;
                }
                if (bestPrimitive.assignableFrom(primitive)) continue;
                if (bestPrimitive == Primitive.CHAR || bestPrimitive == Primitive.BYTE) {
                    bestPrimitive = Primitive.INT;
                    --i;
                    continue;
                }
                return Object.class;
            }
            return bestPrimitive.primitiveClass;
        }
        for (int i = 1; i < types.length; ++i) {
            if (types[i] == types[0]) continue;
            return Object.class;
        }
        return types[0];
    }

    public static Expression castIfNecessary(Type returnType, Expression expression) {
        Type type = expression.getType();
        if (returnType instanceof RecordType) {
            return expression;
        }
        if (Types.isAssignableFrom(returnType, type)) {
            return expression;
        }
        if (returnType instanceof Class && Number.class.isAssignableFrom((Class)returnType) && type instanceof Class && Number.class.isAssignableFrom((Class)type)) {
            return Expressions.unbox(expression, Primitive.ofBox(returnType));
        }
        if (Primitive.is(returnType) && !Primitive.is(type)) {
            return Expressions.unbox((Expression)Expressions.convert_(expression, Types.box(returnType)), Primitive.of(returnType));
        }
        if (!Primitive.is(returnType) && Primitive.is(type)) {
            return Expressions.convert_(expression, Types.unbox(returnType));
        }
        return Expressions.convert_(expression, returnType);
    }

    public static PseudoField field(Field field) {
        return new ReflectedPseudoField(field);
    }

    static Class arrayClass(Type type) {
        return Array.newInstance(Types.toClass(type), 0).getClass();
    }

    static Type arrayType(Type type, int dimension) {
        for (int i = 0; i < dimension; ++i) {
            type = Types.arrayType(type);
        }
        return type;
    }

    static Type arrayType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return Array.newInstance(clazz, 0).getClass();
        }
        return new ArrayType(type);
    }

    public static Type stripGenerics(Type type) {
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return new ArrayType(Types.stripGenerics(componentType));
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getRawType();
        }
        return type;
    }

    public static class MapType
    implements Type {
        private final Type keyType;
        private final boolean keyIsNullable;
        private final Type valueType;
        private final boolean valueIsNullable;

        public MapType(Type keyType, boolean keyIsNullable, Type valueType, boolean valueIsNullable) {
            this.keyType = keyType;
            this.keyIsNullable = keyIsNullable;
            this.valueType = valueType;
            this.valueIsNullable = valueIsNullable;
        }

        public Type getKeyType() {
            return this.keyType;
        }

        public boolean keyIsNullable() {
            return this.keyIsNullable;
        }

        public Type getValueType() {
            return this.valueType;
        }

        public boolean valueIsNullable() {
            return this.valueIsNullable;
        }
    }

    public static class ArrayType
    implements Type {
        private final Type componentType;
        private final boolean componentIsNullable;
        private final long maximumCardinality;

        public ArrayType(Type componentType, boolean componentIsNullable, long maximumCardinality) {
            this.componentType = componentType;
            this.componentIsNullable = componentIsNullable;
            this.maximumCardinality = Math.max(maximumCardinality, -1L);
        }

        public ArrayType(Type componentType) {
            this(componentType, !Primitive.is(componentType), -1L);
        }

        public Type getComponentType() {
            return this.componentType;
        }

        public boolean componentIsNullable() {
            return this.componentIsNullable;
        }

        public long maximumCardinality() {
            return this.maximumCardinality;
        }
    }

    public static interface RecordField
    extends PseudoField {
        public boolean nullable();
    }

    public static interface RecordType
    extends Type {
        public List<RecordField> getRecordFields();

        public String getName();
    }

    static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type rawType;
        private final List<Type> typeArguments;
        private final Type ownerType;

        ParameterizedTypeImpl(Type rawType, List<Type> typeArguments, Type ownerType) {
            this.rawType = rawType;
            this.typeArguments = typeArguments;
            this.ownerType = ownerType;
            assert (rawType != null);
            for (Type typeArgument : typeArguments) {
                assert (typeArgument != null);
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(Types.className(this.rawType));
            buf.append("<");
            int i = 0;
            for (Type typeArgument : this.typeArguments) {
                if (i++ > 0) {
                    buf.append(", ");
                }
                buf.append(Types.className(typeArgument));
            }
            buf.append(">");
            return buf.toString();
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArguments.toArray(new Type[this.typeArguments.size()]);
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }
    }
}

