/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable;

import com.alibaba.lindorm.thirdparty.com.google.common.base.Supplier;
import com.alibaba.lindorm.thirdparty.com.google.common.collect.ImmutableList;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.PhysType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.RexImpTable;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expression;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Expressions;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.linq4j.tree.Primitive;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelOptCluster;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTrait;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.plan.RelTraitSet;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelCollation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelCollationTraitDef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelDistribution;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelDistributionTraitDef;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.RelNode;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.core.Values;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMdCollation;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMdDistribution;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataType;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rel.type.RelDataTypeField;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.rex.RexLiteral;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.BuiltInMethod;
import com.alibaba.lindorm.thirdparty.org.apache.calcite.util.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class EnumerableValues
extends Values
implements EnumerableRel {
    private EnumerableValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traitSet) {
        super(cluster, rowType, tuples, traitSet);
    }

    public static EnumerableValues create(RelOptCluster cluster, final RelDataType rowType, final ImmutableList<ImmutableList<RexLiteral>> tuples) {
        final RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, new Supplier<List<RelCollation>>(){

            @Override
            public List<RelCollation> get() {
                return RelMdCollation.values(mq, rowType, tuples);
            }
        }).replaceIf(RelDistributionTraitDef.INSTANCE, new Supplier<RelDistribution>(){

            @Override
            public RelDistribution get() {
                return RelMdDistribution.values(rowType, tuples);
            }
        });
        return new EnumerableValues(cluster, rowType, tuples, traitSet);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return EnumerableValues.create(this.getCluster(), this.rowType, this.tuples);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        JavaTypeFactory typeFactory = (JavaTypeFactory)this.getCluster().getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferCustom());
        Type rowClass = physType.getJavaRowType();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        List<RelDataTypeField> fields = this.rowType.getFieldList();
        for (List tuple : this.tuples) {
            ArrayList<Expression> literals = new ArrayList<Expression>();
            for (Pair pair : Pair.zip(fields, tuple)) {
                literals.add(RexToLixTranslator.translateLiteral((RexLiteral)pair.right, ((RelDataTypeField)pair.left).getType(), typeFactory, RexImpTable.NullAs.NULL));
            }
            expressions.add(physType.record(literals));
        }
        builder.add(Expressions.return_(null, Expressions.call(BuiltInMethod.AS_ENUMERABLE.method, Expressions.newArrayInit(Primitive.box(rowClass), expressions))));
        return implementor.result(physType, builder.toBlock());
    }
}

