/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.netty.jctools.queues;

import com.alibaba.lindorm.thirdparty.netty.jctools.queues.MessagePassingQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.MpscChunkedArrayQueue;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.QueueProgressIndicators;
import com.alibaba.lindorm.thirdparty.netty.jctools.util.Pow2;

public class MpscGrowableArrayQueue<E>
extends MpscChunkedArrayQueue<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    public MpscGrowableArrayQueue(int maxCapacity) {
        super(Math.max(2, Pow2.roundToPowerOfTwo(maxCapacity / 8)), maxCapacity);
    }

    public MpscGrowableArrayQueue(int initialCapacity, int maxCapacity) {
        super(initialCapacity, maxCapacity);
    }

    @Override
    protected int getNextBufferSize(E[] buffer) {
        long maxSize = this.maxQueueCapacity / 2L;
        if ((long)buffer.length > maxSize) {
            throw new IllegalStateException();
        }
        int newSize = 2 * (buffer.length - 1);
        return newSize + 1;
    }

    @Override
    protected long getCurrentBufferCapacity(long mask) {
        return mask + 2L == this.maxQueueCapacity ? this.maxQueueCapacity : mask;
    }
}

