/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.dml;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class ColumnKey
extends VersionedObjectWithAttributes {
    protected byte[] family;
    protected byte[] qualifier;
    protected int hashCode;
    protected byte[] fullName;

    public ColumnKey() {
    }

    public ColumnKey(byte[] qualifier) {
        this.setQualifier(qualifier);
    }

    public ColumnKey(String qualifier) {
        this.setQualifier(qualifier);
    }

    public ColumnKey(String family, String qualifier) {
        this.validateFamily(family);
        this.validateQualifier(qualifier);
        this.init(Bytes.toBytes(family), Bytes.toBytes(qualifier));
    }

    public ColumnKey(byte[] family, byte[] qualifier) {
        this.validateFamily(family);
        this.validateQualifier(qualifier);
        this.init(family, qualifier);
    }

    public ColumnKey(ColumnKey other) {
        this.family = other.family;
        this.qualifier = other.qualifier;
        this.hashCode = other.hashCode;
        this.fullName = other.fullName;
    }

    public boolean hasFamily() {
        return this.family != null && this.family.length > 0;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public String getFamilyAsString() {
        return Bytes.toString(this.family);
    }

    public void setFamily(String family) {
        this.validateFamily(family);
        this.doSetFamily(Bytes.toBytes(family));
    }

    public void setFamily(byte[] family) {
        this.validateFamily(family);
        this.doSetFamily(family);
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    public String getQualifierAsString() {
        return Bytes.toString(this.qualifier);
    }

    public void setQualifier(String qualifier) {
        this.validateQualifier(qualifier);
        this.doSetQualifier(Bytes.toBytes(qualifier));
    }

    public void setQualifier(byte[] qualifier) {
        this.validateQualifier(qualifier);
        this.doSetQualifier(qualifier);
    }

    public byte[] getFullName() {
        if (this.fullName == null) {
            this.fullName = SchemaUtils.getFullColumnNameBytes(this.family, this.qualifier);
        }
        return this.fullName;
    }

    public String getFullNameAsString() {
        return Bytes.toString(this.getFullName());
    }

    public int getByteSize() {
        int size = 0;
        size += this.family == null ? 0 : this.family.length + 2;
        size += this.qualifier == null ? 0 : this.qualifier.length + 2;
        return size += 4;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.family) * 31 + Arrays.hashCode(this.qualifier);
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnKey)) {
            return false;
        }
        ColumnKey other = (ColumnKey)obj;
        if (this.hashCode() != other.hashCode()) {
            return false;
        }
        if (!Bytes.equals(this.qualifier, other.qualifier)) {
            return false;
        }
        return Bytes.equals(this.family, other.family);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bytes.writeByteArray(out, this.family);
        Bytes.writeByteArray(out, this.qualifier);
        WritableUtils.writeVInt(out, this.hashCode);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.family = Bytes.readByteArrayNullable(in);
        this.qualifier = Bytes.readByteArray(in);
        this.hashCode = WritableUtils.readVInt(in);
    }

    @Override
    public String toString() {
        return this.getFullNameAsString();
    }

    private void reset() {
        this.fullName = null;
        this.hashCode = 0;
    }

    private void init(byte[] family, byte[] qualifier) {
        this.family = family;
        this.qualifier = qualifier;
        this.reset();
    }

    private void doSetQualifier(byte[] qualifier) {
        this.qualifier = qualifier;
        this.reset();
    }

    private void doSetFamily(byte[] family) {
        this.family = family;
        this.reset();
    }

    private void validateFamily(String family) throws IllegalArgumentException {
        if (family != null && family.isEmpty()) {
            throw new IllegalArgumentException("Family can be null or a valid string, must not be empty.");
        }
    }

    private void validateFamily(byte[] family) throws IllegalArgumentException {
        if (family != null && family.length == 0) {
            throw new IllegalArgumentException("Family can be null or a valid byte[], must not be empty.");
        }
    }

    private void validateQualifier(String qualifier) throws IllegalArgumentException {
        if (qualifier == null || qualifier.isEmpty()) {
            throw new IllegalArgumentException("Qualifier cannot be null or empty.");
        }
    }

    private void validateQualifier(byte[] qualifier) throws IllegalArgumentException {
        if (qualifier == null || qualifier.length == 0) {
            throw new IllegalArgumentException("Qualifier cannot be null or empty.");
        }
    }
}

