/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.WResult;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WPartialResult
extends VersionedObjectWithAttributes {
    private static final String RESUME_ROW = "_resume_";
    private List<WResult> results;
    private byte[] nextStartKey = null;
    private int skipped = 0;

    public WPartialResult() {
    }

    public WPartialResult(List<WResult> results, byte[] nextStartKey) {
        this.results = results;
        this.nextStartKey = nextStartKey;
    }

    public WPartialResult(List<WResult> results, byte[] nextStartKey, byte[] resumeRow) {
        this(results, nextStartKey);
        this.setAttribute(RESUME_ROW, resumeRow);
    }

    public int getSkipped() {
        return this.skipped;
    }

    public void setSkipped(int skipped) {
        this.skipped = skipped;
    }

    public List<WResult> getResults() {
        return this.results;
    }

    public void setResults(List<WResult> results) {
        this.results = results;
    }

    public byte[] getNextStartKey() {
        return this.nextStartKey;
    }

    public void setNextStartKey(byte[] nextStartPrimaryKey) {
        this.nextStartKey = nextStartPrimaryKey;
    }

    public byte[] getResumeRow() {
        return this.getAttribute(RESUME_ROW);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        if (this.results == null || this.results.size() == 0) {
            WritableUtils.writeVInt(out, 0);
        } else {
            WritableUtils.writeVInt(out, this.results.size());
            for (WResult wResult : this.results) {
                wResult.writeTo(out);
            }
        }
        Bytes.writeByteArray(out, this.nextStartKey);
        WritableUtils.writeVInt(out, this.skipped);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.results = new ArrayList<WResult>();
        int size = WritableUtils.readVInt(in);
        for (int i = 0; i < size; ++i) {
            WResult result = new WResult();
            result.readFrom(in);
            this.results.add(result);
        }
        this.nextStartKey = Bytes.readByteArrayNullable(in);
        this.skipped = WritableUtils.readVInt(in);
    }
}

