/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.OpTimeout;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.WRow;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;

public abstract class WMutation
extends WRow
implements OpTimeout {
    public static final long NOLOCK = -1L;
    protected long lockId = -1L;
    protected boolean writeToWAL = true;
    private static final String CLUSTER_ID_ATTR = "CID";
    private int operationTimeout = -1;
    private int glitchTimeout = -1;

    public WMutation() {
    }

    public WMutation(byte[] rowKey) {
        this(rowKey, Long.MAX_VALUE, -1L);
    }

    public WMutation(byte[] row, long ts) {
        this(row, ts, -1L);
    }

    public WMutation(byte[] rowKey, long ts, long lockId) {
        super(rowKey, ts);
        this.lockId = lockId;
    }

    public WMutation(WMutation wMutationToCopy) {
        super(wMutationToCopy);
        this.lockId = wMutationToCopy.lockId;
        this.writeToWAL = wMutationToCopy.writeToWAL;
    }

    public long getLockId() {
        return this.lockId;
    }

    public boolean isWriteToWAL() {
        return this.writeToWAL;
    }

    public void setLockId(long lockId) {
        this.lockId = lockId;
    }

    public void setWriteToWAL(boolean writeToWAL) {
        this.writeToWAL = writeToWAL;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVLong(out, this.lockId);
        out.writeBoolean(this.writeToWAL);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.lockId = WritableUtils.readVLong(in);
        this.writeToWAL = in.readBoolean();
    }

    public void setClusterId(UUID clusterId) {
        byte[] val = new byte[16];
        Bytes.putLong(val, 0, clusterId.getMostSignificantBits());
        Bytes.putLong(val, 8, clusterId.getLeastSignificantBits());
        this.setAttribute(CLUSTER_ID_ATTR, val);
    }

    public UUID getClusterId() {
        byte[] attr = this.getAttribute(CLUSTER_ID_ATTR);
        if (attr == null) {
            return null;
        }
        return new UUID(Bytes.toLong(attr, 0), Bytes.toLong(attr, 8));
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    @Override
    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    @Override
    public int getGlitchTimeout() {
        return this.glitchTimeout;
    }

    @Override
    public void setGlitchTimeout(int glitchTimeout) {
        this.glitchTimeout = glitchTimeout;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("[").append("wal=").append(this.writeToWAL).append("]");
        builder.append(super.toString());
        return builder.toString();
    }
}

