/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.widecolumnservice.WMutation;
import com.alibaba.lindorm.client.core.widecolumnservice.WTimeRange;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class WIncrement
extends WMutation {
    private WTimeRange tr = new WTimeRange();
    private Map<byte[], NavigableMap<byte[], Long>> familyMap = new TreeMap<byte[], NavigableMap<byte[], Long>>(Bytes.BYTES_COMPARATOR);

    public WIncrement() {
    }

    public WIncrement(byte[] row) {
        this(row, -1L);
    }

    public WIncrement(byte[] row, long rowLock) {
        super(row, rowLock);
    }

    public WIncrement addColumn(byte[] family, byte[] qualifier, long amount) {
        NavigableMap<byte[], Long> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
        }
        set.put(qualifier, amount);
        this.familyMap.put(family, set);
        return this;
    }

    public WTimeRange getTimeRange() {
        return this.tr;
    }

    public WIncrement setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new WTimeRange(minStamp, maxStamp);
        return this;
    }

    public Set<byte[]> familySet() {
        return this.familyMap.keySet();
    }

    public int numFamilies() {
        return this.familyMap.size();
    }

    public int numColumns() {
        if (!this.hasFamilies()) {
            return 0;
        }
        int num = 0;
        for (NavigableMap<byte[], Long> family : this.familyMap.values()) {
            num += family.size();
        }
        return num;
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public Map<byte[], NavigableMap<byte[], Long>> getIncrementFamilyMap() {
        return this.familyMap;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("row=");
        sb.append(Bytes.toStringBinary(this.rowKey));
        if (this.familyMap.size() == 0) {
            sb.append(", no columns set to be incremented");
            return sb.toString();
        }
        sb.append(", families=");
        boolean moreThanOne = false;
        for (Map.Entry<byte[], NavigableMap<byte[], Long>> entry : this.familyMap.entrySet()) {
            if (moreThanOne) {
                sb.append("), ");
            } else {
                moreThanOne = true;
                sb.append("{");
            }
            sb.append("(family=");
            sb.append(Bytes.toString(entry.getKey()));
            sb.append(", columns=");
            if (entry.getValue() == null) {
                sb.append("NONE");
                continue;
            }
            sb.append("{");
            boolean moreThanOneB = false;
            for (Map.Entry column : entry.getValue().entrySet()) {
                if (moreThanOneB) {
                    sb.append(", ");
                } else {
                    moreThanOneB = true;
                }
                sb.append(Bytes.toStringBinary((byte[])column.getKey()) + "+=" + column.getValue());
            }
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        this.tr.writeTo(out);
        if (this.familyMap.size() == 0) {
            throw new IOException("At least one column required");
        }
        out.writeInt(this.familyMap.size());
        for (Map.Entry<byte[], NavigableMap<byte[], Long>> entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey());
            NavigableMap<byte[], Long> columnSet = entry.getValue();
            if (columnSet == null) {
                throw new IOException("At least one column required per family");
            }
            out.writeBoolean(true);
            out.writeInt(columnSet.size());
            for (Map.Entry qualifier : columnSet.entrySet()) {
                Bytes.writeByteArray(out, (byte[])qualifier.getKey());
                out.writeLong((Long)qualifier.getValue());
            }
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.tr = new WTimeRange();
        this.tr.readFrom(in);
        int numFamilies = in.readInt();
        if (numFamilies == 0) {
            throw new IOException("At least one column required");
        }
        this.familyMap = new TreeMap<byte[], NavigableMap<byte[], Long>>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            boolean hasColumns = in.readBoolean();
            TreeMap<byte[], Long> set = null;
            if (hasColumns) {
                int numColumns = in.readInt();
                set = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
                for (int j = 0; j < numColumns; ++j) {
                    byte[] qualifier = Bytes.readByteArray(in);
                    set.put(qualifier, in.readLong());
                }
            } else {
                throw new IOException("At least one column required per family");
            }
            this.familyMap.put(family, set);
        }
    }
}

