/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.OpTimeout;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.WTimeRange;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class WGet
extends VersionedObjectWithAttributes
implements OpTimeout {
    private byte[] rowKey = null;
    private long lockId = -1L;
    private int maxVersions = 1;
    private boolean cacheBlocks = true;
    private WFilter filter = null;
    private WTimeRange tr = new WTimeRange();
    private Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
    int operationTimeout = -1;
    int glitchTimeout = -1;

    public WGet() {
    }

    public WGet(byte[] rowKey) {
        this(rowKey, -1L);
    }

    public WGet(byte[] rowKey, long rowLock) {
        this.rowKey = rowKey;
        this.lockId = rowLock;
    }

    public WGet addFamily(byte[] family) {
        this.familyMap.remove(family);
        this.familyMap.put(family, null);
        return this;
    }

    public WGet addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        }
        set.add(qualifier);
        this.familyMap.put(family, set);
        return this;
    }

    public WGet setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new WTimeRange(minStamp, maxStamp);
        return this;
    }

    public WGet setTimeStamp(long timestamp) {
        try {
            this.tr = new WTimeRange(timestamp, timestamp + 1L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public WGet setMaxVersions() {
        this.maxVersions = Integer.MAX_VALUE;
        return this;
    }

    public WGet setMaxVersions(int maxVersions) throws IOException {
        if (maxVersions <= 0) {
            throw new IOException("maxVersions must be positive");
        }
        this.maxVersions = maxVersions;
        return this;
    }

    public WGet setFilter(WFilter filter) {
        this.filter = filter;
        return this;
    }

    public WFilter getFilter() {
        return this.filter;
    }

    public void setCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    public long getLockId() {
        return this.lockId;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public WTimeRange getTimeRange() {
        return this.tr;
    }

    public Set<byte[]> familySet() {
        return this.familyMap.keySet();
    }

    public byte[] getRowKey() {
        return this.rowKey;
    }

    public int numFamilies() {
        return this.familyMap.size();
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    public void setFamilyMap(Map<byte[], NavigableSet<byte[]>> familyMap) {
        this.familyMap = familyMap;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bytes.writeByteArray(out, this.rowKey);
        WritableUtils.writeVLong(out, this.lockId);
        WritableUtils.writeVInt(out, this.maxVersions);
        out.writeBoolean(this.cacheBlocks);
        WFilter.write(out, this.filter);
        this.tr.writeTo(out);
        WritableUtils.writeVInt(out, this.familyMap.size());
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey());
            NavigableSet<byte[]> columnSet = entry.getValue();
            if (columnSet != null) {
                WritableUtils.writeVInt(out, columnSet.size());
                for (byte[] qualifier : columnSet) {
                    Bytes.writeByteArray(out, qualifier);
                }
                continue;
            }
            WritableUtils.writeVInt(out, 0);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.rowKey = Bytes.readByteArray(in);
        this.lockId = WritableUtils.readVLong(in);
        this.maxVersions = WritableUtils.readVInt(in);
        this.cacheBlocks = in.readBoolean();
        this.filter = WFilter.read(in);
        this.tr = new WTimeRange();
        this.tr.readFrom(in);
        int numFamilies = WritableUtils.readVInt(in);
        this.familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            int numColumns = WritableUtils.readVInt(in);
            TreeSet<byte[]> set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            for (int j = 0; j < numColumns; ++j) {
                byte[] qualifier = Bytes.readByteArray(in);
                set.add(qualifier);
            }
            this.familyMap.put(family, set);
        }
    }

    @Override
    public String toString() {
        int maxCols = 5;
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>();
        map.put("families", families);
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary(entry.getKey()));
        }
        HashMap columns = new HashMap();
        map.put("families", columns);
        map.put("row", Bytes.toStringBinary(this.rowKey));
        if (this.maxVersions > 1) {
            map.put("maxVersions", this.maxVersions);
        }
        if (!this.cacheBlocks) {
            map.put("cacheBlocks", this.cacheBlocks);
        }
        if (!this.tr.containsAllTime()) {
            ArrayList<Long> timeRange = new ArrayList<Long>();
            timeRange.add(this.tr.getMin());
            timeRange.add(this.tr.getMax());
            map.put("timeRange", timeRange);
        }
        int colCount = 0;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            ArrayList<String> familyList = new ArrayList<String>();
            columns.put(Bytes.toStringBinary(entry.getKey()), familyList);
            if (entry.getValue() == null) {
                ++colCount;
                --maxCols;
                familyList.add("ALL");
                continue;
            }
            colCount += entry.getValue().size();
            if (maxCols <= 0) continue;
            for (byte[] column : entry.getValue()) {
                if (--maxCols <= 0) continue;
                familyList.add(Bytes.toStringBinary(column));
            }
        }
        map.put("totalColumns", colCount);
        if (this.filter != null) {
            map.put("filter", this.filter.toString());
        }
        return ((Object)map).toString();
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    @Override
    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    @Override
    public int getGlitchTimeout() {
        return this.glitchTimeout;
    }

    @Override
    public void setGlitchTimeout(int glitchTimeout) {
        this.glitchTimeout = glitchTimeout;
    }
}

