/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.feedstreamservice.FeedStreamAttributes;
import com.alibaba.lindorm.client.core.feedstreamservice.LMessage;
import com.alibaba.lindorm.client.core.feedstreamservice.StreamRowToMessageVisitor;
import com.alibaba.lindorm.client.core.feedstreamservice.StreamSchema;
import com.alibaba.lindorm.client.core.meta.TableAttributes;
import com.alibaba.lindorm.client.core.tableservice.LSelect;
import com.alibaba.lindorm.client.core.tableservice.LUpsert;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.LindormObjectUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.dml.Select;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor;
import com.alibaba.lindorm.client.schema.ColumnSchema;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.LindormPipeDescriptor;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import com.alibaba.lindorm.client.schema.PrimaryKeySchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class FeedStreamUtils {
    public static final String STREAM_SCHEMA_KEY = "SS_STREAM_SCHEMA";
    public static final byte[] STREAM_SCHEMA_KEY_BYTES = Bytes.toBytes("SS_STREAM_SCHEMA");
    public static final String SEQUENCE_FAMILY_NAME = "s";
    public static final byte[] SEQUENCE_FAMILY_NAME_BYTES = Bytes.toBytes("s");
    public static final String IDEMPOTENT_FAMILY_NAME = "i";
    public static final byte[] IDEMPOTENT_FAMILY_NAME_BYTES = Bytes.toBytes("i");
    public static final String VALUE_FAMILY_NAME = "v";
    public static final byte[] VALUE_FAMILY_NAME_BYTES = Bytes.toBytes("v");
    public static final String HASH_COLUMN_NAME = "hash";
    public static final byte[] HASH_COLUMN_NAME_BYTES = Bytes.toBytes("hash");
    public static final String STREAM_NAME_COLUMN_NAME = "stream_name";
    public static final byte[] STREAM_NAME_COLUMN_NAME_BYTES = Bytes.toBytes("stream_name");
    public static final String MESSAGE_ID_COLUMN_NAME = "seq";
    public static final byte[] MESSAGE_ID_COLUMN_NAME_BYTES = Bytes.toBytes("seq");
    public static final String ZERO_COLUMN_NAME = "zero";
    public static final byte[] ZERO_COLUMN_NAME_BYTES = Bytes.toBytes("zero");
    public static final String IDEMPOTENT_ID_COLUMN_NAME = "idem";
    public static final byte[] IDEMPOTENT_ID_COLUMN_NAME_BYTES = Bytes.toBytes("idem");
    public static final String BODY_COLUMN_NAME = "body";
    public static final byte[] BODY_COLUMN_NAME_BYTES = Bytes.toBytes("body");
    public static final int HASH_LENGTH = 4;
    public static final int ZERO_COLUMN_LENGTH = 1;
    public static final ColumnKey CKV_HASH = new ColumnKey(HASH_COLUMN_NAME_BYTES);
    public static final ColumnKey CKV_STREAM_NAME = new ColumnKey(STREAM_NAME_COLUMN_NAME_BYTES);
    public static final ColumnKey CKV_MESSAGE_ID = new ColumnKey(MESSAGE_ID_COLUMN_NAME_BYTES);
    public static final ColumnKey CKV_IDEMPOTENT_ID = new ColumnKey(VALUE_FAMILY_NAME_BYTES, IDEMPOTENT_ID_COLUMN_NAME_BYTES);
    public static final ColumnKey CKV_BODY = new ColumnKey(VALUE_FAMILY_NAME_BYTES, BODY_COLUMN_NAME_BYTES);
    public static final List<PrimaryKeySchema> sequencePkSchema;
    public static final List<ColumnSchema> sequenceNonPkSchema;
    public static final List<PrimaryKeySchema> idempotentPkSchema;
    public static final List<ColumnSchema> idempotentNonPkSchema;
    public static final List<PrimaryKeySchema> valuePkSchema;
    public static final List<ColumnSchema> valueNonPkSchema;
    public static final StreamRowToMessageVisitor COLUMN_MAPPER;
    public static final String FEED_ATTR = "FEED_ATTR";

    public static ColumnFamilyDescriptor updateValueFamilyDescriptor(ColumnFamilyDescriptor cfd) {
        return cfd;
    }

    public static ColumnFamilyDescriptor updateSequenceFamilyDescriptor(ColumnFamilyDescriptor cfd) {
        cfd.setInMemory(true);
        return cfd;
    }

    public static ColumnFamilyDescriptor updateIdempotentFamilyDescriptor(ColumnFamilyDescriptor cfd) {
        cfd.setInMemory(true);
        return cfd;
    }

    public static void validateFamilyName(String actualName, String expectedName) throws IllegalRequestException {
        if (!actualName.equals(expectedName)) {
            throw new IllegalRequestException("Must not modify family name, expectedName=" + expectedName + ", actualName=" + actualName);
        }
    }

    public static boolean isFeedStreamTable(TableAttributes ta) {
        return ta.getAttribute(STREAM_SCHEMA_KEY) != null;
    }

    public static LindormTableDescriptor createPipeTableDescriptor(LindormPipeDescriptor pipe) throws LindormException {
        LindormTableDescriptor desc = new LindormTableDescriptor(pipe.getName());
        desc.setName(pipe.getName());
        TableAttributes ta = pipe.getTableAttributes();
        desc.setTableAttributes(ta);
        StreamSchema streamSchema = new StreamSchema();
        ArrayList<ColumnFamilyDescriptor> families = new ArrayList<ColumnFamilyDescriptor>(3);
        desc.setFamilies(families);
        ColumnFamilyDescriptor cfdValue = pipe.getValueFamilyDescriptor();
        if (cfdValue == null) {
            ColumnFamilyDescriptor cfd = new ColumnFamilyDescriptor(VALUE_FAMILY_NAME_BYTES);
            cfdValue = FeedStreamUtils.updateValueFamilyDescriptor(cfd);
        }
        cfdValue.setTimeToLive(pipe.getMessageTTL(), TimeUnit.SECONDS);
        families.add(cfdValue);
        cfdValue.setDfsReplication((short)3);
        streamSchema.setValueFamilyName(pipe.getValueFamilyDescriptor().getName());
        ColumnFamilyDescriptor cfdSequence = pipe.getSequenceFamilyDescriptor();
        if (cfdSequence == null) {
            ColumnFamilyDescriptor cfd = new ColumnFamilyDescriptor(SEQUENCE_FAMILY_NAME_BYTES);
            cfdSequence = FeedStreamUtils.updateSequenceFamilyDescriptor(cfd);
        }
        families.add(cfdSequence);
        cfdSequence.setDfsReplication((short)3);
        streamSchema.setSequenceFamilyName(pipe.getSequenceFamilyDescriptor().getName());
        streamSchema.setSequenceSchema(SchemaUtils.convertClientSchemaToInternalSchema(sequencePkSchema, sequenceNonPkSchema));
        if (pipe.isIdempotentEnabled()) {
            ColumnFamilyDescriptor cfdIdempotent = pipe.getIdempotentFamilyDescriptor();
            if (cfdIdempotent == null) {
                ColumnFamilyDescriptor cfd = new ColumnFamilyDescriptor(IDEMPOTENT_FAMILY_NAME);
                cfdIdempotent = FeedStreamUtils.updateIdempotentFamilyDescriptor(cfd);
            }
            cfdIdempotent.setTimeToLive(pipe.getIdempotentWindow(), TimeUnit.SECONDS);
            cfdIdempotent.setDfsReplication((short)3);
            families.add(cfdIdempotent);
            streamSchema.setIdempotentFamilyName(pipe.getIdempotentFamilyDescriptor().getName());
            streamSchema.setIdempotentSchema(SchemaUtils.convertClientSchemaToInternalSchema(idempotentPkSchema, idempotentNonPkSchema));
        }
        ta.setStreamSchema(streamSchema);
        desc.setPkColumns(valuePkSchema);
        desc.setNonPkColumns(valueNonPkSchema);
        desc.setDynamicColumnsEnabled(true);
        desc.setConsistencyType(TableAttributes.ConsistencyType.Strong);
        return desc;
    }

    public static LindormPipeDescriptor createPipeDescriptor(LindormTableDescriptor desc) throws LindormException {
        LindormPipeDescriptor pipe = new LindormPipeDescriptor();
        pipe.setName(desc.getName());
        TableAttributes ta = desc.getTableAttributes();
        StreamSchema props = ta.getStreamSchema();
        if (!FeedStreamUtils.isFeedStreamTable(ta) || props == null) {
            throw new IllegalRequestException("Cannot convert current LindormTableDescriptor to pipe, because it is not a pipe table, desc=" + desc.toString());
        }
        pipe.setTableAttributes(ta);
        pipe.setIdempotentEnabled(ta.isIdempotentEnabled());
        pipe.setValueFamilyDescriptor(desc.getFamily(props.getValueFamilyName()));
        pipe.setMessageTTL(pipe.getValueFamilyDescriptor().getTimeToLive());
        pipe.setSequenceFamilyDescriptor(desc.getFamily(props.getSequenceFamilyName()));
        if (pipe.isIdempotentEnabled()) {
            pipe.setIdempotentFamilyDescriptor(desc.getFamily(props.getIdempotentFamilyName()));
            pipe.setIdempotentWindow(pipe.getIdempotentFamilyDescriptor().getTimeToLive());
        }
        return pipe;
    }

    public static void validatePipeDescriptor(LindormPipeDescriptor desc) throws LindormException {
        SchemaUtils.validateTableName(desc.getName());
        if (desc.getMessageTTL() <= 0) {
            throw new IllegalRequestException("Message TTL must be greater than 0, but has " + desc.getMessageTTL());
        }
        if (desc.isIdempotentEnabled() && desc.getIdempotentWindow() <= 0) {
            throw new IllegalRequestException("Idempotent window must be greater than 0, but has " + desc.getIdempotentWindow());
        }
    }

    public static void validateSystemFamilyProperty(LindormTableDescriptor desc) {
        StreamSchema property = desc.getTableAttributes().getStreamSchema();
        if (property != null) {
            if (property.hasValueFamily() && !desc.hasFamily(property.getSequenceFamilyName())) {
                throw new IllegalArgumentException("Value column family " + Bytes.toString(property.getValueFamilyName()) + " is not found");
            }
            if (property.hasSequenceFamily() && !desc.hasFamily(property.getSequenceFamilyName())) {
                throw new IllegalArgumentException("Sequence column family " + Bytes.toString(property.getSequenceFamilyName()) + " is not found");
            }
            if (property.hasIdempotentFamily() && !desc.hasFamily(property.getIdempotentFamilyName())) {
                throw new IllegalArgumentException("Idempotent column family " + Bytes.toString(property.getIdempotentFamilyName()) + " is not found");
            }
        }
    }

    public static void checkPipeName(String pipe) throws IllegalRequestException {
        if (pipe == null || pipe.isEmpty()) {
            throw new IllegalRequestException("Pipe name must not be null or empty");
        }
    }

    public static void checkStreamName(String streamName) throws IllegalRequestException {
        if (streamName == null || streamName.isEmpty()) {
            throw new IllegalRequestException("Stream name must not be null or empty");
        }
    }

    public static void checkUpdatable(LMessage current, LMessage previous) throws IllegalRequestException {
        if (current.getMessageId() != 0L && current.getMessageId() <= previous.getMessageId()) {
            throw new IllegalRequestException("Message id in new LMessage must be larger than previousMessageId, current message " + current + ", previousMessage " + previous);
        }
        if (!current.getStreamName().equals(previous.getStreamName())) {
            throw new IllegalRequestException("Stream name in new LMessage must be same as previous , current message " + current + ", previousMessage " + previous);
        }
    }

    public static void validateIdempotentIdLength(LMessage msg) throws IllegalRequestException {
        if (msg.getIdempotentId().length > 512) {
            throw new IllegalRequestException("IdempotentId's length must <= 512 bytes, but has " + msg.getIdempotentId().length + " bytes, please use a smaller one. " + msg.toStringBrief());
        }
    }

    public static void validateIdempotentId(byte[] idempotentId) throws IllegalRequestException {
        if (idempotentId == null || idempotentId.length == 0) {
            throw new IllegalRequestException("Idempotent id must not be null or empty.");
        }
        if (idempotentId.length > 512) {
            throw new IllegalRequestException("Idempotent id is too long, max bytes allowed is 512, but has " + idempotentId.length);
        }
    }

    public static void validateMessageId(LMessage msg) throws IllegalRequestException {
        if (msg.getMessageId() < 0L) {
            throw new IllegalRequestException("Illegal messageId " + msg.getMessageId() + ", should be greater than " + 0L + ", streamName=" + msg.getStreamName());
        }
    }

    public static void validateMessageId(long msgId) throws IllegalRequestException {
        if (msgId < 0L) {
            throw new IllegalRequestException("Illegal messageId " + msgId + ", should be greater than " + 0L);
        }
    }

    public static boolean hasSetMessageId(LMessage msg) {
        return msg.getMessageId() != 0L;
    }

    public static byte[] computeHashByStreamName(String streamName) {
        byte[] tmp = Bytes.toBytes(streamName);
        int hash = FeedStreamUtils.murmurHash3(tmp);
        return Bytes.toBytes(hash);
    }

    public static Row messageToRow(LMessage m) throws LindormException {
        byte[] idempotentId;
        byte[] body;
        Row r = new Row();
        FeedStreamUtils.checkStreamName(m.getStreamName());
        r.add(new ColumnValue(HASH_COLUMN_NAME_BYTES, (Object)FeedStreamUtils.computeHashByStreamName(m.getStreamName())));
        r.add(new ColumnValue(STREAM_NAME_COLUMN_NAME_BYTES, (Object)m.getStreamName()));
        if (m.getMessageId() != 0L) {
            FeedStreamUtils.validateMessageId(m);
            r.add(new ColumnValue(MESSAGE_ID_COLUMN_NAME_BYTES, (Object)m.getMessageId()));
        }
        if ((body = m.getMessageBody()) != null) {
            if (body.length > 0) {
                r.add(new ColumnValue(VALUE_FAMILY_NAME_BYTES, BODY_COLUMN_NAME_BYTES, (Object)m.getMessageBody()));
            } else {
                r.add(new ColumnValue(VALUE_FAMILY_NAME_BYTES, BODY_COLUMN_NAME_BYTES, null));
            }
        }
        if ((idempotentId = m.getIdempotentId()) != null) {
            FeedStreamUtils.validateIdempotentIdLength(m);
            r.add(new ColumnValue(VALUE_FAMILY_NAME_BYTES, IDEMPOTENT_ID_COLUMN_NAME_BYTES, (Object)idempotentId));
        }
        if (m.getAllTags() != null) {
            for (Map.Entry<String, byte[]> tag : m.getAllTags().entrySet()) {
                r.add(new ColumnValue(VALUE_FAMILY_NAME, tag.getKey(), (Object)tag.getValue()));
            }
        }
        return r;
    }

    public static LMessage rowToMessage(String streamName, Row r) throws LindormException {
        LMessage result = (LMessage)COLUMN_MAPPER.visit(r, null);
        assert (result.getStreamName().equals(streamName));
        return result;
    }

    public static List<LMessage> rowsToMessages(String streamName, List<Row> rows) throws LindormException {
        ArrayList<LMessage> result = new ArrayList<LMessage>();
        for (Row row : rows) {
            if (row == null) continue;
            LMessage lMessage = (LMessage)COLUMN_MAPPER.visit(row, null);
            assert (lMessage.getStreamName().equals(streamName));
            result.add(lMessage);
        }
        return result;
    }

    public static Map<byte[], LMessage> messageListToIdempotentIdMap(List<LMessage> lMessages) {
        HashMap<byte[], LMessage> messageMap = new HashMap<byte[], LMessage>();
        for (LMessage msg : lMessages) {
            messageMap.put(msg.getIdempotentId(), msg);
        }
        return messageMap;
    }

    public static void markSelectValueFamily(Select select) {
        select.family(new byte[][]{VALUE_FAMILY_NAME_BYTES});
    }

    public static boolean isSelectValueFamily(LSelect select) {
        return FeedStreamUtils.hasSelectedFamily(select, VALUE_FAMILY_NAME_BYTES);
    }

    public static void markSelectSequenceFamily(Select select) {
        select.family(new byte[][]{SEQUENCE_FAMILY_NAME_BYTES});
    }

    public static boolean isSelectSequenceFamily(LSelect select) {
        return FeedStreamUtils.hasSelectedFamily(select, SEQUENCE_FAMILY_NAME_BYTES);
    }

    public static void markSelectIdempotentFamily(Select select) {
        select.family(new byte[][]{IDEMPOTENT_FAMILY_NAME_BYTES});
    }

    public static boolean isSelectIdempotentFamily(LSelect select) {
        return FeedStreamUtils.hasSelectedFamily(select, IDEMPOTENT_FAMILY_NAME_BYTES);
    }

    private static boolean hasSelectedFamily(LSelect select, byte[] expectedFamily) {
        List<byte[]> families = select.getFamilies();
        return families != null && Bytes.equals(families.get(0), expectedFamily);
    }

    public static void prepareAttrs(List<LMessage> previousMessages, LUpsert upsert) throws IOException {
        ArrayList<Long> previousMessageIds = new ArrayList<Long>(previousMessages.size());
        for (LMessage message : previousMessages) {
            previousMessageIds.add(message.getMessageId());
        }
        FeedStreamAttributes attributes = new FeedStreamAttributes(previousMessageIds);
        upsert.setAttribute(FEED_ATTR, LindormObjectUtils.getBytes(attributes));
    }

    public static boolean hasAttrs(LUpsert upsert) throws IOException {
        return upsert.hasAttribute(FEED_ATTR);
    }

    public static FeedStreamAttributes applyAttrs(LUpsert upsert) throws IOException {
        byte[] attribute = upsert.getAttribute(FEED_ATTR);
        FeedStreamAttributes feedStreamAttributes = new FeedStreamAttributes();
        LindormObjectUtils.getWritable(attribute, feedStreamAttributes);
        return feedStreamAttributes;
    }

    public static int murmurHash3(byte[] bytes) {
        int c1 = -862048943;
        int c2 = 461845907;
        int h1 = 0;
        int roundedEnd = bytes.length & 0xFFFFFFFC;
        for (int i = 0; i < roundedEnd; i += 4) {
            int k1 = bytes[i] & 0xFF | (bytes[i + 1] & 0xFF) << 8 | (bytes[i + 2] & 0xFF) << 16 | bytes[i + 3] << 24;
            k1 *= -862048943;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= 461845907);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
        }
        int k1 = 0;
        switch (bytes.length & 3) {
            case 3: {
                k1 = (bytes[roundedEnd + 2] & 0xFF) << 16;
            }
            case 2: {
                k1 |= (bytes[roundedEnd + 1] & 0xFF) << 8;
            }
            case 1: {
                k1 |= bytes[roundedEnd] & 0xFF;
                k1 *= -862048943;
                k1 = k1 << 15 | k1 >>> 17;
                h1 ^= (k1 *= 461845907);
            }
        }
        h1 ^= bytes.length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    static {
        COLUMN_MAPPER = new StreamRowToMessageVisitor();
        ArrayList<PrimaryKeySchema> pks = new ArrayList<PrimaryKeySchema>(2);
        ArrayList<ColumnSchema> nonPks = new ArrayList<ColumnSchema>(1);
        pks.add(new PrimaryKeySchema(HASH_COLUMN_NAME, DataType.BINARY, 4));
        pks.add(new PrimaryKeySchema(STREAM_NAME_COLUMN_NAME, DataType.STRING));
        nonPks.add(new ColumnSchema(SEQUENCE_FAMILY_NAME, MESSAGE_ID_COLUMN_NAME, DataType.LONG));
        sequencePkSchema = Collections.unmodifiableList(pks);
        sequenceNonPkSchema = Collections.unmodifiableList(nonPks);
        pks = new ArrayList(4);
        nonPks = new ArrayList(1);
        pks.add(new PrimaryKeySchema(HASH_COLUMN_NAME, DataType.BINARY, 4));
        pks.add(new PrimaryKeySchema(STREAM_NAME_COLUMN_NAME, DataType.STRING));
        pks.add(new PrimaryKeySchema(ZERO_COLUMN_NAME, DataType.BINARY, 1));
        pks.add(new PrimaryKeySchema(IDEMPOTENT_ID_COLUMN_NAME, DataType.VARBINARY));
        nonPks.add(new ColumnSchema(IDEMPOTENT_FAMILY_NAME, MESSAGE_ID_COLUMN_NAME, DataType.LONG));
        idempotentPkSchema = Collections.unmodifiableList(pks);
        idempotentNonPkSchema = Collections.unmodifiableList(nonPks);
        pks = new ArrayList(4);
        nonPks = new ArrayList(1);
        pks.add(new PrimaryKeySchema(HASH_COLUMN_NAME, DataType.BINARY, 4));
        pks.add(new PrimaryKeySchema(STREAM_NAME_COLUMN_NAME, DataType.STRING));
        pks.add(new PrimaryKeySchema(MESSAGE_ID_COLUMN_NAME, DataType.LONG));
        nonPks.add(new ColumnSchema(VALUE_FAMILY_NAME, BODY_COLUMN_NAME, DataType.VARBINARY));
        nonPks.add(new ColumnSchema(VALUE_FAMILY_NAME, IDEMPOTENT_ID_COLUMN_NAME, DataType.VARBINARY));
        valuePkSchema = Collections.unmodifiableList(pks);
        valueNonPkSchema = Collections.unmodifiableList(nonPks);
    }
}

