/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LNumericType;
import com.alibaba.lindorm.client.core.types.LWholeNumberType;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LByte
extends LWholeNumberType<Byte> {
    public static final LByte INSTANCE = new LByte();

    private LByte() {
        super(DataType.BYTE, Byte.class);
    }

    @Override
    public int getByteSize() {
        return 1;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType instanceof LNumericType;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[this.getByteSize()];
        DataTypeUtils.encodeByte(((Number)value).byteValue(), ret, 0, sortOrder);
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        long v = 0L;
        try {
            v = (Long)LLong.INSTANCE.toObject(value, actualType);
        }
        catch (IllegalDataException e) {
            throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
        }
        if (v >= -128L && v <= 127L) {
            return (byte)v;
        }
        throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        return DataTypeUtils.decodeByte(value, offset, sortOrder);
    }

    @Override
    public byte[] getNullValue() throws IllegalDataException {
        return this.toBytes((byte)0);
    }
}

