/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.schema.LindormAttribute;
import com.alibaba.lindorm.client.schema.LindormFamilyAttributes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LModifyTableRequest
extends VersionedObjectWithAttributes {
    private String tableName;
    private Integer metaVersion = null;
    private Integer operation = null;
    private List<LindormAttribute> tableAttributes = Collections.emptyList();
    private List<LindormFamilyAttributes> familyAttributes = Collections.emptyList();

    public LModifyTableRequest() {
    }

    public LModifyTableRequest(String tableName, List<LindormAttribute> tableAttributes, List<LindormFamilyAttributes> familyAttributes) throws IllegalRequestException {
        SchemaUtils.checkNullOrEmpty(tableName, "Table name");
        this.tableName = tableName;
        this.setTableAttributes(tableAttributes);
        this.setFamilyAttributes(familyAttributes);
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getMetaVersion() {
        return this.metaVersion;
    }

    public void setMetaVersion(int metaVersion) {
        this.metaVersion = metaVersion;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public List<LindormAttribute> getTableAttributes() {
        return this.tableAttributes;
    }

    public void setTableAttributes(List<LindormAttribute> tableAttributes) {
        this.tableAttributes = tableAttributes == null || tableAttributes.isEmpty() ? Collections.emptyList() : tableAttributes;
    }

    public List<LindormFamilyAttributes> getFamilyAttributes() {
        return this.familyAttributes;
    }

    public void setFamilyAttributes(List<LindormFamilyAttributes> familyAttributes) {
        this.familyAttributes = familyAttributes == null || familyAttributes.isEmpty() ? Collections.emptyList() : familyAttributes;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.tableName);
        WritableUtils.writeVInt(out, this.metaVersion);
        WritableUtils.writeVInt(out, this.operation);
        WritableUtils.writeVInt(out, this.tableAttributes.size());
        for (LindormAttribute lindormAttribute : this.tableAttributes) {
            lindormAttribute.writeTo(out);
        }
        WritableUtils.writeVInt(out, this.familyAttributes.size());
        for (LindormFamilyAttributes lindormFamilyAttributes : this.familyAttributes) {
            lindormFamilyAttributes.writeTo(out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.tableName = WritableUtils.readString(in);
        this.metaVersion = WritableUtils.readVInt(in);
        this.operation = WritableUtils.readVInt(in);
        int tableAttrNum = WritableUtils.readVInt(in);
        this.tableAttributes = new ArrayList<LindormAttribute>(tableAttrNum);
        for (int i = 0; i < tableAttrNum; ++i) {
            LindormAttribute attr = new LindormAttribute();
            attr.readFrom(in);
            this.tableAttributes.add(attr);
        }
        int familyAttrNum = WritableUtils.readVInt(in);
        this.familyAttributes = new ArrayList<LindormFamilyAttributes>(familyAttrNum);
        for (int i = 0; i < familyAttrNum; ++i) {
            LindormFamilyAttributes attr = new LindormFamilyAttributes();
            attr.readFrom(in);
            this.familyAttributes.add(attr);
        }
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.tableName);
        str.append(", metaVersion=");
        str.append(this.metaVersion);
        str.append(", operation=");
        str.append(this.operation);
        str.append(", tableAttrs=[");
        str.append(this.tableAttributes.toString());
        str.append("], familyAttrs=[");
        str.append(this.familyAttributes.toString());
        str.append("]");
        return str.toString();
    }

    public void validate() throws IllegalRequestException {
        boolean nonFamilyAttr;
        boolean nonTableAttr = this.tableAttributes == null || this.tableAttributes.isEmpty();
        boolean bl = nonFamilyAttr = this.familyAttributes == null || this.familyAttributes.isEmpty();
        if (nonTableAttr && nonFamilyAttr) {
            throw new IllegalRequestException("Table attr and family attr cannot be both null or empty.");
        }
        if (this.metaVersion == null) {
            throw new IllegalRequestException("Meta version not set.");
        }
        if (this.operation == null) {
            throw new IllegalRequestException("Operation not set.");
        }
    }
}

