/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.metrics;

import com.alibaba.lindorm.client.core.metrics.Sample;
import com.alibaba.lindorm.client.core.metrics.Snapshot;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class MostRecentlySample
implements Sample {
    private final AtomicLong count = new AtomicLong();
    private final AtomicLongArray values;

    public MostRecentlySample(int reservoirSize) {
        this.values = new AtomicLongArray(reservoirSize);
        this.clear();
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.values.length(); ++i) {
            this.values.set(i, 0L);
        }
        this.count.set(0L);
    }

    @Override
    public int size() {
        long c = this.count.get();
        if (c > (long)this.values.length()) {
            return this.values.length();
        }
        return (int)c;
    }

    @Override
    public void update(long value) {
        long c = this.count.incrementAndGet();
        int pos = (int)((c - 1L) % (long)this.values.length());
        this.values.set(pos, value);
    }

    @Override
    public Snapshot getSnapshot() {
        int s = this.size();
        ArrayList<Long> copy = new ArrayList<Long>(s);
        for (int i = 0; i < s; ++i) {
            copy.add(this.values.get(i));
        }
        return new Snapshot(copy);
    }
}

