/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ServerName
extends VersionedObjectWithAttributes
implements Comparable<ServerName> {
    public static final String SERVERNAME_SEPARATOR = ",";
    private String servername;
    private String hostname;
    private int port;
    private long startcode;

    public ServerName() {
    }

    public ServerName(String hostname, int port, long startcode) {
        this.hostname = hostname;
        this.port = port;
        this.startcode = startcode;
        this.servername = ServerName.getServerName(hostname, port, startcode);
    }

    @Override
    public String toString() {
        return this.getServerName();
    }

    public String getServerName() {
        return this.servername;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public long getStartcode() {
        return this.startcode;
    }

    public void setServername(String servername) {
        this.servername = servername;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setStartcode(long startcode) {
        this.startcode = startcode;
    }

    @Override
    public int compareTo(ServerName other) {
        int compare = this.getHostname().toLowerCase().compareTo(other.getHostname().toLowerCase());
        if (compare != 0) {
            return compare;
        }
        compare = this.getPort() - other.getPort();
        if (compare != 0) {
            return compare;
        }
        return (int)(this.getStartcode() - other.getStartcode());
    }

    public int hashCode() {
        return this.servername.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ServerName)) {
            return false;
        }
        return this.compareTo((ServerName)o) == 0;
    }

    public static String getServerName(String hostName, int port, long startcode) {
        StringBuilder name = new StringBuilder(hostName.length() + 1 + 5 + 1 + 13);
        name.append(hostName);
        name.append(SERVERNAME_SEPARATOR);
        name.append(port);
        name.append(SERVERNAME_SEPARATOR);
        name.append(startcode);
        return name.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.hostname);
        WritableUtils.writeVInt(out, this.port);
        WritableUtils.writeVLong(out, this.startcode);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.hostname = WritableUtils.readString(in);
        this.port = WritableUtils.readVInt(in);
        this.startcode = WritableUtils.readVLong(in);
        this.servername = ServerName.getServerName(this.hostname, this.port, this.startcode);
    }
}

