/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class RangeRouter
extends VersionedObjectWithAttributes {
    private String priorityIDC = null;
    private TreeMap<byte[], String> rangeMap = null;

    public RangeRouter() {
    }

    public RangeRouter(String priorityIDC) {
        assert (priorityIDC != null);
        this.priorityIDC = priorityIDC;
    }

    public RangeRouter(TreeMap<byte[], String> rangeMap) throws IOException {
        if (Bytes.compareTo(rangeMap.firstKey(), LindormClientConstants.EMPTY_BYTE_ARRAY) != 0) {
            throw new IOException("Tree map must start with EMPTY_START_ROW");
        }
        this.rangeMap = rangeMap;
    }

    public String getPriorityIDCOfRow(byte[] routeKey) {
        if (this.priorityIDC != null) {
            return this.priorityIDC;
        }
        if (routeKey == null) {
            return null;
        }
        Map.Entry<byte[], String> entry = this.rangeMap.floorEntry(routeKey);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map<byte[], String> getRangeMap() {
        return this.rangeMap;
    }

    public String getPriorityIDC() {
        return this.priorityIDC;
    }

    public void setPriorityIDC(String priorityIDC) {
        this.priorityIDC = priorityIDC;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.priorityIDC);
        if (this.rangeMap != null) {
            WritableUtils.writeVInt(out, this.rangeMap.size());
            for (Map.Entry<byte[], String> entry : this.rangeMap.entrySet()) {
                Bytes.writeByteArray(out, entry.getKey());
                WritableUtils.writeString(out, entry.getValue());
            }
        } else {
            WritableUtils.writeVInt(out, 0);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.priorityIDC = WritableUtils.readString(in);
        int size = WritableUtils.readVInt(in);
        if (size > 0) {
            this.rangeMap = new TreeMap(Bytes.BYTES_COMPARATOR);
            for (int i = 0; i < size; ++i) {
                byte[] key = Bytes.readByteArray(in);
                String value = WritableUtils.readString(in);
                this.rangeMap.put(key, value);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PriorityIDC=").append(this.priorityIDC);
        if (this.rangeMap != null) {
            builder.append(", splits={");
            ArrayList<byte[]> keys = new ArrayList<byte[]>(this.rangeMap.keySet());
            int size = keys.size();
            for (int i = 0; i < size; ++i) {
                byte[] b = (byte[])keys.get(i);
                String begin = Bytes.toStringBinary(b);
                byte[] e = null;
                e = i + 1 >= size ? LindormClientConstants.EMPTY_END_ROW : (byte[])keys.get(i + 1);
                String end = Bytes.toStringBinary(e);
                String idc = this.rangeMap.get(b);
                builder.append("[").append(begin).append(",").append(end).append(")").append("->").append(idc);
                if (i == size - 1) continue;
                builder.append(",");
            }
            builder.append("}");
        }
        return builder.toString();
    }
}

