/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.AndOrExpression;
import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionList;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.List;

public class OrExpression
extends AndOrExpression {
    public OrExpression() {
        super(ConditionList.LogicalOp.OR);
    }

    public OrExpression(Condition ... conditions) throws IllegalRequestException {
        super(ConditionList.LogicalOp.OR);
        OrExpression.validateChildrenConditions(conditions);
        this.conditions = CollectionUtils.newArrayListWithCapacity(conditions.length);
        for (Condition expr : conditions) {
            OrExpression.validateChildrenCondition(expr);
            this.conditions.add(expr);
        }
    }

    public OrExpression(List<Expression> conditions) throws IllegalRequestException {
        super(ConditionList.LogicalOp.OR);
        OrExpression.validateChildrenConditions(conditions);
        this.conditions = CollectionUtils.newArrayListWithCapacity(conditions.size());
        for (Expression expr : conditions) {
            OrExpression.validateChildrenCondition(expr);
            this.conditions.add((Condition)expr);
        }
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws LindormException {
        OrExpression.validateChildrenConditions(this.conditions);
        List<T> results = this.acceptChildren(visitor, this.conditions);
        return visitor.visitLeave(this, results);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof OrExpression)) {
            return false;
        }
        OrExpression c = (OrExpression)obj;
        return this.conditions.equals(c.conditions);
    }

    @Override
    protected boolean isStopValue(boolean value) {
        return value;
    }
}

