/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.ColumnSlot;
import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.compile.QueryFilterInfo;
import java.util.List;

public class PrefixQuery {
    private final List<Interval> prefixes;
    private final QueryFilterInfo filterInfo;
    private int hashCode = 0;

    public PrefixQuery(List<Interval> prefixes, QueryFilterInfo filterInfo) {
        this.prefixes = prefixes;
        this.filterInfo = filterInfo;
    }

    public List<Interval> getPrefixes() {
        return this.prefixes;
    }

    public QueryFilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public int hashCode() {
        if (this.hashCode == 0 && (this.prefixes != null || this.filterInfo != null)) {
            int result = 0;
            if (this.prefixes != null) {
                for (Interval prefix : this.prefixes) {
                    result = 31 * result + prefix.hashCode();
                }
            }
            if (this.filterInfo != null) {
                this.hashCode = result * 31 + this.filterInfo.hashCode();
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PrefixQuery)) {
            return false;
        }
        PrefixQuery other = (PrefixQuery)obj;
        if (this.prefixes == null ? other.prefixes != null : !this.prefixes.equals(other.prefixes)) {
            return false;
        }
        return this.filterInfo == null ? other.filterInfo == null : this.filterInfo.equals(other.filterInfo);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("prefixes: ");
        builder.append(this.prefixes);
        builder.append(" - ");
        if (this.filterInfo == null || this.filterInfo.getColumnSlots() == null) {
            builder.append("filter: []");
        } else {
            List<ColumnSlot> columnSlots = this.filterInfo.getColumnSlots();
            builder.append("filter: [");
            for (int i = 0; i < columnSlots.size(); ++i) {
                if (i != 0) {
                    builder.append(" AND ");
                }
                builder.append(columnSlots.get(i));
            }
            builder.append("]");
        }
        return builder.toString();
    }
}

