/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.read.metadata.holder;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ConverterKeyBuild;
import com.alibaba.excel.converters.DefaultConverterLoader;
import com.alibaba.excel.enums.HolderEnum;
import com.alibaba.excel.metadata.AbstractHolder;
import com.alibaba.excel.read.listener.ModelBuildEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadBasicParameter;
import com.alibaba.excel.read.metadata.ReadWorkbook;
import com.alibaba.excel.read.metadata.holder.ReadHolder;
import com.alibaba.excel.read.metadata.property.ExcelReadHeadProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadHolder
extends AbstractHolder
implements ReadHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReadHolder.class);
    private Integer headRowNumber;
    private ExcelReadHeadProperty excelReadHeadProperty;
    private List<ReadListener> readListenerList;

    public AbstractReadHolder(ReadBasicParameter readBasicParameter, AbstractReadHolder parentAbstractReadHolder, Boolean convertAllFiled) {
        super(readBasicParameter, parentAbstractReadHolder);
        Boolean useDefaultListener;
        if (readBasicParameter.getUse1904windowing() == null && parentAbstractReadHolder != null) {
            this.getGlobalConfiguration().setUse1904windowing(parentAbstractReadHolder.getGlobalConfiguration().getUse1904windowing());
        } else {
            this.getGlobalConfiguration().setUse1904windowing(readBasicParameter.getUse1904windowing());
        }
        if (readBasicParameter.getUseScientificFormat() == null) {
            if (parentAbstractReadHolder == null) {
                this.getGlobalConfiguration().setUseScientificFormat(Boolean.FALSE);
            } else {
                this.getGlobalConfiguration().setUseScientificFormat(parentAbstractReadHolder.getGlobalConfiguration().getUseScientificFormat());
            }
        } else {
            this.getGlobalConfiguration().setUseScientificFormat(readBasicParameter.getUseScientificFormat());
        }
        this.excelReadHeadProperty = new ExcelReadHeadProperty(this, this.getClazz(), this.getHead(), convertAllFiled);
        this.headRowNumber = readBasicParameter.getHeadRowNumber() == null ? (parentAbstractReadHolder == null ? (this.excelReadHeadProperty.hasHead() ? Integer.valueOf(this.excelReadHeadProperty.getHeadRowNumber()) : Integer.valueOf(1)) : parentAbstractReadHolder.getHeadRowNumber()) : readBasicParameter.getHeadRowNumber();
        this.readListenerList = parentAbstractReadHolder == null ? new ArrayList<ReadListener>() : new ArrayList<ReadListener>(parentAbstractReadHolder.getReadListenerList());
        if (HolderEnum.WORKBOOK.equals((Object)this.holderType()) && ((useDefaultListener = ((ReadWorkbook)readBasicParameter).getUseDefaultListener()) == null || useDefaultListener.booleanValue())) {
            this.readListenerList.add(new ModelBuildEventListener());
        }
        if (readBasicParameter.getCustomReadListenerList() != null && !readBasicParameter.getCustomReadListenerList().isEmpty()) {
            this.readListenerList.addAll(readBasicParameter.getCustomReadListenerList());
        }
        if (parentAbstractReadHolder == null) {
            this.setConverterMap(DefaultConverterLoader.loadDefaultReadConverter());
        } else {
            this.setConverterMap(new HashMap<String, Converter>(parentAbstractReadHolder.getConverterMap()));
        }
        if (readBasicParameter.getCustomConverterList() != null && !readBasicParameter.getCustomConverterList().isEmpty()) {
            for (Converter converter : readBasicParameter.getCustomConverterList()) {
                this.getConverterMap().put(ConverterKeyBuild.buildKey(converter.supportJavaTypeKey(), converter.supportExcelTypeKey()), converter);
            }
        }
    }

    public List<ReadListener> getReadListenerList() {
        return this.readListenerList;
    }

    public void setReadListenerList(List<ReadListener> readListenerList) {
        this.readListenerList = readListenerList;
    }

    public ExcelReadHeadProperty getExcelReadHeadProperty() {
        return this.excelReadHeadProperty;
    }

    public void setExcelReadHeadProperty(ExcelReadHeadProperty excelReadHeadProperty) {
        this.excelReadHeadProperty = excelReadHeadProperty;
    }

    public Integer getHeadRowNumber() {
        return this.headRowNumber;
    }

    public void setHeadRowNumber(Integer headRowNumber) {
        this.headRowNumber = headRowNumber;
    }

    @Override
    public List<ReadListener> readListenerList() {
        return this.getReadListenerList();
    }

    @Override
    public ExcelReadHeadProperty excelReadHeadProperty() {
        return this.getExcelReadHeadProperty();
    }
}

