/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import com.alibaba.excel.metadata.DataFormatter;
import com.alibaba.excel.metadata.GlobalConfiguration;

public class NumberDataFormatterUtils {
    private static final ThreadLocal<DataFormatter> DATA_FORMATTER_THREAD_LOCAL = new ThreadLocal();

    public static String format(Double data, Integer dataFormat, String dataFormatString, GlobalConfiguration globalConfiguration) {
        DataFormatter dataFormatter = DATA_FORMATTER_THREAD_LOCAL.get();
        if (dataFormatter == null) {
            dataFormatter = globalConfiguration != null ? new DataFormatter(globalConfiguration.getLocale(), globalConfiguration.getUse1904windowing()) : new DataFormatter();
            DATA_FORMATTER_THREAD_LOCAL.set(dataFormatter);
        }
        return dataFormatter.format(data, dataFormat, dataFormatString);
    }

    public static void removeThreadLocalCache() {
        DATA_FORMATTER_THREAD_LOCAL.remove();
    }
}

