/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis.v03.handlers;

import com.alibaba.excel.analysis.v03.AbstractXlsRecordHandler;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.read.metadata.ReadSheet;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.Record;

public class BofRecordHandler
extends AbstractXlsRecordHandler {
    private List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
    private BoundSheetRecord[] orderedBsrs;
    private int sheetIndex;
    private List<ReadSheet> sheets;
    private AnalysisContext context;
    private boolean alreadyInit;

    public BofRecordHandler(AnalysisContext context, List<ReadSheet> sheets, boolean alreadyInit) {
        this.context = context;
        this.sheets = sheets;
        this.alreadyInit = alreadyInit;
    }

    @Override
    public boolean support(Record record) {
        return 133 == record.getSid() || 2057 == record.getSid();
    }

    @Override
    public void processRecord(Record record) {
        BOFRecord br;
        if (record.getSid() == 133) {
            this.boundSheetRecords.add((BoundSheetRecord)record);
        } else if (record.getSid() == 2057 && (br = (BOFRecord)record).getType() == 16) {
            if (this.orderedBsrs == null) {
                this.orderedBsrs = BoundSheetRecord.orderByBofPosition(this.boundSheetRecords);
            }
            if (!this.alreadyInit) {
                ReadSheet readSheet = new ReadSheet(this.sheetIndex, this.orderedBsrs[this.sheetIndex].getSheetname());
                this.sheets.add(readSheet);
            }
            if (this.context.readSheetHolder() != null) {
                if (this.sheetIndex == this.context.readSheetHolder().getSheetNo()) {
                    this.context.readWorkbookHolder().setIgnoreRecord03(Boolean.FALSE);
                } else {
                    this.context.readWorkbookHolder().setIgnoreRecord03(Boolean.TRUE);
                }
            }
            ++this.sheetIndex;
        }
    }

    @Override
    public void init() {
        this.sheetIndex = 0;
        this.orderedBsrs = null;
        this.boundSheetRecords.clear();
        if (!this.alreadyInit) {
            this.sheets.clear();
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

