/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dcm;

import edu.umd.cs.findbugs.annotations.ReturnValuesAreNonnullByDefault;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
@Immutable
public final class DnsCacheEntry
implements Serializable {
    private static final long serialVersionUID = -7476648934387757732L;
    private final String host;
    private final String[] ips;
    private final long expiration;

    public String getHost() {
        return this.host;
    }

    public String[] getIps() {
        return (String[])this.ips.clone();
    }

    public String getIp() {
        return this.ips[0];
    }

    public Date getExpiration() {
        return new Date(this.expiration);
    }

    @Deprecated
    public DnsCacheEntry(String host, @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}) String[] ips, @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}) Date expiration) {
        this.host = host;
        this.ips = ips;
        this.expiration = expiration.getTime();
    }

    public DnsCacheEntry(String host, @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}) String[] ips, long expiration) {
        this.host = host;
        this.ips = ips;
        this.expiration = expiration;
    }

    public String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        return "DnsCacheEntry{host='" + this.host + '\'' + ", ips=" + Arrays.toString(this.ips) + ", expiration=" + dateFormat.format(this.expiration) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsCacheEntry that = (DnsCacheEntry)o;
        if (this.expiration != that.expiration) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        return Arrays.equals(this.ips, that.ips);
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.ips);
        result = 31 * result + (int)(this.expiration ^ this.expiration >>> 32);
        return result;
    }
}

