/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.configdata;

import com.alibaba.cloud.nacos.refresh.NacosConfigRefreshEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;

public class NacosConfigRefreshEventListener
implements SmartApplicationListener,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(NacosConfigRefreshEventListener.class);
    private ApplicationContext applicationContext;

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return NacosConfigRefreshEvent.class.isAssignableFrom(eventType);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        this.applicationContext.publishEvent((ApplicationEvent)new RefreshEvent(event.getSource(), null, "Refresh Nacos config"));
        if (log.isDebugEnabled()) {
            log.debug(String.format("Refresh Nacos config group=%s,dataId=%s", ((NacosConfigRefreshEvent)event).getGroup(), ((NacosConfigRefreshEvent)event).getDataId()));
        }
    }
}

