/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.configdata;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.NacosPropertySourceRepository;
import com.alibaba.cloud.nacos.client.NacosPropertySource;
import com.alibaba.cloud.nacos.configdata.NacosConfigDataResource;
import com.alibaba.cloud.nacos.parser.NacosDataParserHandler;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.core.env.PropertySource;

public class NacosConfigDataLoader
implements ConfigDataLoader<NacosConfigDataResource> {
    private final Log log;

    public NacosConfigDataLoader(Log log) {
        this.log = log;
    }

    public ConfigData load(ConfigDataLoaderContext context, NacosConfigDataResource resource) {
        return this.doLoad(context, resource);
    }

    public ConfigData doLoad(ConfigDataLoaderContext context, NacosConfigDataResource resource) {
        try {
            ConfigService configService = this.getBean(context, NacosConfigManager.class).getConfigService();
            NacosConfigProperties properties = this.getBean(context, NacosConfigProperties.class);
            NacosConfigDataResource.NacosItemConfig config = resource.getConfig();
            List<PropertySource<?>> propertySources = this.pullConfig(configService, config.getGroup(), config.getDataId(), config.getSuffix(), properties.getTimeout());
            NacosPropertySource propertySource = new NacosPropertySource(propertySources, config.getGroup(), config.getDataId(), new Date(), config.isRefreshEnabled());
            NacosPropertySourceRepository.collectNacosPropertySource(propertySource);
            return new ConfigData(propertySources, new ConfigData.Option[0]);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Error getting properties from nacos: " + (Object)((Object)resource)), (Throwable)e);
            }
            if (!resource.isOptional()) {
                throw new ConfigDataResourceNotFoundException((ConfigDataResource)resource, (Throwable)e);
            }
            return null;
        }
    }

    private List<PropertySource<?>> pullConfig(ConfigService configService, String group, String dataId, String suffix, long timeout) throws NacosException, IOException {
        String config = configService.getConfig(dataId, group, timeout);
        return NacosDataParserHandler.getInstance().parseNacosData(dataId, config, suffix);
    }

    protected <T> T getBean(ConfigDataLoaderContext context, Class<T> type) {
        if (context.getBootstrapContext().isRegistered(type)) {
            return (T)context.getBootstrapContext().get(type);
        }
        return null;
    }
}

