/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.spring.boot.rds.actuate.endpoint;

import com.alibaba.cloud.spring.boot.rds.actuate.endpoint.AbstractInvoker;
import com.aliyuncs.rds.model.v20140815.DescribeDBInstancesResponse;
import com.aliyuncs.rds.model.v20140815.DescribeErrorLogsRequest;
import com.aliyuncs.rds.model.v20140815.DescribeErrorLogsResponse;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="rdsError100")
public class RdsErrorEndpoint
extends AbstractInvoker {
    private static final String TIME_PATTEN = "yyyy-MM-dd'T'HH:mm'Z'";
    private static final Long TIME_RANGE = 604800000L;

    @ReadOperation
    public Map<String, List<DescribeErrorLogsResponse.ErrorLog>> error() {
        List<DescribeDBInstancesResponse.DBInstance> instances = this.getInstances();
        Map<String, List<DescribeErrorLogsResponse.ErrorLog>> map = instances.stream().collect(Collectors.toMap(DescribeDBInstancesResponse.DBInstance::getDBInstanceId, this::error));
        return map;
    }

    @ReadOperation
    public List<DescribeErrorLogsResponse.ErrorLog> errors(@Selector String instanceId) {
        DescribeDBInstancesResponse.DBInstance instance = this.getInstance(instanceId);
        return this.error(instance);
    }

    @ReadOperation
    public List<DescribeErrorLogsResponse.ErrorLog> error(@Selector String instanceId, @Selector String start, @Selector String end) {
        DescribeDBInstancesResponse.DBInstance instance = this.getInstance(instanceId);
        return this.error(instance, start, end);
    }

    private List<DescribeErrorLogsResponse.ErrorLog> error(DescribeDBInstancesResponse.DBInstance instance) {
        SimpleDateFormat format = new SimpleDateFormat(TIME_PATTEN);
        Date end = new Date();
        Date start = new Date(end.getTime() - TIME_RANGE);
        return this.error(instance, format.format(start), format.format(end));
    }

    private List<DescribeErrorLogsResponse.ErrorLog> error(DescribeDBInstancesResponse.DBInstance instance, String start, String end) {
        if (instance == null) {
            return Collections.emptyList();
        }
        DescribeErrorLogsRequest request = new DescribeErrorLogsRequest();
        request.setSysRegionId(instance.getRegionId());
        request.setDBInstanceId(instance.getDBInstanceId());
        request.setStartTime(start);
        request.setEndTime(end);
        request.setPageNumber(Integer.valueOf(1));
        request.setPageSize(Integer.valueOf(100));
        DescribeErrorLogsResponse resp = (DescribeErrorLogsResponse)this.invoke(request);
        if (resp == null) {
            return Collections.emptyList();
        }
        return resp.getItems();
    }
}

