/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.spring.boot.rds.actuate.autoconfigure;

import com.alibaba.cloud.spring.boot.context.env.AliCloudProperties;
import com.alibaba.cloud.spring.boot.rds.actuate.endpoint.RdsErrorEndpoint;
import com.alibaba.cloud.spring.boot.rds.actuate.endpoint.RdsInstancesEndpoint;
import com.alibaba.cloud.spring.boot.rds.actuate.endpoint.RdsPerformanceEndpoint;
import com.alibaba.cloud.spring.boot.rds.actuate.endpoint.RdsSlowEndpoint;
import com.alibaba.cloud.spring.boot.rds.env.RdsProperties;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={RdsProperties.class})
@ConditionalOnClass(value={Endpoint.class})
@ConditionalOnEnabledHealthIndicator(value="rds")
public class RdsEndpointAutoConfiguration {
    @Autowired
    private RdsProperties rdsProperties;

    @Bean
    @ConditionalOnMissingBean(value={IAcsClient.class})
    public IAcsClient iAcsClient(AliCloudProperties aliCloudProperties) {
        DefaultProfile profile = DefaultProfile.getProfile((String)this.rdsProperties.getDefaultRegionId(), (String)aliCloudProperties.getAccessKey(), (String)aliCloudProperties.getSecretKey());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        return client;
    }

    @Bean
    public RdsInstancesEndpoint rdsInstanceEndpoint() {
        return new RdsInstancesEndpoint();
    }

    @Bean
    public RdsSlowEndpoint rdsSlowEndpoint() {
        return new RdsSlowEndpoint();
    }

    @Bean
    public RdsPerformanceEndpoint rdsPerformanceEndpoint() {
        return new RdsPerformanceEndpoint();
    }

    @Bean
    public RdsErrorEndpoint errorEndpoint() {
        return new RdsErrorEndpoint();
    }
}

