/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.cloud.context.statistics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * @author xiaolongzuo
 */
abstract class AbstractReportTask implements Runnable {

    private static final Logger log = LoggerFactory.getLogger(AbstractReportTask.class);

    private Map<String, String> params;

    private long interval;

    AbstractReportTask(long interval, Map<String, String> params) {
        this.interval = interval;
        this.params = params;
    }

    @Override
    public void run() {
        while (true) {
            try {
                quickRequest(getUrl(), this.params);
            } catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("Alibaba cloud report failed : " + e.getMessage());
                }
            }
            try {
                Thread.sleep(interval);
            } catch (InterruptedException e) {
                //ignore
                break;
            }
        }
    }

    protected abstract String getUrl();

    protected abstract void quickRequest(String url, Map<String, String> params);
}
