/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.cloud.context.scx;

import com.alibaba.cloud.context.AliCloudConfiguration;
import com.alibaba.cloud.context.edas.*;
import com.alibaba.edas.schedulerx.SchedulerXClient;
import com.aliyuncs.edas.model.v20170801.GetSecureTokenResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/**
 * @author xiaolongzuo
 */
public class AliCloudScxInitializer {

    private static final String TEST_REGION = "cn-test";

    private static final String DEFAULT_KEY = "123456";

    private AliCloudScxInitializer() {
    }

    public static SchedulerXClient initialize(AliCloudConfiguration aliCloudConfiguration,
                                              EdasConfiguration edasConfiguration, ScxConfiguration scxConfiguration) {
        return initialize(aliCloudConfiguration, edasConfiguration, scxConfiguration,
            AliCloudEdasSdkFactory.getDefaultAliCloudEdasSdk(aliCloudConfiguration, edasConfiguration.getRegionId()));
    }

    public static SchedulerXClient initialize(AliCloudConfiguration aliCloudConfiguration,
                                              EdasConfiguration edasConfiguration, ScxConfiguration scxConfiguration,
                                              AliCloudEdasSdk aliCloudEdasSdk) {
        Assert.isTrue(!StringUtils.isEmpty(scxConfiguration.getGroupId()),
            "${spring.cloud.alicloud.scx.group-id} can't be null.");
        SchedulerXClient schedulerXClient = new SchedulerXClient();
        schedulerXClient.setGroupId(scxConfiguration.getGroupId());

        EdasChangeOrderConfiguration edasChangeOrderConfiguration = EdasChangeOrderConfigurationFactory
            .getEdasChangeOrderConfiguration();
        if (edasChangeOrderConfiguration.isEdasManaged()) {
            if (edasChangeOrderConfiguration.getRegionId() != null) {
                schedulerXClient
                    .setRegionName(edasChangeOrderConfiguration.getRegionId());
            } else {
                Assert.isTrue(!StringUtils.isEmpty(edasConfiguration.getNamespace()),
                    "${spring.cloud.alicloud.edas.namespace} can't be null.");
                schedulerXClient.setRegionName(edasConfiguration.getRegionId());
            }
            schedulerXClient.setDomainName(scxConfiguration.getDomainName());
            schedulerXClient
                .setAccessKey(edasChangeOrderConfiguration.getDauthAccessKey());
            schedulerXClient
                .setSecretKey(edasChangeOrderConfiguration.getDauthSecretKey());
        } else if (TEST_REGION.equals(edasConfiguration.getNamespace())) {
            Assert.isTrue(!StringUtils.isEmpty(edasConfiguration.getNamespace()),
                "${spring.cloud.alicloud.edas.namespace} can't be null.");
            schedulerXClient.setRegionName(edasConfiguration.getNamespace());
            schedulerXClient.setAccessKey(DEFAULT_KEY);
            schedulerXClient.setSecretKey(DEFAULT_KEY);
        } else {
            Assert.isTrue(!StringUtils.isEmpty(edasConfiguration.getNamespace()),
                "${spring.cloud.alicloud.edas.namespace} can't be null.");
            Assert.isTrue(!StringUtils.isEmpty(aliCloudConfiguration.getAccessKey()),
                "${spring.cloud.alicloud.access-key} can't be empty.");
            Assert.isTrue(!StringUtils.isEmpty(aliCloudConfiguration.getSecretKey()),
                "${spring.cloud.alicloud.secret-key} can't be empty.");
            GetSecureTokenResponse.SecureToken secureToken = aliCloudEdasSdk
                .getSecureToken(edasConfiguration.getNamespace());
            schedulerXClient.setRegionName(edasConfiguration.getRegionId());
            schedulerXClient.setDomainName(scxConfiguration.getDomainName());
            schedulerXClient.setAccessKey(secureToken.getAccessKey());
            schedulerXClient.setSecretKey(secureToken.getSecretKey());
        }
        return schedulerXClient;
    }
}
