/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.agent.studio.loader;

import com.alibaba.cloud.ai.agent.studio.loader.AgentLoader;
import com.alibaba.cloud.ai.graph.agent.Agent;
import com.alibaba.cloud.ai.graph.agent.BaseAgent;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

class AgentStaticLoader
implements AgentLoader {
    private Map<String, BaseAgent> agents = new ConcurrentHashMap<String, BaseAgent>();

    public AgentStaticLoader() {
    }

    public AgentStaticLoader(BaseAgent ... agents) {
        this.agents = Arrays.stream(agents).collect(Collectors.toUnmodifiableMap(Agent::name, Function.identity()));
    }

    @Override
    @Nonnull
    public List<String> listAgents() {
        return this.agents.keySet().stream().toList();
    }

    @Override
    public BaseAgent loadAgent(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Agent name cannot be null or empty");
        }
        BaseAgent agent = this.agents.get(name);
        if (agent == null) {
            throw new NoSuchElementException("Agent not found: " + name);
        }
        return agent;
    }
}

