/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.agent.studio.dto.messages;

import com.alibaba.cloud.ai.agent.studio.dto.messages.MessageDTO;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.messages.UserMessage;

public class UserMessageDTO
implements MessageDTO {
    @JsonProperty(value="messageType")
    private String messageType = "user";
    @JsonProperty(value="content")
    private String content;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata = new HashMap<String, Object>();
    @JsonProperty(value="media")
    private List<MediaDTO> media = new ArrayList<MediaDTO>();

    public UserMessageDTO() {
    }

    public UserMessageDTO(String content) {
        this();
        this.content = content;
    }

    public UserMessageDTO(UserMessage message) {
        this();
        this.content = message.getText();
        this.metadata = new HashMap<String, Object>(message.getMetadata());
    }

    public UserMessage toUserMessage() {
        return new UserMessage(this.content);
    }

    @Override
    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public List<MediaDTO> getMedia() {
        return this.media;
    }

    public void setMedia(List<MediaDTO> media) {
        this.media = media;
    }

    public static class MediaDTO {
        @JsonProperty(value="mimeType")
        private String mimeType;
        @JsonProperty(value="data")
        private Object data;

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }
    }
}

