/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.agent.studio.dto.messages;

import com.alibaba.cloud.ai.agent.studio.dto.messages.MessageDTO;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.messages.ToolResponseMessage;

public class ToolResponseMessageDTO
implements MessageDTO {
    @JsonProperty(value="messageType")
    private String messageType = "tool";
    @JsonProperty(value="content")
    private String content;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata = new HashMap<String, Object>();
    @JsonProperty(value="responses")
    private List<ToolResponseDTO> responses = new ArrayList<ToolResponseDTO>();

    public ToolResponseMessageDTO() {
    }

    public ToolResponseMessageDTO(String content) {
        this();
        this.content = content;
    }

    public ToolResponseMessageDTO(ToolResponseMessage message) {
        this();
        this.content = message.getText();
        this.metadata = new HashMap<String, Object>(message.getMetadata());
        if (message.getResponses() != null && !message.getResponses().isEmpty()) {
            this.responses = new ArrayList<ToolResponseDTO>();
            for (ToolResponseMessage.ToolResponse response : message.getResponses()) {
                this.responses.add(new ToolResponseDTO(response));
            }
        }
    }

    public ToolResponseMessage toToolResponseMessage() {
        ArrayList<ToolResponseMessage.ToolResponse> springResponses = new ArrayList<ToolResponseMessage.ToolResponse>();
        if (this.responses != null) {
            for (ToolResponseDTO dto : this.responses) {
                springResponses.add(dto.toToolResponse());
            }
        }
        return new ToolResponseMessage(springResponses, this.metadata);
    }

    @Override
    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public List<ToolResponseDTO> getResponses() {
        return this.responses;
    }

    public void setResponses(List<ToolResponseDTO> responses) {
        this.responses = responses;
    }

    public static class ToolResponseDTO {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="responseData")
        private String responseData;

        public ToolResponseDTO() {
        }

        public ToolResponseDTO(ToolResponseMessage.ToolResponse response) {
            this.id = response.id();
            this.name = response.name();
            this.responseData = response.responseData();
        }

        public ToolResponseMessage.ToolResponse toToolResponse() {
            return new ToolResponseMessage.ToolResponse(this.id, this.name, this.responseData);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getResponseData() {
            return this.responseData;
        }

        public void setResponseData(String responseData) {
            this.responseData = responseData;
        }
    }
}

