/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.agent.studio.dto.messages;

import com.alibaba.cloud.ai.agent.studio.dto.messages.AssistantMessageDTO;
import com.alibaba.cloud.ai.agent.studio.dto.messages.ToolRequestConfirmMessageDTO;
import com.alibaba.cloud.ai.agent.studio.dto.messages.ToolRequestMessageDTO;
import com.alibaba.cloud.ai.agent.studio.dto.messages.ToolResponseMessageDTO;
import com.alibaba.cloud.ai.agent.studio.dto.messages.UserMessageDTO;
import com.alibaba.cloud.ai.graph.action.InterruptionMetadata;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="messageType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=AssistantMessageDTO.class, name="assistant"), @JsonSubTypes.Type(value=UserMessageDTO.class, name="user"), @JsonSubTypes.Type(value=ToolResponseMessageDTO.class, name="tool"), @JsonSubTypes.Type(value=ToolRequestMessageDTO.class, name="tool-request"), @JsonSubTypes.Type(value=ToolRequestConfirmMessageDTO.class, name="tool-confirm")})
public interface MessageDTO {
    public String getMessageType();

    public String getContent();

    public static class MessageDTOFactory {
        public static MessageDTO fromMessage(Message message) {
            if (message == null) {
                return null;
            }
            if (message instanceof AssistantMessage) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                if (assistantMessage.hasToolCalls()) {
                    return new ToolRequestMessageDTO(assistantMessage);
                }
                return new AssistantMessageDTO(assistantMessage);
            }
            if (message instanceof UserMessage) {
                return new UserMessageDTO((UserMessage)message);
            }
            if (message instanceof ToolResponseMessage) {
                return new ToolResponseMessageDTO((ToolResponseMessage)message);
            }
            throw new IllegalArgumentException("Unsupported message type: " + message.getClass().getName());
        }

        public static ToolRequestConfirmMessageDTO fromInterruptionMetadata(InterruptionMetadata interruptionMetadata) {
            if (interruptionMetadata == null) {
                return null;
            }
            return new ToolRequestConfirmMessageDTO(interruptionMetadata);
        }

        public static Message toMessage(MessageDTO dto) {
            if (dto == null) {
                return null;
            }
            if (dto instanceof ToolRequestMessageDTO) {
                return ((ToolRequestMessageDTO)dto).toAssistantMessage();
            }
            if (dto instanceof AssistantMessageDTO) {
                return ((AssistantMessageDTO)dto).toAssistantMessage();
            }
            if (dto instanceof UserMessageDTO) {
                return ((UserMessageDTO)dto).toUserMessage();
            }
            if (dto instanceof ToolResponseMessageDTO) {
                return ((ToolResponseMessageDTO)dto).toToolResponseMessage();
            }
            throw new IllegalArgumentException("Unsupported DTO type: " + dto.getClass().getName());
        }
    }
}

